/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.nucleus_sync.client.ClientException;
import org.alfresco.hxi_connector.nucleus_sync.dto.IamUser;
import org.alfresco.hxi_connector.nucleus_sync.dto.IamUsersOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupInput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupListOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupMemberAssignmentInput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupMembershipListOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupMembershipOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusUserMappingInput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusUserMappingListOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusUserMappingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class NucleusClient {
    private final WebClient webClient;
    private final ObjectMapper objectMapper;
    private final AuthService authService;
    private final String systemId;
    private final String nucleusBaseUrl;
    private final String idpBaseUrl;
    private final int timeoutInMin;
    private final int deleteBatchSize;
    private static final Logger LOGGER = LoggerFactory.getLogger(NucleusClient.class);

    @Autowired
    public NucleusClient(AuthService authService, @Value(value="${nucleus.system-id}") String systemId, @Value(value="${nucleus.base-url}") String nucleusBaseUrl, @Value(value="${nucleus.idp-base-url}") String idpBaseUrl, @Value(value="${nucleus.delete-group-member-batch-size:50}") int deleteBatchSize, @Value(value="${http-client.timeout-minutes:5}") int timeoutInMins) {
        this(WebClient.builder().build(), new ObjectMapper(), authService, systemId, nucleusBaseUrl, idpBaseUrl, deleteBatchSize, timeoutInMins);
    }

    NucleusClient(WebClient webClient, ObjectMapper objectMapper, AuthService authService, String systemId, String nucleusBaseUrl, String idpBaseUrl, int deleteBatchSize, int timeoutInMin) {
        this.webClient = webClient;
        this.objectMapper = objectMapper;
        this.authService = authService;
        this.systemId = systemId;
        this.nucleusBaseUrl = nucleusBaseUrl;
        this.idpBaseUrl = idpBaseUrl;
        this.timeoutInMin = timeoutInMin;
        this.deleteBatchSize = deleteBatchSize;
    }

    public List<IamUser> getAllIamUsers() {
        String url = this.idpBaseUrl + "/api/users";
        try {
            String response = this.executeGetRequest(url);
            IamUsersOutput iamUsersOutput = (IamUsersOutput)this.objectMapper.readValue(response, IamUsersOutput.class);
            return iamUsersOutput.users();
        }
        catch (Exception e) {
            LOGGER.error("Error in retrieving iam users: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to retrieve iam users", e);
        }
    }

    public List<NucleusGroupOutput> getAllExternalGroups() {
        String url = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/groups";
        try {
            String response = this.executeGetRequest(url);
            NucleusGroupListOutput groupsOutput = (NucleusGroupListOutput)this.objectMapper.readValue(response, NucleusGroupListOutput.class);
            return groupsOutput.items() != null ? groupsOutput.items() : List.of();
        }
        catch (Exception e) {
            LOGGER.error("Error in retrieving groups: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to retrieve groups", e);
        }
    }

    public void createGroups(List<NucleusGroupInput> groups) {
        String url = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/groups";
        try {
            String jsonBody = this.objectMapper.writeValueAsString(groups);
            this.executePostRequest(url, jsonBody);
        }
        catch (Exception e) {
            LOGGER.error("Error in creating groups in nucleus: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to create groups in nucleus", e);
        }
    }

    public List<NucleusUserMappingOutput> getCurrentUserMappings() {
        String url = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/user-mappings";
        try {
            String response = this.executeGetRequest(url);
            NucleusUserMappingListOutput userMappingsOutput = (NucleusUserMappingListOutput)this.objectMapper.readValue(response, NucleusUserMappingListOutput.class);
            return userMappingsOutput.items() != null ? userMappingsOutput.items() : List.of();
        }
        catch (Exception e) {
            LOGGER.error("Error in retrieving user mappings: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to retrieve user mappings", e);
        }
    }

    public void createUserMappings(List<NucleusUserMappingInput> userMappings) {
        String url = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/user-mappings";
        try {
            String jsonBody = this.objectMapper.writeValueAsString(userMappings);
            this.executePostRequest(url, jsonBody);
        }
        catch (Exception e) {
            LOGGER.error("Error in creating user mappings: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to create user mappings", e);
        }
    }

    public List<NucleusGroupMembershipOutput> getCurrentGroupMemberships() {
        String url = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/group-members";
        try {
            String response = this.executeGetRequest(url);
            NucleusGroupMembershipListOutput groupMembershipOutput = (NucleusGroupMembershipListOutput)this.objectMapper.readValue(response, NucleusGroupMembershipListOutput.class);
            return groupMembershipOutput.items() != null ? groupMembershipOutput.items() : List.of();
        }
        catch (Exception e) {
            LOGGER.error("Error in retrieving group memberships: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to retrieve group memberships", e);
        }
    }

    public void assignGroupMembers(List<NucleusGroupMemberAssignmentInput> assignments) {
        String url = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/group-members";
        try {
            String jsonBody = this.objectMapper.writeValueAsString(assignments);
            this.executePostRequest(url, jsonBody);
        }
        catch (Exception e) {
            LOGGER.error("Error in creating member assignments to group: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Error in creating member assignments to group", e);
        }
    }

    public void deleteGroup(String externalGroupId) {
        try {
            String fullUrl = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/groups/" + URLEncoder.encode(externalGroupId, StandardCharsets.UTF_8);
            this.executeDeleteRequest(fullUrl);
        }
        catch (Exception e) {
            LOGGER.error("Error in deleting group: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to delete group", e);
        }
    }

    public void deleteUserMapping(String externalUserId) {
        try {
            String fullUrl = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/user-mappings/" + URLEncoder.encode(externalUserId, StandardCharsets.UTF_8);
            this.executeDeleteRequest(fullUrl);
        }
        catch (Exception e) {
            LOGGER.error("Error in deleting user mappings: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to delete user mappings", e);
        }
    }

    public void removeGroupMembers(String parentExternalGroupId, List<String> memberExternalUserIds) {
        try {
            for (int i = 0; i < memberExternalUserIds.size(); i += this.deleteBatchSize) {
                List<String> batch = memberExternalUserIds.subList(i, Math.min(i + this.deleteBatchSize, memberExternalUserIds.size()));
                this.removeGroupMembersBatch(parentExternalGroupId, batch);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error removing group members: {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to remove group members", e);
        }
    }

    private void removeGroupMembersBatch(String parentExternalGroupId, List<String> batch) {
        StringBuilder urlBuilder = new StringBuilder(this.nucleusBaseUrl).append("/system-integrations/systems/").append(this.systemId).append("/group-members").append("?parentExternalGroupId=").append(URLEncoder.encode(parentExternalGroupId, StandardCharsets.UTF_8));
        for (String userId : batch) {
            urlBuilder.append("&memberExternalUserIds=").append(URLEncoder.encode(userId, StandardCharsets.UTF_8));
        }
        this.executeDeleteRequest(urlBuilder.toString());
    }

    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{${http-client.max-attempts:3}}", backoff=@Backoff(delayExpression="#{${http-client.initial-delay-ms:2000}}", multiplierExpression="#{${http-client.multiplier:2}}", maxDelayExpression="#{${http-client.max-delay-ms:10000}}"))
    private String executeGetRequest(String fullUrl) {
        Map headers = this.authService.getHxpAuthHeaders();
        return (String)this.webClient.get().uri(fullUrl, new Object[0]).headers(httpHeaders -> {
            headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1));
            httpHeaders.set("Content-Type", "application/json");
        }).retrieve().bodyToMono(String.class).block(Duration.ofMinutes(this.timeoutInMin));
    }

    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{${http-client.max-attempts:3}}", backoff=@Backoff(delayExpression="#{${http-client.initial-delay-ms:2000}}", multiplierExpression="#{${http-client.multiplier:2}}", maxDelayExpression="#{${http-client.max-delay-ms:10000}}"))
    private String executePostRequest(String fullUrl, String jsonBody) {
        Map headers = this.authService.getHxpAuthHeaders();
        return (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(fullUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).headers(httpHeaders -> headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1)))).bodyValue((Object)jsonBody).retrieve().bodyToMono(String.class).block(Duration.ofMinutes(this.timeoutInMin));
    }

    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{${http-client.max-attempts:3}}", backoff=@Backoff(delayExpression="#{${http-client.initial-delay-ms:2000}}", multiplierExpression="#{${http-client.multiplier:2}}", maxDelayExpression="#{${http-client.max-delay-ms:10000}}"))
    private String executeDeleteRequest(String fullUrl) {
        Map headers = this.authService.getHxpAuthHeaders();
        return (String)this.webClient.delete().uri(fullUrl, new Object[0]).headers(httpHeaders -> headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1))).retrieve().bodyToMono(String.class).block(Duration.ofMinutes(this.timeoutInMin));
    }
}

