/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.services.util;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.alfresco.hxi_connector.nucleus_sync.client.AlfrescoClient;
import org.alfresco.hxi_connector.nucleus_sync.model.UserMapping;
import org.alfresco.hxi_connector.nucleus_sync.services.util.UserGroupFetchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserGroupMembershipService {
    private final AlfrescoClient alfrescoClient;
    private final Duration fetchTimeout;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupMembershipService.class);
    private static final int THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;

    public UserGroupMembershipService(AlfrescoClient alfrescoClient, @Value(value="${alfresco.user-group.fetch-timeout:PT5M}") Duration fetchTimeout) {
        this.alfrescoClient = alfrescoClient;
        this.fetchTimeout = fetchTimeout;
    }

    public Map<String, List<String>> buildUserGroupMemberships(List<UserMapping> localUserMappings) {
        LOGGER.atInfo().setMessage("Building user-group membership membership for {} users").addArgument((Object)localUserMappings.size()).log();
        ExecutorService executor = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
        try {
            Map<String, CompletableFuture> futures = localUserMappings.stream().collect(Collectors.toMap(UserMapping::alfrescoUserId, userMapping -> CompletableFuture.supplyAsync(() -> {
                try {
                    return this.alfrescoClient.getUserGroups(userMapping.alfrescoUserId());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to get groups for user: {} - {}", new Object[]{userMapping.alfrescoUserId(), e.getMessage(), e});
                    throw new UserGroupFetchException("Failed to fetch groups for user: " + userMapping.alfrescoUserId(), (Throwable)e);
                }
            }, executor)));
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.values().toArray(new CompletableFuture[0]));
            allFutures.orTimeout(this.fetchTimeout.toMillis(), TimeUnit.MILLISECONDS).join();
            ConcurrentHashMap<String, List> memberships = new ConcurrentHashMap<String, List>();
            for (Map.Entry<String, CompletableFuture> entry : futures.entrySet()) {
                memberships.put(entry.getKey(), (List)entry.getValue().join());
            }
            LOGGER.atInfo().setMessage("Successfully built user-group membership membership for {} users").addArgument((Object)memberships.size()).log();
            ConcurrentHashMap<String, List> concurrentHashMap = memberships;
            return concurrentHashMap;
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                LOGGER.atError().setMessage("Timeout fetching user groups after {} seconds").addArgument((Object)this.fetchTimeout.getSeconds()).setCause((Throwable)e).log();
                throw new UserGroupFetchException("Timeout fetching user groups after " + this.fetchTimeout.getSeconds() + " seconds", (Throwable)e);
            }
            throw e;
        }
        finally {
            executor.shutdown();
        }
    }
}

