/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.services.processors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.alfresco.hxi_connector.nucleus_sync.client.NucleusClient;
import org.alfresco.hxi_connector.nucleus_sync.dto.AlfrescoUser;
import org.alfresco.hxi_connector.nucleus_sync.dto.IamUser;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusUserMappingInput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusUserMappingOutput;
import org.alfresco.hxi_connector.nucleus_sync.model.UserMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserMappingSyncProcessor {
    private final NucleusClient nucleusClient;
    private final int createBatchSize;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMappingSyncProcessor.class);

    public UserMappingSyncProcessor(NucleusClient nucleusClient, @Value(value="${alfresco.sync-batch-size:1000}") int createBatchSize) {
        this.nucleusClient = nucleusClient;
        this.createBatchSize = createBatchSize;
    }

    public List<UserMapping> syncUserMappings(List<AlfrescoUser> alfrescoUsers, List<IamUser> nucleusIamUsers, List<NucleusUserMappingOutput> currentUserMappings) {
        Map alfrescoUserByEmail = alfrescoUsers.stream().filter(u -> u.email() != null && !u.email().isEmpty()).collect(Collectors.toMap(AlfrescoUser::email, Function.identity()));
        Map nucleusIamUserByEmail = nucleusIamUsers.stream().collect(Collectors.toMap(IamUser::email, Function.identity()));
        Map nucleusMappingByAlfrescoId = currentUserMappings.stream().collect(Collectors.toMap(NucleusUserMappingOutput::externalUserId, Function.identity()));
        ArrayList<String> nucleusMappingsToDelete = new ArrayList<String>();
        ArrayList<NucleusUserMappingInput> nucleusMappingsToCreate = new ArrayList<NucleusUserMappingInput>();
        ArrayList<UserMapping> updatedUserMappings = new ArrayList<UserMapping>();
        HashSet<String> validAlfrescoIds = new HashSet<String>();
        HashSet<String> commonEmails = new HashSet<String>(alfrescoUserByEmail.keySet());
        commonEmails.retainAll(nucleusIamUserByEmail.keySet());
        for (String email : commonEmails) {
            AlfrescoUser alfrescoUser = (AlfrescoUser)alfrescoUserByEmail.get(email);
            IamUser nucleusIamUser = (IamUser)nucleusIamUserByEmail.get(email);
            String alfrescoUserId = alfrescoUser.id();
            String nucleusUserId = nucleusIamUser.userId();
            validAlfrescoIds.add(alfrescoUserId);
            updatedUserMappings.add(new UserMapping(alfrescoUser.email(), alfrescoUserId, nucleusUserId));
            if (nucleusMappingByAlfrescoId.containsKey(alfrescoUserId)) continue;
            nucleusMappingsToCreate.add(new NucleusUserMappingInput(nucleusUserId, alfrescoUserId));
        }
        for (NucleusUserMappingOutput nucleusMapping : currentUserMappings) {
            String alfrescoUserId = nucleusMapping.externalUserId();
            if (validAlfrescoIds.contains(alfrescoUserId)) continue;
            nucleusMappingsToDelete.add(alfrescoUserId);
        }
        this.executeUserBatchOperations(nucleusMappingsToDelete, nucleusMappingsToCreate);
        LOGGER.atDebug().setMessage("Final user mappings count: {}").addArgument((Object)updatedUserMappings.size()).log();
        return updatedUserMappings;
    }

    private void executeUserBatchOperations(List<String> nucleusMappingsToDelete, List<NucleusUserMappingInput> nucleusMappingsToCreate) {
        for (String alfrescoUserId : nucleusMappingsToDelete) {
            this.nucleusClient.deleteUserMapping(alfrescoUserId);
        }
        if (!nucleusMappingsToDelete.isEmpty()) {
            LOGGER.atTrace().setMessage("Deleted user mappings for User ID: {}").addArgument((Object)nucleusMappingsToDelete.stream().collect(Collectors.joining(","))).log();
        }
        LOGGER.atDebug().setMessage("Deleted {} user mapping in Nucleus.").addArgument((Object)nucleusMappingsToDelete.size()).log();
        if (!nucleusMappingsToCreate.isEmpty()) {
            for (int i = 0; i < nucleusMappingsToCreate.size(); i += this.createBatchSize) {
                int endIndex = Math.min(i + this.createBatchSize, nucleusMappingsToCreate.size());
                List<NucleusUserMappingInput> batch = nucleusMappingsToCreate.subList(i, endIndex);
                this.nucleusClient.createUserMappings(batch);
            }
            LOGGER.atTrace().setMessage("Created user mappings for user ID: {}").addArgument((Object)nucleusMappingsToCreate.stream().map(NucleusUserMappingInput::userId).collect(Collectors.joining(","))).log();
        }
        LOGGER.atDebug().setMessage("Created {} user mappings in nucleus").addArgument((Object)nucleusMappingsToCreate.size()).log();
    }
}

