/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.services.processors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.hxi_connector.nucleus_sync.client.NucleusClient;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupInput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GroupMappingSyncProcessor {
    private final NucleusClient nucleusClient;
    private final int createBatchSize;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupMappingSyncProcessor.class);

    public GroupMappingSyncProcessor(NucleusClient nucleusClient, @Value(value="${alfresco.sync-batch-size:1000}") int createBatchSize) {
        this.nucleusClient = nucleusClient;
        this.createBatchSize = createBatchSize;
    }

    public void syncGroupMappings(List<NucleusGroupOutput> currentNucleusGroups, Map<String, List<String>> userGroupMemberships) {
        Set groupsWithUsers = userGroupMemberships.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        Set existingNucleusGroupIds = currentNucleusGroups.stream().map(NucleusGroupOutput::externalGroupId).collect(Collectors.toSet());
        List<String> groupsToCreate = groupsWithUsers.stream().filter(id -> !existingNucleusGroupIds.contains(id)).toList();
        List<String> groupsToDelete = existingNucleusGroupIds.stream().filter(id -> !groupsWithUsers.contains(id)).toList();
        this.executeGroupOperations(groupsToCreate, groupsToDelete);
        LOGGER.atDebug().setMessage("Updated group count: {}").addArgument((Object)groupsWithUsers.size()).log();
    }

    private void executeGroupOperations(List<String> toCreate, List<String> toDelete) {
        toDelete.forEach(arg_0 -> ((NucleusClient)this.nucleusClient).deleteGroup(arg_0));
        if (!toDelete.isEmpty()) {
            LOGGER.atTrace().setMessage("Deleted groups: {}").addArgument(() -> String.join((CharSequence)", ", toDelete)).log();
        }
        LOGGER.atDebug().setMessage("Deleted {} groups from Nucleus.").addArgument((Object)toDelete.size()).log();
        if (!toCreate.isEmpty()) {
            for (int i = 0; i < toCreate.size(); i += this.createBatchSize) {
                int endIndex = Math.min(i + this.createBatchSize, toCreate.size());
                List<String> batch = toCreate.subList(i, endIndex);
                List<NucleusGroupInput> inputs = batch.stream().map(NucleusGroupInput::new).toList();
                this.nucleusClient.createGroups(inputs);
            }
            LOGGER.atTrace().setMessage("Created groups: {}").addArgument(() -> String.join((CharSequence)", ", toCreate)).log();
        }
        LOGGER.atDebug().setMessage("Created {} groups in Nucleus.").addArgument((Object)toCreate.size()).log();
    }
}

