/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.services.processors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.hxi_connector.nucleus_sync.client.NucleusClient;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupMemberAssignmentInput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupMembershipOutput;
import org.alfresco.hxi_connector.nucleus_sync.model.UserMapping;
import org.alfresco.hxi_connector.nucleus_sync.services.processors.UserGroupMembershipSyncProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserGroupMembershipSyncProcessor {
    private final NucleusClient nucleusClient;
    private final int createBatchSize;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupMembershipSyncProcessor.class);

    public UserGroupMembershipSyncProcessor(NucleusClient nucleusClient, @Value(value="${alfresco.sync-batch-size:1000}") int createBatchSize) {
        this.nucleusClient = nucleusClient;
        this.createBatchSize = createBatchSize;
    }

    public void syncUserGroupMemberships(List<UserMapping> localUserMappings, List<NucleusGroupMembershipOutput> currentNucleusMemberships, Map<String, List<String>> userGroupMemberships) {
        Map<String, String> alfUsrEmailByUsrId = localUserMappings.stream().collect(Collectors.toMap(UserMapping::alfrescoUserId, UserMapping::email));
        HashSet<String> syncUsrIds = new HashSet<String>(alfUsrEmailByUsrId.keySet());
        Set desiredMemberships = this.calculateDesiredMemberships(syncUsrIds, userGroupMemberships);
        Set currentMemberships = currentNucleusMemberships.stream().map(m -> new UserGroupPair(m.memberExternalUserId(), m.externalGroupId())).collect(Collectors.toSet());
        HashSet mappingsToCreate = new HashSet(desiredMemberships);
        mappingsToCreate.removeAll(currentMemberships);
        HashSet mappingsToDelete = new HashSet(currentMemberships);
        mappingsToDelete.removeAll(desiredMemberships);
        this.executeNucleusMembershipOperations(mappingsToCreate, mappingsToDelete);
        LOGGER.atDebug().setMessage("Final user and group membership count: {}").addArgument((Object)desiredMemberships.size()).log();
    }

    private Set<UserGroupPair> calculateDesiredMemberships(Set<String> syncedUserIds, Map<String, List<String>> userGroupMemberships) {
        return syncedUserIds.stream().flatMap(userId -> {
            List userGroups = userGroupMemberships.getOrDefault(userId, List.of());
            return userGroups.stream().map(groupId -> new UserGroupPair(userId, groupId));
        }).collect(Collectors.toSet());
    }

    private void executeNucleusMembershipOperations(Set<UserGroupPair> nucleusMembershipsToCreate, Set<UserGroupPair> nucleusMembershipsToRemove) {
        if (!nucleusMembershipsToCreate.isEmpty()) {
            ArrayList<UserGroupPair> membershipsList = new ArrayList<UserGroupPair>(nucleusMembershipsToCreate);
            for (int i = 0; i < nucleusMembershipsToCreate.size(); i += this.createBatchSize) {
                int endIndex = Math.min(i + this.createBatchSize, nucleusMembershipsToCreate.size());
                List batch = membershipsList.subList(i, endIndex);
                List<NucleusGroupMemberAssignmentInput> input = batch.stream().map(pair -> new NucleusGroupMemberAssignmentInput(pair.alfrescoGroupId(), pair.alfresoUserId())).toList();
                this.nucleusClient.assignGroupMembers(input);
            }
            LOGGER.atTrace().setMessage("Created memberships: {}").addArgument(() -> nucleusMembershipsToCreate.stream().map(p -> String.format("user=%s -> group=%s", p.alfresoUserId(), p.alfrescoGroupId())).collect(Collectors.joining(", "))).log();
        }
        LOGGER.atDebug().setMessage("Assigned {} members to groups in Nucleus.").addArgument((Object)nucleusMembershipsToCreate.size()).log();
        if (!nucleusMembershipsToRemove.isEmpty()) {
            Map deleteByGroup = nucleusMembershipsToRemove.stream().collect(Collectors.groupingBy(UserGroupPair::alfrescoGroupId, Collectors.mapping(UserGroupPair::alfresoUserId, Collectors.toList())));
            deleteByGroup.forEach((groupId, userIds) -> this.nucleusClient.removeGroupMembers(groupId, userIds));
            LOGGER.atTrace().setMessage("Deleted memberships: {}").addArgument(() -> nucleusMembershipsToRemove.stream().map(p -> String.format("user=%s -> group=%s", p.alfresoUserId(), p.alfrescoGroupId())).collect(Collectors.joining(", "))).log();
        }
        LOGGER.atDebug().setMessage("Deleted {} memberships from Nucleus.").addArgument((Object)nucleusMembershipsToRemove.size()).log();
    }
}

