/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.controller;

import java.time.LocalDateTime;
import java.util.Map;
import lombok.Generated;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.SyncOrchestrationService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sync"})
public class SyncController {
    private final SyncOrchestrationService syncOrchestrationService;

    @PostMapping(value={"/trigger"})
    public SyncResponse triggerSync() {
        String result = this.syncOrchestrationService.performFullSync();
        return new SyncResponse(true, result, LocalDateTime.now());
    }

    @GetMapping(value={"/status"})
    public Map<String, Object> getSyncStatus() {
        return this.syncOrchestrationService.getSyncStatus();
    }

    @Generated
    public SyncController(SyncOrchestrationService syncOrchestrationService) {
        this.syncOrchestrationService = syncOrchestrationService;
    }

    record SyncResponse(boolean success, String message, LocalDateTime timestamp) {
    }
}

