/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.controller.advice;

import java.time.LocalDateTime;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.AlfrescoUnavailableException;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.NucleusUnavailableException;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.SyncException;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.SyncInProgressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class SyncExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncExceptionHandler.class);

    @ExceptionHandler(value={SyncInProgressException.class})
    public ResponseEntity<ErrorResponse> handleSyncInProgress(SyncInProgressException e) {
        LOGGER.atWarn().setMessage("Sync already in progress").log();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new ErrorResponse("SYNC_IN_PROGRESS", e.getMessage(), LocalDateTime.now()));
    }

    @ExceptionHandler(value={AlfrescoUnavailableException.class})
    public ResponseEntity<ErrorResponse> handleAlfrescoUnavailable(AlfrescoUnavailableException e) {
        LOGGER.atError().setMessage("Alfresco unavailable").setCause((Throwable)e).log();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)new ErrorResponse("ALFRESCO_UNAVAILABLE", e.getMessage(), LocalDateTime.now()));
    }

    @ExceptionHandler(value={NucleusUnavailableException.class})
    public ResponseEntity<ErrorResponse> handleNucleusUnavailable(NucleusUnavailableException e) {
        LOGGER.atError().setMessage("Nucleus unavailable").setCause((Throwable)e).log();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)new ErrorResponse("NUCLEUS_UNAVAILABLE", e.getMessage(), LocalDateTime.now()));
    }

    @ExceptionHandler(value={SyncException.class})
    public ResponseEntity<ErrorResponse> handleSyncException(SyncException e) {
        LOGGER.atError().setMessage("Sync failed").setCause((Throwable)e).log();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ErrorResponse("SYNC_FAILED", e.getMessage(), LocalDateTime.now()));
    }

    record ErrorResponse(String errorCode, String message, LocalDateTime timestamp) {
    }
}

