/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.services.orchestration;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.alfresco.hxi_connector.nucleus_sync.client.AlfrescoClient;
import org.alfresco.hxi_connector.nucleus_sync.client.NucleusClient;
import org.alfresco.hxi_connector.nucleus_sync.dto.AlfrescoUser;
import org.alfresco.hxi_connector.nucleus_sync.dto.IamUser;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupMembershipOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusUserMappingOutput;
import org.alfresco.hxi_connector.nucleus_sync.model.UserMapping;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.AlfrescoUnavailableException;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.NucleusUnavailableException;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.SyncException;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.SyncInProgressException;
import org.alfresco.hxi_connector.nucleus_sync.services.processors.GroupMappingSyncProcessor;
import org.alfresco.hxi_connector.nucleus_sync.services.processors.UserGroupMembershipSyncProcessor;
import org.alfresco.hxi_connector.nucleus_sync.services.processors.UserMappingSyncProcessor;
import org.alfresco.hxi_connector.nucleus_sync.services.util.UserGroupMembershipService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncOrchestrationService {
    private final AlfrescoClient alfrescoClient;
    private final NucleusClient nucleusClient;
    private final UserGroupMembershipService userGrpMembershipService;
    private final UserMappingSyncProcessor userMappingSyncProcessor;
    private final GroupMappingSyncProcessor groupMappingSyncProcessor;
    private final UserGroupMembershipSyncProcessor userGroupMembershipSyncProcessor;
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncOrchestrationService.class);
    private final AtomicBoolean isSyncInProgress = new AtomicBoolean(false);
    private volatile SyncStatus lastSyncStatus = SyncStatus.neverRun();

    public Map<String, Object> getSyncStatus() {
        return Map.of("syncInProgress", this.isSyncInProgress.get(), "lastSyncTime", this.lastSyncStatus.syncTime(), "lastSyncResult", this.lastSyncStatus.result(), "alfrescoStatus", this.lastSyncStatus.alfrescoHealth(), "nucleusStatus", this.lastSyncStatus.nucleusHealth());
    }

    public String performFullSync() {
        if (!this.isSyncInProgress.compareAndSet(false, true)) {
            throw new SyncInProgressException();
        }
        try {
            LOGGER.atInfo().setMessage("Sync starting ...").log();
            SyncResult syncResult = this.executeSync();
            this.lastSyncStatus = syncResult.toStatus();
            LOGGER.atInfo().setMessage("Sync complete: {}.").addArgument((Object)syncResult.summary()).log();
            String string = syncResult.summary();
            return string;
        }
        catch (SyncException e) {
            this.lastSyncStatus = SyncStatus.failed(e.getMessage(), this.lastSyncStatus);
            LOGGER.atError().setMessage("Sync failed: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw e;
        }
        finally {
            this.isSyncInProgress.set(false);
        }
    }

    private SyncResult executeSync() {
        LocalDateTime syncStartTime = LocalDateTime.now();
        SystemData data = this.getSystemData();
        List<UserMapping> userMappings = this.userMappingSyncProcessor.syncUserMappings(data.alfrescoUsers, data.nucleusIamUsers, data.currentUserMappings);
        LOGGER.atInfo().setMessage("User sync completed successfully.");
        Map<String, List<String>> userGroupMemberships = this.userGrpMembershipService.buildUserGroupMemberships(userMappings);
        LOGGER.atDebug().setMessage("Fresh user-group membership cache built successfully.");
        this.groupMappingSyncProcessor.syncGroupMappings(data.currentNucleusGroups, userGroupMemberships);
        LOGGER.atInfo().setMessage("Group sync completed successfully.");
        this.userGroupMembershipSyncProcessor.syncUserGroupMemberships(userMappings, data.currentMemberships, userGroupMemberships);
        LOGGER.atInfo().setMessage("User-Group Membership sync completed successfully.");
        return SyncResult.success(data.alfrescoHealthStatus(), data.nucleusHealthStatus(), syncStartTime);
    }

    private SystemData getSystemData() {
        String nucleusStatus;
        List<NucleusGroupMembershipOutput> currentMemberships;
        List<NucleusGroupOutput> currentNucleusGroups;
        List<NucleusUserMappingOutput> currentUserMappings;
        List<IamUser> nucleusIamUsers;
        String alfrescoStatus;
        List<AlfrescoUser> alfrescoUsers;
        LocalDateTime now = LocalDateTime.now();
        try {
            alfrescoUsers = this.alfrescoClient.getAllUsers();
            alfrescoStatus = "HEALTHY";
            LOGGER.atDebug().setMessage("Found {} alfresco users.").addArgument((Object)alfrescoUsers.size()).log();
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Alfresco unavailable: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new AlfrescoUnavailableException(e.getMessage(), e);
        }
        try {
            nucleusIamUsers = this.nucleusClient.getAllIamUsers();
            currentUserMappings = this.nucleusClient.getCurrentUserMappings();
            currentNucleusGroups = this.nucleusClient.getAllExternalGroups();
            currentMemberships = this.nucleusClient.getCurrentGroupMemberships();
            nucleusStatus = "HEALTHY";
            LOGGER.atDebug().setMessage("Found {} IAM users, {} user mappings, {} alfresco groups, {} memberships.").addArgument((Object)nucleusIamUsers.size()).addArgument((Object)currentUserMappings.size()).addArgument((Object)currentNucleusGroups.size()).addArgument((Object)currentMemberships.size()).log();
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Nucleus unavailable: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new NucleusUnavailableException(e.getMessage(), e);
        }
        return new SystemData(alfrescoUsers, nucleusIamUsers, currentUserMappings, currentNucleusGroups, currentMemberships, alfrescoStatus, nucleusStatus, now);
    }

    @Generated
    public SyncOrchestrationService(AlfrescoClient alfrescoClient, NucleusClient nucleusClient, UserGroupMembershipService userGrpMembershipService, UserMappingSyncProcessor userMappingSyncProcessor, GroupMappingSyncProcessor groupMappingSyncProcessor, UserGroupMembershipSyncProcessor userGroupMembershipSyncProcessor) {
        this.alfrescoClient = alfrescoClient;
        this.nucleusClient = nucleusClient;
        this.userGrpMembershipService = userGrpMembershipService;
        this.userMappingSyncProcessor = userMappingSyncProcessor;
        this.groupMappingSyncProcessor = groupMappingSyncProcessor;
        this.userGroupMembershipSyncProcessor = userGroupMembershipSyncProcessor;
    }

    record SyncStatus(LocalDateTime syncTime, String result, String alfrescoHealth, String nucleusHealth) {
        static SyncStatus neverRun() {
            return new SyncStatus(LocalDateTime.MIN, "Never Synced", "UNKNOWN", "UNKNOWN");
        }

        static SyncStatus failed(String error, SyncStatus previous) {
            return new SyncStatus(LocalDateTime.now(), "Failed: " + error, previous.alfrescoHealth, previous.nucleusHealth);
        }
    }

    record SyncResult(boolean success, String message, String alfrescoHealth, String nucleusHealth, LocalDateTime checkTime) {
        static SyncResult success(String alfrescoHealth, String nucleusHealth, LocalDateTime checkTime) {
            return new SyncResult(true, "Sync completed successfully", alfrescoHealth, nucleusHealth, checkTime);
        }

        String summary() {
            return this.message;
        }

        SyncStatus toStatus() {
            return new SyncStatus(LocalDateTime.now(), this.message, this.alfrescoHealth, this.nucleusHealth);
        }
    }

    record SystemData(List<AlfrescoUser> alfrescoUsers, List<IamUser> nucleusIamUsers, List<NucleusUserMappingOutput> currentUserMappings, List<NucleusGroupOutput> currentNucleusGroups, List<NucleusGroupMembershipOutput> currentMemberships, String alfrescoHealthStatus, String nucleusHealthStatus, LocalDateTime healthCheckTime) {
    }
}

