/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.prediction_applier.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpClient;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.AcsHealthProbe;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.ApplicationInfoProvider;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.DiscoveryApiRepositoryInformation;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.ProcessingStarter;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.RepositoryInformation;
import org.alfresco.hxi_connector.common.config.properties.Application;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.prediction_applier.config.RepositoryApiProperties;
import org.apache.camel.CamelContext;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class AppConfig {
    @Bean
    @ConfigurationProperties(prefix="application")
    public Application application() {
        return new Application();
    }

    @Bean
    public HttpClient httpClient() {
        return HttpClient.newHttpClient();
    }

    @Bean
    @Profile(value={"!test"})
    public AcsHealthProbe acsHealthProbe(HttpClient httpClient, RepositoryApiProperties repositoryApiProperties) {
        return new AcsHealthProbe(httpClient, repositoryApiProperties.healthProbe().endpoint(), repositoryApiProperties.healthProbe().timeoutSeconds(), repositoryApiProperties.healthProbe().intervalSeconds(), true);
    }

    @Bean
    public RepositoryInformation repositoryInformation(RepositoryApiProperties repositoryApiProperties, AuthService authService, ObjectMapper objectMapper, HttpClient httpClient, AcsHealthProbe acsHealthProbe) {
        EnsureUtils.ensureNotBlank((String)repositoryApiProperties.discoveryEndpoint(), (String)"ACS Discovery API endpoint property must be set", (Object[])new Object[0]);
        return new DiscoveryApiRepositoryInformation(repositoryApiProperties.discoveryEndpoint(), authService, objectMapper, httpClient);
    }

    @Bean
    public ApplicationInfoProvider applicationInfoProvider(RepositoryInformation repositoryInformation, Application applicationProperties) {
        return new ApplicationInfoProvider(repositoryInformation, applicationProperties);
    }

    @Bean
    public ProcessingStarter processingStarter(CamelContext camelContext) {
        return new ProcessingStarter(camelContext);
    }
}

