/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.prediction_applier.config;

import jakarta.validation.constraints.NotBlank;
import org.alfresco.hxi_connector.prediction_applier.exception.PredictionApplierRuntimeException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="hyland-experience.insight.predictions")
public record InsightPredictionsProperties(String collectorTimerEndpoint, Long pollPeriodMillis, @NotBlank String baseUrl, String bufferEndpoint) {
    public InsightPredictionsProperties(String collectorTimerEndpoint, Long pollPeriodMillis, @NotBlank String baseUrl, String bufferEndpoint) {
        if (bufferEndpoint == null) {
            bufferEndpoint = "activemq:queue:predictions-buffer";
        }
        if (pollPeriodMillis == null && collectorTimerEndpoint == null) {
            throw new PredictionApplierRuntimeException("Poll period is required when predictions source endpoint is not provided");
        }
        if (pollPeriodMillis != null && collectorTimerEndpoint == null) {
            collectorTimerEndpoint = "quartz:predictions-collector-timer?autoStartScheduler=true&trigger.repeatInterval=" + pollPeriodMillis;
        }
    }
}

