/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.log.log4j2;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.ObjectName;
import jmxlogger.tools.JmxEventLogger;
import jmxlogger.tools.ToolBox;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Log4j2JmxLogAppender", category="Core", elementType="appender")
public class Log4j2JmxLogAppender
extends AbstractAppender {
    private static final Map<String, String> LOG_CTX_BY_OBJECT_NAME = new HashMap<String, String>();
    private final String serverSelection;
    private JmxEventLogger logger;

    public Log4j2JmxLogAppender(String name, Filter filter, Layout<? extends Serializable> layout, String objectName, String serverSelection, boolean ignoreExceptions, Configuration configuration) {
        super(name, filter, layout, ignoreExceptions, null);
        this.serverSelection = serverSelection;
        Objects.requireNonNull(serverSelection, "serverSelection should not be null");
        Objects.requireNonNull(configuration, "configuration should not be null");
        String logContextName = configuration.getLoggerContext().getName();
        ObjectName actualObjectName = this.buildObjectName(objectName, logContextName);
        this.setLogger(JmxEventLogger.createInstance());
        this.getLogger().setObjectName(actualObjectName);
        this.configureLogger();
        this.startLogger();
        LOG_CTX_BY_OBJECT_NAME.put(actualObjectName.getCanonicalName(), logContextName);
    }

    @PluginFactory
    public static Log4j2JmxLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ObjectName") String objectName, @PluginAttribute(value="serverSelection", defaultString="platform") String serverSelection, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions, @PluginConfiguration Configuration configuration) {
        return new Log4j2JmxLogAppender(name, filter, layout, objectName, serverSelection, ignoreExceptions, configuration);
    }

    public void append(LogEvent event) {
        try {
            String formattedMessage = new String(this.getLayout().toByteArray(event));
            this.getLogger().log(this.prepareLogEvent(formattedMessage, event));
        }
        catch (Exception e) {
            if (!this.ignoreExceptions()) {
                throw e;
            }
            this.error("Unable to send log to JMX.", e);
        }
    }

    private Map<String, Object> prepareLogEvent(String formattedMessage, LogEvent logEvent) {
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("source", ((Object)((Object)this)).getClass().getName());
        event.put("levelName", logEvent.getLevel().toString());
        event.put("loggerName", logEvent.getLoggerName());
        event.put("message", formattedMessage);
        event.put("sequenceNumber", logEvent.getTimeMillis());
        event.put("sourceClassName", logEvent.getLoggerFqcn());
        event.put("sourceMethodName", "Unavailable");
        event.put("threadId", logEvent.getThreadName());
        event.put("throwable", logEvent.getThrown());
        event.put("timeStamp", logEvent.getTimeMillis());
        return event;
    }

    private void configureLogger() {
        if (this.getLogger().getMBeanServer() == null) {
            if (this.getServerSelection().equalsIgnoreCase("platform")) {
                this.getLogger().setMBeanServer(ManagementFactory.getPlatformMBeanServer());
            } else {
                this.getLogger().setMBeanServer(ToolBox.findMBeanServer((String)this.getServerSelection()));
            }
        }
    }

    private void startLogger() {
        if (!this.getLogger().isStarted()) {
            this.getLogger().start();
        }
    }

    private ObjectName buildObjectName(String objectName, String logContextName) {
        return objectName == null || LOG_CTX_BY_OBJECT_NAME.get(objectName) != null && !LOG_CTX_BY_OBJECT_NAME.get(objectName).equals(logContextName) ? ToolBox.buildDefaultObjectName((String)Integer.toString(((Object)((Object)this)).hashCode())) : ToolBox.buildObjectName((String)objectName);
    }

    public JmxEventLogger getLogger() {
        return this.logger;
    }

    public void setLogger(JmxEventLogger logger) {
        this.logger = logger;
    }

    public String getServerSelection() {
        return this.serverSelection;
    }
}

