/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.exception;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.extensions.surf.util.I18NUtil;

public class PlatformRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 3834594313622859827L;
    private static AtomicInteger errorCounter = new AtomicInteger();

    public static PlatformRuntimeException create(String msgId, Object ... objects) {
        return new PlatformRuntimeException(msgId, objects);
    }

    public static PlatformRuntimeException create(Throwable cause, String msgId, Object ... objects) {
        return new PlatformRuntimeException(msgId, objects, cause);
    }

    public static RuntimeException makeRuntimeException(Throwable e, String msgId, Object ... objects) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return PlatformRuntimeException.create(e, msgId, objects);
    }

    public PlatformRuntimeException(String msgId) {
        super(PlatformRuntimeException.resolveMessage(msgId, null));
    }

    public PlatformRuntimeException(String msgId, Object[] msgParams) {
        super(PlatformRuntimeException.resolveMessage(msgId, msgParams));
    }

    public PlatformRuntimeException(String msgId, Throwable cause) {
        super(PlatformRuntimeException.resolveMessage(msgId, null), cause);
    }

    public PlatformRuntimeException(String msgId, Object[] msgParams, Throwable cause) {
        super(PlatformRuntimeException.resolveMessage(msgId, msgParams), cause);
    }

    private static String resolveMessage(String messageId, Object[] params) {
        String message = I18NUtil.getMessage(messageId, params);
        if (message == null) {
            message = messageId;
        }
        return PlatformRuntimeException.buildErrorLogNumber(message);
    }

    private static String buildErrorLogNumber(String message) {
        if (message == null) {
            message = "";
        }
        Date today = new Date();
        StringBuilder buf = new StringBuilder(message.length() + 10);
        PlatformRuntimeException.padInt(buf, today.getMonth(), 2);
        PlatformRuntimeException.padInt(buf, today.getDate(), 2);
        PlatformRuntimeException.padInt(buf, errorCounter.getAndIncrement(), 4);
        buf.append(' ');
        buf.append(message);
        return buf.toString();
    }

    private static void padInt(StringBuilder buffer, int value, int length) {
        String strValue = Integer.toString(value);
        for (int i = length - strValue.length(); i > 0; --i) {
            buffer.append('0');
        }
        buffer.append(strValue);
    }
}

