/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.ExpertFeature;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsFilteringManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.util.BitField;
import java.net.URI;
import java.net.URISyntaxException;

public final class TVFS {
    private TVFS() {
    }

    public static void umount() throws FsSyncException {
        TVFS.sync(FsSyncOptions.UMOUNT);
    }

    public static void umount(TFile tree) throws FsSyncException {
        TVFS.sync(tree, FsSyncOptions.UMOUNT);
    }

    public static void umount(FsMountPoint tree) throws FsSyncException {
        TVFS.sync(tree, FsSyncOptions.UMOUNT);
    }

    static FsMountPoint mountPoint(TFile tree) {
        if (tree.isArchive()) {
            return ((FsModel)tree.getController().getModel()).getMountPoint();
        }
        try {
            return new FsMountPoint(new URI(tree.getFile().toURI() + "/"), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsSyncOption ... options) throws FsSyncException {
        TVFS.sync(FsSyncOptions.of(options));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(BitField<FsSyncOption> options) throws FsSyncException {
        TConfig.get().getFsManager().sync(options);
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(TFile tree, FsSyncOption ... options) throws FsSyncException {
        TVFS.sync(tree, FsSyncOptions.of(options));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(TFile tree, BitField<FsSyncOption> options) throws FsSyncException {
        TVFS.sync(TVFS.mountPoint(tree), options);
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsMountPoint tree, FsSyncOption ... options) throws FsSyncException {
        TVFS.sync(tree, FsSyncOptions.of(options));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsMountPoint tree, BitField<FsSyncOption> options) throws FsSyncException {
        new FsFilteringManager(TConfig.get().getFsManager(), tree).sync(options);
    }
}

