/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.file.FileEntry;
import de.schlichtherle.truezip.io.IOExceptionOutputStream;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class FileOutputSocket
extends OutputSocket<FileEntry> {
    private final FileEntry entry;
    private final BitField<FsOutputOption> options;
    @CheckForNull
    private final Entry template;

    FileOutputSocket(FileEntry entry, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        assert (null != entry);
        assert (null != options);
        if (options.get(FsOutputOption.EXCLUSIVE) && options.get(FsOutputOption.APPEND)) {
            throw new IllegalArgumentException();
        }
        this.entry = entry;
        this.options = options;
        this.template = template;
    }

    @Override
    public FileEntry getLocalTarget() {
        return this.entry;
    }

    private FileEntry begin() throws IOException {
        File parentFile;
        FileEntry temp;
        File entryFile = this.entry.getFile();
        Boolean exists = null;
        if (this.options.get(FsOutputOption.EXCLUSIVE) && (exists = Boolean.valueOf(entryFile.exists())).booleanValue()) {
            throw new IOException(entryFile + " (file exists already)");
        }
        if (this.options.get(FsOutputOption.CACHE)) {
            if (Boolean.TRUE.equals(exists) || null == exists && (exists = Boolean.valueOf(entryFile.exists())).booleanValue()) {
                if (!entryFile.canWrite()) {
                    throw new FileNotFoundException(entryFile + " (cannot write)");
                }
            } else if (!entryFile.createNewFile()) {
                throw new FileNotFoundException(entryFile + " (already exists)");
            }
            temp = this.entry.createTempFile();
        } else {
            temp = this.entry;
        }
        if (this.options.get(FsOutputOption.CREATE_PARENTS) && !Boolean.TRUE.equals(exists) && null != (parentFile = entryFile.getParentFile()) && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException(parentFile + " (cannot create directories)");
        }
        return temp;
    }

    private void append(FileEntry temp) throws IOException {
        if (temp != this.entry && this.options.get(FsOutputOption.APPEND) && this.entry.getFile().exists()) {
            IOSocket.copy(this.entry.getInputSocket(), temp.getOutputSocket());
        }
    }

    private void close(FileEntry temp, boolean commit) throws IOException {
        File entryFile = this.entry.getFile();
        if (temp != this.entry) {
            File tempFile = temp.getFile();
            this.copyAttributes(tempFile);
            if (commit) {
                if (!FileOutputSocket.move(tempFile, entryFile)) {
                    IOSocket.copy(temp.getInputSocket(), this.entry.getOutputSocket());
                    this.copyAttributes(entryFile);
                }
                this.release(temp, null);
            }
        } else {
            this.copyAttributes(entryFile);
        }
    }

    private void copyAttributes(File file) throws IOException {
        Entry template = this.template;
        if (null == template) {
            return;
        }
        long time = template.getTime(Entry.Access.WRITE);
        if (-1L != time && !file.setLastModified(time)) {
            throw new IOException(file + " (cannot preserve last modification time)");
        }
    }

    private static boolean move(File src, File dst) {
        return src.exists() && (!dst.exists() || dst.delete()) && src.renameTo(dst);
    }

    private void release(FileEntry temp, @CheckForNull IOException ex) throws IOException {
        try {
            temp.release();
        }
        catch (IOException ex2) {
            ex2.initCause(ex);
            throw ex2;
        }
    }

    @Override
    public OutputStream newOutputStream() throws IOException {
        final FileEntry temp = this.begin();
        try {
            this.append(temp);
            class OutputStream
            extends IOExceptionOutputStream {
                boolean closed;

                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                OutputStream() throws FileNotFoundException {
                    super(new FileOutputStream(fileEntry.getFile(), FileOutputSocket.this.options.get(FsOutputOption.APPEND)));
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    this.closed = true;
                    FileOutputSocket.this.close(temp, null == this.exception);
                }
            }
            return new OutputStream();
        }
        catch (IOException ex) {
            this.release(temp, ex);
            throw ex;
        }
    }
}

