/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
final class TBIO {
    private TBIO() {
    }

    static void mv(File src, File dst, TArchiveDetector detector) throws IOException {
        TBIO.checkContains(src, dst);
        if (dst.exists()) {
            throw new IOException(dst + " (destination exists already)");
        }
        TBIO.mv0(src, dst, detector);
    }

    private static void mv0(File src, File dst, TArchiveDetector detector) throws IOException {
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcIsArchived = src instanceof TFile && null != ((TFile)src).getInnerArchive();
            boolean dstIsArchived = dst instanceof TFile && null != ((TFile)dst).getInnerArchive();
            boolean bl = srcIsGhost = srcIsArchived && 0L >= srcLastModified;
            if (!(srcIsGhost && dstIsArchived && TConfig.get().isLenient() || dst.mkdir() || dst.isDirectory())) {
                throw new IOException(dst + " (not a directory)");
            }
            Object[] members = src.list();
            if (null == members) {
                throw new IOException(dst + " (cannot list directory)");
            }
            if (!srcIsArchived && dstIsArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                TBIO.mv0(new TFile(src, (String)member, detector), new TFile(dst, (String)member, detector), detector);
            }
            if (!srcIsGhost && !dst.setLastModified(srcLastModified)) {
                throw new IOException(dst + " (cannot set last modification time)");
            }
        } else if (src.isFile()) {
            if (dst.exists() && !dst.isFile()) {
                throw new IOException(dst + " (not a file)");
            }
            TBIO.cp0(true, src, dst);
        } else {
            if (src.exists()) {
                throw new IOException(src + " (cannot move special file)");
            }
            throw new IOException(src + " (missing file)");
        }
        if (!src.delete()) {
            throw new IOException(src + " (cannot delete)");
        }
    }

    static void cp_r(boolean preserve, File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.checkContains(src, dst);
        TBIO.cp_r0(preserve, src, dst, srcDetector, dstDetector);
    }

    private static void cp_r0(boolean preserve, File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcArchived = src instanceof TFile && null != ((TFile)src).getInnerArchive();
            boolean dstArchived = dst instanceof TFile && null != ((TFile)dst).getInnerArchive();
            boolean bl = srcIsGhost = srcArchived && 0L >= srcLastModified;
            if (!(srcIsGhost && dstArchived && TConfig.get().isLenient() || dst.mkdir() || dst.isDirectory())) {
                throw new IOException(dst + " (not a directory)");
            }
            Object[] members = src.list();
            if (null == members) {
                throw new IOException(dst + " (cannot list directory)");
            }
            if (!srcArchived && dstArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                TBIO.cp_r0(preserve, new TFile(src, (String)member, srcDetector), new TFile(dst, (String)member, dstDetector), srcDetector, dstDetector);
            }
            if (preserve && !srcIsGhost && !dst.setLastModified(srcLastModified)) {
                throw new IOException(dst + " (cannot set last modification time)");
            }
        } else if (src.isFile()) {
            if (dst.exists() && !dst.isFile()) {
                throw new IOException(dst + " (not a file)");
            }
            TBIO.cp0(preserve, src, dst);
        } else {
            if (src.exists()) {
                throw new IOException(src + " (cannot copy special file)");
            }
            throw new IOException(src + " (missing file)");
        }
    }

    static void cp(boolean preserve, File src, File dst) throws IOException {
        TBIO.checkContains(src, dst);
        TBIO.cp0(preserve, src, dst);
    }

    private static void cp0(boolean preserve, File src, File dst) throws IOException {
        TConfig config = TConfig.get();
        InputSocket<?> input = TBIO.getInputSocket(src, config.getInputPreferences());
        OutputSocket<?> output = TBIO.getOutputSocket(dst, config.getOutputPreferences(), preserve ? (Entry)input.getLocalTarget() : null);
        IOSocket.copy(input, output);
    }

    static void rm_r(File node, TArchiveDetector detector) throws IOException {
        if (node.isDirectory()) {
            String[] members = node.list();
            if (null == members) {
                throw new IOException(node + " (cannot list directory)");
            }
            for (String member : members) {
                TBIO.rm_r(new TFile(node, member, detector), detector);
            }
        }
        TFile.rm(node);
    }

    private static void checkContains(File a, File b) throws IOException {
        if (Paths.contains(a.getAbsolutePath(), b.getAbsolutePath(), File.separatorChar)) {
            throw new IOException(b + " (contained in " + a + ")");
        }
    }

    static InputSocket<?> getInputSocket(File src, BitField<FsInputOption> options) {
        TFile tsrc;
        TFile archive;
        if (src instanceof TFile && null != (archive = (tsrc = (TFile)src).getInnerArchive())) {
            return archive.getController().getInputSocket(tsrc.getInnerFsEntryName(), options);
        }
        FsPath path = new FsPath(src);
        return TConfig.get().getFsManager().getController(path.getMountPoint(), TBIO.getDetector(src)).getInputSocket(path.getEntryName(), options);
    }

    static OutputSocket<?> getOutputSocket(File dst, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        TFile tdst;
        TFile archive;
        if (dst instanceof TFile && null != (archive = (tdst = (TFile)dst).getInnerArchive())) {
            return archive.getController().getOutputSocket(tdst.getInnerFsEntryName(), options, template);
        }
        FsPath path = new FsPath(dst);
        return TConfig.get().getFsManager().getController(path.getMountPoint(), TBIO.getDetector(dst)).getOutputSocket(path.getEntryName(), options.clear(FsOutputOption.CREATE_PARENTS), template);
    }

    private static TArchiveDetector getDetector(File file) {
        return file instanceof TFile ? ((TFile)file).getArchiveDetector() : TConfig.get().getArchiveDetector();
    }
}

