/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;

@CleanupObligation
public abstract class DecoratingInputStream
extends InputStream {
    @Nullable
    protected InputStream delegate;

    @CreatesObligation
    protected DecoratingInputStream(@Nullable @WillCloseWhenClosed InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public String toString() {
        return String.format("%s[delegate=%s]", this.getClass().getName(), this.delegate);
    }
}

