/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Comparator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SequentialIOException
extends IOException
implements Cloneable {
    private static final long serialVersionUID = 2203967634187324928L;
    private static int maxPrintExceptions = 3;
    static final Comparator<SequentialIOException> INDEX_COMP = new Comparator<SequentialIOException>(){

        @Override
        public int compare(SequentialIOException o1, SequentialIOException o2) {
            return o1.index - o2.index;
        }
    };
    static final Comparator<SequentialIOException> PRIORITY_COMP = new Comparator<SequentialIOException>(){

        @Override
        public int compare(SequentialIOException o1, SequentialIOException o2) {
            int p2;
            int p1 = o1.priority;
            return p1 < (p2 = o2.priority) ? -1 : (p1 > p2 ? 1 : INDEX_COMP.compare(o1, o2));
        }
    };
    @CheckForNull
    private SequentialIOException predecessor = this;
    private final int priority;
    private int index;
    int maxIndex;

    public SequentialIOException() {
        this((String)null, 0);
    }

    public SequentialIOException(@CheckForNull String message) {
        this(message, 0);
    }

    public SequentialIOException(@CheckForNull Throwable cause) {
        this(null, cause, 0);
    }

    public SequentialIOException(@CheckForNull String message, @CheckForNull Throwable cause) {
        this(message, cause, 0);
    }

    public SequentialIOException(int priority) {
        this((String)null, priority);
    }

    public SequentialIOException(@CheckForNull String message, int priority) {
        super(message);
        this.priority = priority;
    }

    public SequentialIOException(@CheckForNull Throwable cause, int priority) {
        this(null, cause, priority);
    }

    public SequentialIOException(@CheckForNull String message, @CheckForNull Throwable cause, int priority) {
        super(message, cause);
        this.priority = priority;
    }

    public SequentialIOException clone() {
        try {
            return (SequentialIOException)super.clone();
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    @Override
    public SequentialIOException initCause(Throwable cause) {
        super.initCause(cause);
        return this;
    }

    public synchronized SequentialIOException initPredecessor(@CheckForNull SequentialIOException predecessor) {
        this.setPredecessor(predecessor);
        predecessor = this.getPredecessor();
        if (predecessor != null) {
            this.index = this.maxIndex = predecessor.maxIndex + 1;
        }
        return this;
    }

    private void setPredecessor(@CheckForNull SequentialIOException predecessor) {
        if (this.isInitPredecessor()) {
            if (this.predecessor == predecessor) {
                return;
            }
            throw new IllegalStateException("Cannot overwrite predecessor!");
        }
        if (predecessor == this) {
            throw new IllegalArgumentException("Cannot be predecessor of myself!");
        }
        if (null != predecessor && !predecessor.isInitPredecessor()) {
            throw new IllegalArgumentException("The predecessor's predecessor must be initialized in order to inhibit loops!");
        }
        this.predecessor = predecessor;
    }

    @Nullable
    public final synchronized SequentialIOException getPredecessor() {
        return this.isInitPredecessor() ? this.predecessor : null;
    }

    final boolean isInitPredecessor() {
        return this.predecessor != this;
    }

    public final int getPriority() {
        return this.priority;
    }

    public SequentialIOException sortPriority() {
        return this.sort(PRIORITY_COMP);
    }

    public SequentialIOException sortAppearance() {
        return this.sort(INDEX_COMP);
    }

    private SequentialIOException sort(Comparator<SequentialIOException> cmp) {
        SequentialIOException predecessor = this.getPredecessor();
        if (null == predecessor) {
            return this;
        }
        SequentialIOException tail = predecessor.sort(cmp);
        if (tail == predecessor && cmp.compare(this, tail) >= 0) {
            return this;
        }
        return tail.insert(this.clone(), cmp);
    }

    private SequentialIOException insert(SequentialIOException element, Comparator<SequentialIOException> cmp) {
        if (cmp.compare(element, this) >= 0) {
            element.predecessor = this;
            element.maxIndex = Math.max(element.index, this.maxIndex);
            return element;
        }
        SequentialIOException predecessor = this.predecessor;
        assert (predecessor != this);
        SequentialIOException clone = this.clone();
        if (predecessor != null) {
            clone.predecessor = predecessor.insert(element, cmp);
            clone.maxIndex = Math.max(clone.index, clone.predecessor.maxIndex);
        } else {
            element.predecessor = null;
            clone.predecessor = element;
            clone.maxIndex = element.maxIndex;
        }
        return clone;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(s, SequentialIOException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintStream s, int maxExceptions) {
        --maxExceptions;
        SequentialIOException predecessor = this.getPredecessor();
        if (null != predecessor) {
            if (maxExceptions > 0) {
                predecessor.printStackTrace(s, maxExceptions);
                s.println("\nFollowed, but not caused by:");
            } else {
                s.println("\nOmitting " + predecessor.getNumExceptions() + " more exception(s) at the start of this list!");
            }
        }
        super.printStackTrace(s);
    }

    private int getNumExceptions() {
        SequentialIOException predecessor = this.getPredecessor();
        return null != predecessor ? predecessor.getNumExceptions() + 1 : 1;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(s, SequentialIOException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintWriter s, int maxExceptions) {
        --maxExceptions;
        SequentialIOException predecessor = this.getPredecessor();
        if (null != predecessor) {
            if (0 < maxExceptions) {
                predecessor.printStackTrace(s, maxExceptions);
                s.println("\nFollowed, but not caused by:");
            } else {
                s.println("\nOmitting " + predecessor.getNumExceptions() + " more exception(s) at the start of this list!");
            }
        }
        super.printStackTrace(s);
    }

    public static int getMaxPrintExceptions() {
        return maxPrintExceptions;
    }

    public static void setMaxPrintExceptions(int maxPrintExcepions) {
        maxPrintExceptions = maxPrintExcepions;
    }
}

