/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsPath;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FsEntryNotFoundException
extends FileNotFoundException {
    private static final long serialVersionUID = 2972350932856838564L;
    private final FsPath path;

    public FsEntryNotFoundException(FsModel model, FsEntryName name, @CheckForNull String msg) {
        super(msg);
        this.path = model.getMountPoint().resolve(name);
    }

    public FsEntryNotFoundException(FsModel model, FsEntryName name, @CheckForNull IOException cause) {
        super(null != cause ? cause.toString() : null);
        super.initCause(cause);
        this.path = model.getMountPoint().resolve(name);
    }

    @Override
    @Nullable
    public String getMessage() {
        String msg = super.getMessage();
        return null != msg ? this.path.toString() + " (" + msg + ")" : this.path.toString();
    }
}

