/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.alfresco.rest.api.search.ResultMapperTests;
import org.alfresco.rest.api.search.SerializerTestHelper;
import org.alfresco.rest.api.search.context.SearchRequestContext;
import org.alfresco.rest.api.search.impl.SearchMapper;
import org.alfresco.rest.api.search.impl.StoreMapper;
import org.alfresco.rest.api.search.model.Default;
import org.alfresco.rest.api.search.model.FacetField;
import org.alfresco.rest.api.search.model.FacetFields;
import org.alfresco.rest.api.search.model.FacetQuery;
import org.alfresco.rest.api.search.model.FilterQuery;
import org.alfresco.rest.api.search.model.Limits;
import org.alfresco.rest.api.search.model.Localization;
import org.alfresco.rest.api.search.model.Pivot;
import org.alfresco.rest.api.search.model.Query;
import org.alfresco.rest.api.search.model.Scope;
import org.alfresco.rest.api.search.model.SearchQuery;
import org.alfresco.rest.api.search.model.SortDef;
import org.alfresco.rest.api.search.model.Spelling;
import org.alfresco.rest.api.search.model.Template;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.FacetFormat;
import org.alfresco.service.cmr.search.FieldHighlightParameters;
import org.alfresco.service.cmr.search.GeneralHighlightParameters;
import org.alfresco.service.cmr.search.Interval;
import org.alfresco.service.cmr.search.IntervalParameters;
import org.alfresco.service.cmr.search.IntervalSet;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.RangeParameters;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.StatsRequestParameters;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SearchMapperTests {
    static SearchMapper searchMapper = new SearchMapper();
    static SerializerTestHelper helper = new SerializerTestHelper();

    @BeforeClass
    public static void setupTests() throws Exception {
        searchMapper.setStoreMapper(new StoreMapper());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMandatory() throws Exception {
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)SearchQuery.EMPTY);
        SearchParameters searchParameters = searchMapper.toSearchParameters(ResultMapperTests.EMPTY_PARAMS, SearchQuery.EMPTY, searchRequest);
    }

    @Test
    public void toSearchParameters() throws Exception {
        SearchRequestContext searchRequest = SearchRequestContext.from((SearchQuery)this.minimalQuery());
        SearchParameters searchParameters = searchMapper.toSearchParameters(ResultMapperTests.EMPTY_PARAMS, this.minimalQuery(), searchRequest);
        TestCase.assertNotNull((Object)searchParameters);
        TestCase.assertEquals((String)"There should be only 1 default store", (int)1, (int)searchParameters.getStores().size());
        TestCase.assertEquals((String)"workspaces store is the default", (Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, searchParameters.getStores().get(0));
        TestCase.assertEquals((Object)LimitBy.FINAL_SIZE, (Object)searchParameters.getLimitBy());
        TestCase.assertEquals((int)100, (int)searchParameters.getLimit());
        searchParameters = searchMapper.toSearchParameters(ResultMapperTests.EMPTY_PARAMS, helper.searchQueryFromJson(), searchRequest);
        TestCase.assertNotNull((Object)searchParameters);
    }

    @Test
    public void fromQuery() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        try {
            searchMapper.fromQuery(searchParameters, new Query(null, null, null));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("query is a mandatory parameter"));
        }
        Query q = new Query(null, "hello", null);
        searchMapper.fromQuery(searchParameters, q);
        TestCase.assertEquals((String)"fts-alfresco", (String)searchParameters.getLanguage());
        q = new Query("world", "hello", null);
        try {
            searchMapper.fromQuery(searchParameters, q);
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        q = new Query("afts", "hello", null);
        searchMapper.fromQuery(searchParameters, q);
        TestCase.assertEquals((String)"fts-alfresco", (String)searchParameters.getLanguage());
        q = new Query("cMiS", "hello", null);
        searchMapper.fromQuery(searchParameters, q);
        TestCase.assertEquals((String)"cmis-alfresco", (String)searchParameters.getLanguage());
        q = new Query("LuCENE", "hello", null);
        searchMapper.fromQuery(searchParameters, q);
        TestCase.assertEquals((String)"lucene", (String)searchParameters.getLanguage());
        TestCase.assertEquals((String)"hello", (String)searchParameters.getQuery());
        q = new Query("LuCENE", "hello", "Heload");
        searchMapper.fromQuery(searchParameters, q);
        TestCase.assertEquals((String)"Heload", (String)searchParameters.getSearchTerm());
    }

    @Test
    public void fromPaging() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromPaging(searchParameters, null);
        Paging paging = Paging.DEFAULT;
        searchMapper.fromPaging(searchParameters, paging);
        TestCase.assertEquals((int)searchParameters.getLimit(), (int)paging.getMaxItems());
        TestCase.assertEquals((int)searchParameters.getSkipCount(), (int)paging.getSkipCount());
    }

    @Test
    public void fromSort() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromSort(searchParameters, null);
        try {
            searchMapper.fromSort(searchParameters, Arrays.asList(new SortDef("wrongenum", null, false)));
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        searchMapper.fromSort(searchParameters, Arrays.asList(new SortDef("FIELD", "my", true), new SortDef("SCORE", null, false), new SortDef("DOCUMENT", null, true)));
        TestCase.assertEquals((int)3, (int)searchParameters.getSortDefinitions().size());
        searchParameters.getSortDefinitions().forEach(sortDefinition -> {
            switch (sortDefinition.getSortType()) {
                case FIELD: {
                    TestCase.assertEquals((String)"my", (String)sortDefinition.getField());
                    TestCase.assertEquals((boolean)true, (boolean)sortDefinition.isAscending());
                    break;
                }
                case SCORE: {
                    Assert.assertNull((Object)sortDefinition.getField());
                    TestCase.assertEquals((boolean)false, (boolean)sortDefinition.isAscending());
                    break;
                }
                case DOCUMENT: {
                    Assert.assertNull((Object)sortDefinition.getField());
                    TestCase.assertEquals((boolean)true, (boolean)sortDefinition.isAscending());
                    break;
                }
                default: {
                    TestCase.fail((String)"Invalid sortDefinition");
                }
            }
        });
        searchParameters = new SearchParameters();
        searchParameters.setLanguage("cmis-alfresco");
        try {
            searchMapper.fromSort(searchParameters, Arrays.asList(new SortDef("FIELD", null, false)));
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
    }

    @Test
    public void fromTemplate() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromTemplate(searchParameters, null);
        searchMapper.fromTemplate(searchParameters, Arrays.asList(new Template("hedge", "hog"), new Template("king", "kong"), new Template("bish", "bash")));
        TestCase.assertEquals((int)3, (int)searchParameters.getQueryTemplates().size());
        TestCase.assertEquals((String)"hog", (String)((String)searchParameters.getQueryTemplates().get("hedge")));
        TestCase.assertEquals((String)"kong", (String)((String)searchParameters.getQueryTemplates().get("king")));
        TestCase.assertEquals((String)"bash", (String)((String)searchParameters.getQueryTemplates().get("bish")));
    }

    @Test
    public void fromDefaults() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromDefault(searchParameters, null);
        searchMapper.fromDefault(searchParameters, new Default(null, null, null, null, null));
        searchMapper.fromDefault(searchParameters, new Default(null, "AND", null, null, null));
        TestCase.assertEquals((String)"AND", (String)searchParameters.getDefaultFTSOperator().toString());
        searchMapper.fromDefault(searchParameters, new Default(null, null, "or", null, null));
        TestCase.assertEquals((String)"OR", (String)searchParameters.getDefaultFTSFieldOperator().toString());
        try {
            searchMapper.fromDefault(searchParameters, new Default(null, null, "ELSE", null, null));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertNotNull((Object)iae);
        }
        searchMapper.fromDefault(searchParameters, new Default(null, null, null, "nspa", "dfn"));
        TestCase.assertEquals((String)"nspa", (String)searchParameters.getNamespace());
        TestCase.assertEquals((String)"dfn", (String)searchParameters.getDefaultFieldName());
        TestCase.assertEquals((int)0, (int)searchParameters.getTextAttributes().size());
        searchMapper.fromDefault(searchParameters, new Default(Arrays.asList("sausage", "mash"), null, null, null, null));
        TestCase.assertEquals((int)2, (int)searchParameters.getTextAttributes().size());
        TestCase.assertTrue((boolean)searchParameters.getTextAttributes().contains("sausage"));
        TestCase.assertTrue((boolean)searchParameters.getTextAttributes().contains("mash"));
    }

    @Test
    public void searchParameterIncludesValidation_validInclude_shouldReturnSuccessfulValidation() {
        searchMapper.validateInclude(Arrays.asList("allowableOperations", "aspectNames", "isLink", "path", "properties", "association", "isLocked", "permissions"));
    }

    @Test
    public void searchParameterIncludesValidation_invalidInclude_shouldThrowInvalidArgumentException() throws Exception {
        try {
            searchMapper.validateInclude(Arrays.asList("allowableOperations", "aspectNames", "isLink", "path", "notValid", "association", "isLocked"));
            TestCase.fail();
        }
        catch (InvalidArgumentException exception) {
            TestCase.assertNotNull((Object)((Object)exception));
        }
    }

    @Test
    public void validateInclude() throws Exception {
        try {
            searchMapper.validateInclude(Arrays.asList("sausage"));
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        searchMapper.validateInclude(null);
        try {
            searchMapper.validateInclude(Arrays.asList("AspectNames"));
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        searchMapper.validateInclude(Arrays.asList("properties", "aspectNames"));
    }

    @Test
    public void fromFilterQuery() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("hedgehog", null, null), new FilterQuery("king", null, null)));
        TestCase.assertEquals((int)2, (int)searchParameters.getFilterQueries().size());
        TestCase.assertEquals((String)"hedgehog", (String)((String)searchParameters.getFilterQueries().get(0)));
        TestCase.assertEquals((String)"king", (String)((String)searchParameters.getFilterQueries().get(1)));
        searchParameters = new SearchParameters();
        searchParameters.setLanguage("cmis-alfresco");
        try {
            searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("hedgehog", null, null)));
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        try {
            searchParameters.setLanguage("index-alfresco");
            searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery(null, null, null)));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertNotNull((Object)iae);
        }
        searchParameters = new SearchParameters();
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("{!afts}description:xyz", Arrays.asList("desc1", "desc2"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1,desc2 }description:xyz", (String)((String)searchParameters.getFilterQueries().get(0)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("{!afts}description:xyz", Arrays.asList("desc1"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1 }description:xyz", (String)((String)searchParameters.getFilterQueries().get(1)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("description:xyz", Arrays.asList("desc1"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1 }description:xyz", (String)((String)searchParameters.getFilterQueries().get(2)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("{!afts} description:xyz", Arrays.asList("desc1"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1 } description:xyz", (String)((String)searchParameters.getFilterQueries().get(3)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery(" {!afts cake} description:xyz", Arrays.asList("desc1"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1 cake} description:xyz", (String)((String)searchParameters.getFilterQueries().get(4)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("{!afts tag=desc1}description:xyz", Arrays.asList("desc1"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1}description:xyz", (String)((String)searchParameters.getFilterQueries().get(5)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("created:2011", Arrays.asList("desc1"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1 }created:2011", (String)((String)searchParameters.getFilterQueries().get(6)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("=cm:name:cabbage", Arrays.asList("desc1"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1 }=cm:name:cabbage", (String)((String)searchParameters.getFilterQueries().get(7)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("{http://www.alfresco.org/model/content/1.0}title:workflow", null, null)));
        TestCase.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}title:workflow", (String)((String)searchParameters.getFilterQueries().get(8)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("{http://www.alfresco.org/model/content/1.0}title:workflow", Arrays.asList("desc1"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1 }{http://www.alfresco.org/model/content/1.0}title:workflow", (String)((String)searchParameters.getFilterQueries().get(9)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("{!afts} description:xyz", Arrays.asList("desc1", "desc2"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1,desc2 }description:xyz", (String)((String)searchParameters.getFilterQueries().get(0)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("{ !afts } description:xyz", Arrays.asList("desc1", "desc2"), null)));
        TestCase.assertEquals((String)"{!afts tag=desc1,desc2 }description:xyz", (String)((String)searchParameters.getFilterQueries().get(0)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery(null, Arrays.asList("desc1"), Arrays.asList("cm:name:cabbage", "cm:creator:bob"))));
        TestCase.assertEquals((String)"{!afts tag=desc1 }cm:name:cabbage OR cm:creator:bob", (String)((String)searchParameters.getFilterQueries().get(12)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery(null, null, Arrays.asList("cm:name:cabbage", "cm:creator:bob"))));
        TestCase.assertEquals((String)"cm:name:cabbage OR cm:creator:bob", (String)((String)searchParameters.getFilterQueries().get(13)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery(null, null, Arrays.asList("cm:name:cabbage"))));
        TestCase.assertEquals((String)"cm:name:cabbage", (String)((String)searchParameters.getFilterQueries().get(14)));
        searchMapper.fromFilterQuery(searchParameters, Arrays.asList(new FilterQuery("created:2011", null, Arrays.asList("cm:name:cabbage"))));
        TestCase.assertEquals((String)"Single query should take precident over multiple queries ORed together.", (String)"created:2011", (String)((String)searchParameters.getFilterQueries().get(15)));
    }

    @Test
    public void fromFacetQuery() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromFacetQuery(searchParameters, null);
        searchMapper.fromFacetQuery(searchParameters, Arrays.asList(new FacetQuery("ping", null, null), new FacetQuery("pong", "table", null)));
        TestCase.assertEquals((int)2, (int)searchParameters.getFacetQueries().size());
        TestCase.assertEquals((String)"{!afts key='ping'}ping", (String)((String)searchParameters.getFacetQueries().get(0)));
        TestCase.assertEquals((String)"{!afts key='table'}pong", (String)((String)searchParameters.getFacetQueries().get(1)));
        try {
            searchMapper.fromFacetQuery(searchParameters, Arrays.asList(new FacetQuery("ping", null, null), new FacetQuery("{!afts}pang", "tennis", null)));
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
    }

    @Test
    public void fromSpelling() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromSpellCheck(searchParameters, null);
        Assert.assertFalse((boolean)searchParameters.isSpellCheck());
        try {
            searchMapper.fromSpellCheck(searchParameters, new Spelling(null));
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        searchParameters.setSearchTerm("fred");
        searchMapper.fromSpellCheck(searchParameters, new Spelling(null));
        TestCase.assertEquals((String)"fred", (String)searchParameters.getSearchTerm());
        searchMapper.fromSpellCheck(searchParameters, new Spelling("favourit"));
        TestCase.assertEquals((String)"favourit", (String)searchParameters.getSearchTerm());
        TestCase.assertTrue((boolean)searchParameters.isSpellCheck());
    }

    @Test
    public void fromScope() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.setDefaults(searchParameters);
        SearchRequestContext searchRequestContext = SearchRequestContext.from((SearchQuery)this.minimalQuery());
        searchMapper.fromScope(searchParameters, null, searchRequestContext);
        TestCase.assertEquals((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, searchParameters.getStores().get(0));
        searchMapper.fromScope(searchParameters, new Scope(null), searchRequestContext);
        TestCase.assertEquals((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, searchParameters.getStores().get(0));
        try {
            searchMapper.fromScope(searchParameters, new Scope(Arrays.asList("nonsense")), searchRequestContext);
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        searchMapper.fromScope(searchParameters, new Scope(Arrays.asList("deleted-nodes", "nodes", "versions")), searchRequestContext);
        TestCase.assertEquals((int)3, (int)searchParameters.getStores().size());
        TestCase.assertEquals((String)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE.toString(), (String)((StoreRef)searchParameters.getStores().get(0)).toString());
        TestCase.assertEquals((String)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.toString(), (String)((StoreRef)searchParameters.getStores().get(1)).toString());
        TestCase.assertEquals((String)StoreMapper.STORE_REF_VERSION2_SPACESSTORE.toString(), (String)((StoreRef)searchParameters.getStores().get(2)).toString());
        searchMapper.fromScope(searchParameters, new Scope(Arrays.asList("history")), searchRequestContext);
        TestCase.assertEquals((int)1, (int)searchParameters.getStores().size());
        TestCase.assertEquals((String)StoreMapper.STORE_REF_HISTORY.toString(), (String)((StoreRef)searchParameters.getStores().get(0)).toString());
        try {
            searchMapper.fromScope(searchParameters, new Scope(Arrays.asList("history", "deleted-nodes")), searchRequestContext);
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        try {
            searchMapper.fromScope(searchParameters, new Scope(Arrays.asList("history", "nodes")), searchRequestContext);
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        try {
            searchMapper.fromScope(searchParameters, new Scope(Arrays.asList("history", "versions")), searchRequestContext);
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
    }

    @Test
    public void fromTimezone() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, null);
        searchMapper.fromLocalization(searchParameters, new Localization("", null));
        try {
            searchMapper.fromLocalization(searchParameters, new Localization("nonsense", null));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("Invalid timezone"));
        }
        try {
            searchMapper.fromLocalization(searchParameters, new Localization("GMT+25", null));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("Invalid timezone"));
        }
        searchMapper.fromLocalization(searchParameters, new Localization("America/New_York", null));
        TestCase.assertEquals((String)"America/New_York", (String)searchParameters.getTimezone());
        searchMapper.fromLocalization(searchParameters, new Localization("America/Denver", null));
        TestCase.assertEquals((String)"America/Denver", (String)searchParameters.getTimezone());
        searchMapper.fromLocalization(searchParameters, new Localization("America/Los_Angeles", null));
        TestCase.assertEquals((String)"America/Los_Angeles", (String)searchParameters.getTimezone());
        searchMapper.fromLocalization(searchParameters, new Localization("Europe/Madrid", null));
        TestCase.assertEquals((String)"Europe/Madrid", (String)searchParameters.getTimezone());
        searchMapper.fromLocalization(searchParameters, new Localization("GMT+1", null));
        TestCase.assertEquals((String)"GMT+01:00", (String)searchParameters.getTimezone());
        searchMapper.fromLocalization(searchParameters, new Localization("GMT+01:00", null));
        TestCase.assertEquals((String)"GMT+01:00", (String)searchParameters.getTimezone());
        searchMapper.fromLocalization(searchParameters, new Localization("GMT-9", null));
        TestCase.assertEquals((String)"GMT-09:00", (String)searchParameters.getTimezone());
        searchMapper.fromLocalization(searchParameters, new Localization("GMT+08:00", null));
        TestCase.assertEquals((String)"GMT+08:00", (String)searchParameters.getTimezone());
        searchMapper.fromLocalization(searchParameters, new Localization("GMT-12:00", null));
        TestCase.assertEquals((String)"GMT-12:00", (String)searchParameters.getTimezone());
        try {
            searchMapper.fromLocalization(searchParameters, new Localization("UTC+5", null));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((String)"UTC is not support by java.util.timezone", (boolean)iae.getLocalizedMessage().contains("Incompatible timezoneId"));
        }
        try {
            searchMapper.fromLocalization(searchParameters, new Localization("UTC+06:00", null));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("Incompatible timezoneId"));
        }
    }

    @Test
    public void fromLocales() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, null);
        searchMapper.fromLocalization(searchParameters, new Localization(null, null));
        ArrayList<Object> testLocales = new ArrayList<Object>();
        testLocales.add(null);
        try {
            searchMapper.fromLocalization(searchParameters, new Localization(null, testLocales));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("Invalid locale"));
        }
        searchMapper.fromLocalization(searchParameters, new Localization(null, Arrays.asList("NOTTHIS")));
        searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, new Localization(null, Arrays.asList("fr")));
        TestCase.assertEquals((Object)Locale.FRENCH, searchParameters.getLocales().get(0));
        searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, new Localization(null, Arrays.asList("fr_FR")));
        TestCase.assertEquals((Object)Locale.FRANCE, searchParameters.getLocales().get(0));
        searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, new Localization(null, Arrays.asList("fr-FR")));
        TestCase.assertEquals((Object)Locale.FRANCE, searchParameters.getLocales().get(0));
        searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, new Localization(null, Arrays.asList("fr-fr")));
        TestCase.assertEquals((Object)Locale.FRANCE, (Object)searchParameters.getSortLocale());
        searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, new Localization(null, Arrays.asList("fr-ca")));
        TestCase.assertEquals((Object)Locale.CANADA_FRENCH, (Object)searchParameters.getSortLocale());
        searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, new Localization(null, Arrays.asList("fr_ca")));
        TestCase.assertEquals((Object)Locale.CANADA_FRENCH, (Object)searchParameters.getSortLocale());
        searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, new Localization(null, Arrays.asList("en-gb")));
        TestCase.assertEquals((Object)Locale.UK, (Object)searchParameters.getSortLocale());
        searchParameters = new SearchParameters();
        searchMapper.fromLocalization(searchParameters, new Localization(null, Arrays.asList("en-us")));
        TestCase.assertEquals((Object)Locale.US, (Object)searchParameters.getSortLocale());
    }

    @Test
    public void fromFacetFields() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromFacetFields(searchParameters, null);
        try {
            searchMapper.fromFacetFields(searchParameters, new FacetFields(null));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("facetFields facets is a mandatory parameter"));
        }
        try {
            searchMapper.fromFacetFields(searchParameters, new FacetFields(Arrays.asList(new FacetField(null, null, null, null, null, null, null, null, null, null, null))));
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("facetFields facet field is a mandatory parameter"));
        }
        searchMapper.fromFacetFields(searchParameters, new FacetFields(Arrays.asList(new FacetField("myfield", null, null, null, null, null, null, null, null, null, null))));
        TestCase.assertEquals((int)1, (int)searchParameters.getFieldFacets().size());
        SearchParameters.FieldFacet ff = (SearchParameters.FieldFacet)searchParameters.getFieldFacets().get(0);
        Assert.assertNull((Object)ff.getLimitOrNull());
        TestCase.assertEquals((int)0, (int)ff.getOffset());
        TestCase.assertEquals((int)1, (int)ff.getMinCount());
        Assert.assertFalse((boolean)ff.isCountDocsMissingFacetField());
        TestCase.assertEquals((int)0, (int)ff.getEnumMethodCacheMinDF());
        searchParameters = new SearchParameters();
        searchMapper.fromFacetFields(searchParameters, new FacetFields(Arrays.asList(new FacetField("myfield", "mylabel", "myprefix", null, null, null, null, null, null, null, null))));
        ff = (SearchParameters.FieldFacet)searchParameters.getFieldFacets().get(0);
        TestCase.assertEquals((String)"myprefix", (String)ff.getPrefix());
        try {
            searchMapper.fromFacetFields(searchParameters, new FacetFields(Arrays.asList(new FacetField("myfield", null, null, "badsort", null, null, null, null, null, null, null))));
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        try {
            searchMapper.fromFacetFields(searchParameters, new FacetFields(Arrays.asList(new FacetField("myfield", null, null, null, "badmethod", null, null, null, null, null, null))));
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        searchParameters = new SearchParameters();
        searchMapper.fromFacetFields(searchParameters, new FacetFields(Arrays.asList(new FacetField("myfield", null, null, "INDEX", "ENUM", null, null, null, null, null, null))));
        ff = (SearchParameters.FieldFacet)searchParameters.getFieldFacets().get(0);
        TestCase.assertEquals((String)"INDEX", (String)ff.getSort().toString());
        TestCase.assertEquals((String)"ENUM", (String)ff.getMethod().toString());
    }

    @Test
    public void fromLimits() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.setDefaults(searchParameters);
        searchMapper.fromLimits(searchParameters, null);
        TestCase.assertEquals((int)500, (int)searchParameters.getLimit());
        TestCase.assertEquals((Object)LimitBy.UNLIMITED, (Object)searchParameters.getLimitBy());
        searchMapper.fromLimits(searchParameters, new Limits(null, null));
        TestCase.assertEquals((Object)LimitBy.UNLIMITED, (Object)searchParameters.getLimitBy());
        TestCase.assertEquals((int)500, (int)searchParameters.getLimit());
        searchMapper.fromLimits(searchParameters, new Limits(null, Integer.valueOf(34)));
        TestCase.assertEquals((Object)LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS, (Object)searchParameters.getLimitBy());
        TestCase.assertEquals((int)34, (int)searchParameters.getMaxPermissionChecks());
        TestCase.assertEquals((int)-1, (int)searchParameters.getLimit());
        TestCase.assertEquals((long)-1L, (long)searchParameters.getMaxPermissionCheckTimeMillis());
        searchParameters = new SearchParameters();
        searchMapper.setDefaults(searchParameters);
        searchMapper.fromLimits(searchParameters, new Limits(Integer.valueOf(1000), null));
        TestCase.assertEquals((Object)LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS, (Object)searchParameters.getLimitBy());
        TestCase.assertEquals((long)1000L, (long)searchParameters.getMaxPermissionCheckTimeMillis());
        TestCase.assertEquals((int)-1, (int)searchParameters.getLimit());
        TestCase.assertEquals((int)-1, (int)searchParameters.getMaxPermissionChecks());
    }

    @Test
    public void fromHighlight() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        List<FieldHighlightParameters> fields = Arrays.asList(new FieldHighlightParameters("desc", Integer.valueOf(50), Integer.valueOf(100), Boolean.valueOf(false), "@", "#"), new FieldHighlightParameters("title", Integer.valueOf(55), Integer.valueOf(105), Boolean.valueOf(true), "*", "\u00bf"));
        GeneralHighlightParameters highlightParameters = new GeneralHighlightParameters(Integer.valueOf(5), Integer.valueOf(10), Boolean.valueOf(false), "{", "}", Integer.valueOf(20), Boolean.valueOf(true), fields);
        searchMapper.fromHighlight(searchParameters, highlightParameters);
        TestCase.assertEquals((Object)searchParameters.getHighlight(), (Object)highlightParameters);
    }

    @Test
    public void fromStats() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromStats(searchParameters, null);
        ArrayList<StatsRequestParameters> statsRequestParameters = new ArrayList<StatsRequestParameters>(1);
        statsRequestParameters.add(new StatsRequestParameters(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null));
        try {
            searchMapper.fromStats(searchParameters, statsRequestParameters);
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("field is a mandatory parameter"));
        }
        statsRequestParameters.clear();
        statsRequestParameters.add(new StatsRequestParameters("cm:content", "myLabel", null, null, null, null, null, null, null, null, null, null, null, null, null, null));
        searchMapper.fromStats(searchParameters, statsRequestParameters);
        TestCase.assertEquals((int)1, (int)searchParameters.getStats().size());
        statsRequestParameters.clear();
        statsRequestParameters.add(new StatsRequestParameters("cm:content", "myLabel", Arrays.asList(Float.valueOf(3.4f), Float.valueOf(12.0f), Float.valueOf(10.0f)), null, null, null, null, null, null, null, null, null, null, null, null, null));
        searchMapper.fromStats(searchParameters, statsRequestParameters);
        TestCase.assertEquals((int)1, (int)searchParameters.getStats().size());
        statsRequestParameters.clear();
        statsRequestParameters.add(new StatsRequestParameters("cm:content", "myLabel", Arrays.asList(Float.valueOf(-3.4f)), null, null, null, null, null, null, null, null, null, null, null, null, null));
        try {
            searchMapper.fromStats(searchParameters, statsRequestParameters);
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("Invalid percentile -3.4"));
        }
        statsRequestParameters.clear();
        statsRequestParameters.add(new StatsRequestParameters("cm:content", "myLabel", Arrays.asList(Float.valueOf(101.0f)), null, null, null, null, null, null, null, null, null, null, null, null, null));
        try {
            searchMapper.fromStats(searchParameters, statsRequestParameters);
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("Invalid percentile 101"));
        }
        statsRequestParameters.clear();
        statsRequestParameters.add(new StatsRequestParameters("cm:content", "myLabel", null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), Float.valueOf(12.0f), null));
        try {
            searchMapper.fromStats(searchParameters, statsRequestParameters);
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertTrue((boolean)iae.getLocalizedMessage().contains("Invalid cardinality accuracy 12.0"));
        }
        statsRequestParameters.clear();
        statsRequestParameters.add(new StatsRequestParameters("cm:content", "myLabel", null, null, null, null, null, null, null, null, null, null, null, null, Float.valueOf(12.0f), null));
        searchMapper.fromStats(searchParameters, statsRequestParameters);
        TestCase.assertEquals((int)1, (int)searchParameters.getStats().size());
    }

    @Test
    public void fromPivot() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        searchMapper.fromPivot(searchParameters, null, null, null, null, null);
        ArrayList<FacetField> facets = new ArrayList<FacetField>(1);
        facets.add(new FacetField("myfield", null, null, null, null, null, null, null, null, null, null));
        facets.add(new FacetField("yourfield", null, null, null, null, null, null, null, null, null, null));
        FacetFields ff = new FacetFields(facets);
        searchMapper.fromFacetFields(searchParameters, ff);
        searchMapper.fromPivot(searchParameters, null, ff, null, null, null);
        TestCase.assertEquals((int)2, (int)searchParameters.getFieldFacets().size());
        TestCase.assertEquals((int)0, (int)searchParameters.getPivots().size());
        searchParameters = new SearchParameters();
        try {
            searchMapper.fromPivot(searchParameters, null, ff, null, Arrays.asList(new Pivot(null, null)), null);
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertNotNull((Object)iae);
        }
        try {
            searchMapper.fromPivot(searchParameters, null, ff, null, Arrays.asList(new Pivot("", null)), null);
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertNotNull((Object)iae);
        }
        SearchRequestContext searchRequestContext = SearchRequestContext.from((SearchQuery)this.minimalQuery());
        StatsRequestParameters bobf = new StatsRequestParameters("bob", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        StatsRequestParameters bobL = new StatsRequestParameters("creator", "bob", null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        try {
            searchMapper.fromPivot(searchParameters, Arrays.asList(bobf), ff, null, Arrays.asList(new Pivot("bob", null)), searchRequestContext);
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        searchMapper.fromPivot(searchParameters, Arrays.asList(bobf), ff, null, Arrays.asList(new Pivot("yourfield", Arrays.asList(new Pivot("bob", null)))), searchRequestContext);
        TestCase.assertEquals((int)1, (int)searchParameters.getPivots().size());
        try {
            searchMapper.fromPivot(searchParameters, null, ff, null, Arrays.asList(new Pivot("ken", null), new Pivot("bob", null)), searchRequestContext);
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        searchParameters = new SearchParameters();
        searchMapper.fromPivot(searchParameters, null, ff, null, Arrays.asList(new Pivot("myfield", null)), searchRequestContext);
        searchMapper.fromFacetFields(searchParameters, ff);
        TestCase.assertEquals((int)0, (int)searchParameters.getFieldFacets().size());
        TestCase.assertEquals((int)1, (int)searchParameters.getPivots().size());
        TestCase.assertEquals((String)"myfield", (String)((String)((List)searchParameters.getPivots().get(0)).get(0)));
        searchParameters = new SearchParameters();
        try {
            searchMapper.fromPivot(searchParameters, Arrays.asList(bobf), ff, null, Arrays.asList(new Pivot("bob", Arrays.asList(new Pivot("hope", null)))), searchRequestContext);
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        searchRequestContext = SearchRequestContext.from((SearchQuery)this.minimalQuery());
        facets = new ArrayList(1);
        facets.add(new FacetField("king", null, null, null, null, null, null, null, null, null, null));
        ff = new FacetFields(facets);
        searchMapper.fromPivot(searchParameters, Arrays.asList(bobf), ff, null, Arrays.asList(new Pivot("king", Arrays.asList(new Pivot("bob", null)))), searchRequestContext);
        TestCase.assertEquals((int)1, (int)searchParameters.getPivots().size());
        TestCase.assertEquals((int)2, (int)((List)searchParameters.getPivots().get(0)).size());
        TestCase.assertEquals((String)"king", (String)((String)((List)searchParameters.getPivots().get(0)).get(0)));
        TestCase.assertEquals((String)"bob", (String)((String)((List)searchParameters.getPivots().get(0)).get(1)));
        searchRequestContext = SearchRequestContext.from((SearchQuery)this.minimalQuery());
        searchParameters = new SearchParameters();
        facets = new ArrayList(1);
        facets.add(new FacetField("king", null, null, null, null, null, null, null, null, null, null));
        facets.add(new FacetField("kong", null, null, null, null, null, null, null, null, null, null));
        facets.add(new FacetField("kang", null, null, null, null, null, null, null, null, null, null));
        ff = new FacetFields(facets);
        searchMapper.fromPivot(searchParameters, Arrays.asList(bobf), ff, null, Arrays.asList(new Pivot("king", Arrays.asList(new Pivot("bob", null))), new Pivot("kong", null)), searchRequestContext);
        TestCase.assertEquals((int)2, (int)searchParameters.getPivots().size());
        TestCase.assertEquals((int)2, (int)((List)searchParameters.getPivots().get(0)).size());
        TestCase.assertEquals((String)"king", (String)((String)((List)searchParameters.getPivots().get(0)).get(0)));
        TestCase.assertEquals((String)"bob", (String)((String)((List)searchParameters.getPivots().get(0)).get(1)));
        TestCase.assertEquals((String)"kong", (String)((String)((List)searchParameters.getPivots().get(1)).get(0)));
        searchRequestContext = SearchRequestContext.from((SearchQuery)this.minimalQuery());
        searchParameters = new SearchParameters();
        ArrayList<RangeParameters> rangeParams = new ArrayList<RangeParameters>();
        facets = new ArrayList(2);
        facets.add(new FacetField("king", null, null, null, null, null, null, null, null, null, null));
        facets.add(new FacetField("kong", null, null, null, null, null, null, null, null, null, null));
        ff = new FacetFields(facets);
        rangeParams.add(new RangeParameters("content.size", "0", "100000", "1000", true, null, null, "hope", null));
        searchMapper.fromPivot(searchParameters, Arrays.asList(bobf), ff, rangeParams, Arrays.asList(new Pivot("king", Arrays.asList(new Pivot("bob", null))), new Pivot("kong", Arrays.asList(new Pivot("hope", null)))), searchRequestContext);
        TestCase.assertEquals((int)2, (int)searchParameters.getPivots().size());
        TestCase.assertEquals((int)2, (int)((List)searchParameters.getPivots().get(0)).size());
        TestCase.assertEquals((String)"king", (String)((String)((List)searchParameters.getPivots().get(0)).get(0)));
        TestCase.assertEquals((String)"bob", (String)((String)((List)searchParameters.getPivots().get(0)).get(1)));
        TestCase.assertEquals((String)"kong", (String)((String)((List)searchParameters.getPivots().get(1)).get(0)));
        TestCase.assertEquals((String)"hope", (String)((String)((List)searchParameters.getPivots().get(1)).get(1)));
    }

    @Test
    public void fromInterval() throws Exception {
        SearchParameters searchParameters = new SearchParameters();
        IntervalParameters intervalParameters = new IntervalParameters(null, null);
        try {
            searchMapper.fromFacetIntervals(searchParameters, intervalParameters);
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertNotNull((Object)iae);
        }
        HashSet<Object> intervalSets = new HashSet<IntervalSet>(Arrays.asList(new IntervalSet(null, "1", null, null, null)));
        List<Interval> intervalList = Arrays.asList(new Interval(null, "bob", null));
        intervalParameters = new IntervalParameters(intervalSets, intervalList);
        try {
            searchMapper.fromFacetIntervals(searchParameters, intervalParameters);
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertNotNull((Object)iae);
        }
        intervalList = Arrays.asList(new Interval("aFileld", "bob", null));
        intervalParameters = new IntervalParameters(intervalSets, intervalList);
        try {
            searchMapper.fromFacetIntervals(searchParameters, intervalParameters);
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertNotNull((Object)iae);
        }
        intervalSets = new HashSet<IntervalSet>(Arrays.asList(new IntervalSet("1", null, null, null, Boolean.valueOf(true))));
        intervalParameters = new IntervalParameters(intervalSets, intervalList);
        try {
            searchMapper.fromFacetIntervals(searchParameters, intervalParameters);
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertNotNull((Object)iae);
        }
        intervalSets = new HashSet();
        intervalSets.add(new IntervalSet("0", "3", "bob", null, null));
        intervalSets.add(new IntervalSet("30", "50", "bill", Boolean.valueOf(true), Boolean.valueOf(true)));
        HashSet<IntervalSet> anIntervalSet = new HashSet<IntervalSet>();
        anIntervalSet.add(new IntervalSet("1", "10", "bert", Boolean.valueOf(false), Boolean.valueOf(false)));
        intervalList = Arrays.asList(new Interval("cm:price", "Price", null), new Interval("cm:price", "Price", anIntervalSet));
        intervalParameters = new IntervalParameters(intervalSets, intervalList);
        try {
            searchMapper.fromFacetIntervals(searchParameters, intervalParameters);
            TestCase.fail();
        }
        catch (InvalidArgumentException iae) {
            TestCase.assertNotNull((Object)((Object)iae));
        }
        intervalList = Arrays.asList(new Interval("cm:price", "Prices", null), new Interval("cm:price", "Pricey", anIntervalSet));
        intervalParameters = new IntervalParameters(intervalSets, intervalList);
        searchMapper.fromFacetIntervals(searchParameters, intervalParameters);
        TestCase.assertEquals((Object)searchParameters.getInterval(), (Object)intervalParameters);
    }

    @Test
    public void facetFormatV2() {
        Query query = new Query("afts", "a*", "");
        SearchQuery sq = new SearchQuery(query, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, FacetFormat.V2);
        SearchRequestContext searchRequestContext = SearchRequestContext.from((SearchQuery)sq);
        SearchParameters searchParameters = searchMapper.toSearchParameters(ResultMapperTests.EMPTY_PARAMS, sq, searchRequestContext);
        TestCase.assertNotNull((Object)searchParameters);
        TestCase.assertEquals((String)"There should be only 1 default store", (int)1, (int)searchParameters.getStores().size());
        TestCase.assertEquals((String)"workspaces store is the default", (Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, searchParameters.getStores().get(0));
        TestCase.assertEquals((Object)LimitBy.FINAL_SIZE, (Object)searchParameters.getLimitBy());
        TestCase.assertEquals((int)100, (int)searchParameters.getLimit());
    }

    @Test
    public void facetRange() {
        SearchParameters searchParameters = new SearchParameters();
        ArrayList<RangeParameters> rangeParams = new ArrayList<RangeParameters>();
        rangeParams.add(new RangeParameters(null, null, null, null, false, null, null, null, null));
        try {
            searchMapper.fromRange(searchParameters, rangeParams);
            TestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            TestCase.assertNotNull((Object)iae);
        }
        rangeParams.clear();
        rangeParams.add(new RangeParameters("content.size", "0", "100000", "1000", true, null, null, null, null));
        searchMapper.fromRange(searchParameters, rangeParams);
        TestCase.assertEquals((Object)searchParameters.getRanges(), rangeParams);
        rangeParams.clear();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("lower");
        ArrayList other = new ArrayList();
        includes.add("before");
        rangeParams.add(new RangeParameters("content.size", "0", "100000", "1000", true, other, includes, null, null));
        searchMapper.fromRange(searchParameters, rangeParams);
        TestCase.assertEquals((Object)searchParameters.getRanges(), rangeParams);
        rangeParams.add(new RangeParameters("created", "2015-09-29T10:45:15.729Z", "2016-09-29T10:45:15.729Z", "+100DAY", true, other, includes, null, null));
        searchMapper.fromRange(searchParameters, rangeParams);
        TestCase.assertEquals((Object)searchParameters.getRanges(), rangeParams);
        TestCase.assertEquals((int)2, (int)searchParameters.getRanges().size());
    }

    private SearchQuery minimalQuery() {
        Query query = new Query("cmis", "foo", "");
        SearchQuery sq = new SearchQuery(query, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        return sq;
    }
}

