/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.test.workflow.api.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.workflow.api.Processes;
import org.alfresco.rest.workflow.api.model.ProcessInfo;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public class ProcessesImplTest
extends TestCase
implements RecognizedParamsExtractor {
    private static final String[] CONFIG_LOCATIONS = new String[ApplicationContextHelper.CONFIG_LOCATIONS.length + 2];
    private static final int ACTIVE_WORKFLOWS_INITIAL_AMOUNT = 25;
    private static final String PROCESSES_BEAN_NAME = "processes";
    private static final String DESIRED_WORKFLOW_ID_PREFIX = "activiti$activitiReview";
    private static final String QUERY_STATUS_ACTIVE = "(status=active)";
    private static final String QUERY_WORKFLOWDESCRIPTION_MATCHES = "(variables/bpm_workflowDescription MATCHES ('%s'))";
    private ApplicationContext applicationContext;
    private WorkflowService workflowService;
    private PersonService personService;
    private Processes processes;
    private UserTransaction transaction;

    @Before
    public void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext((String[])CONFIG_LOCATIONS);
        this.processes = (Processes)this.applicationContext.getBean(PROCESSES_BEAN_NAME);
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.workflowService = registry.getWorkflowService();
        this.personService = registry.getPersonService();
        this.transaction = registry.getTransactionService().getUserTransaction();
        this.transaction.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef adminUserNodeRef = this.personService.getPerson(AuthenticationUtil.getAdminUserName());
        WorkflowDefinition workflowDefinition = this.findAppropriateWorkflowDefinitionId();
        for (int i = 0; i < 25; ++i) {
            this.startWorkflow(workflowDefinition, adminUserNodeRef);
        }
    }

    private void startWorkflow(WorkflowDefinition neededDefinition, NodeRef assignee) {
        HashMap<QName, Object> parameters = new HashMap<QName, Object>();
        parameters.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)((Object)Collections.singletonList(assignee)));
        parameters.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, "Test workflow api calls review and approve");
        this.workflowService.startWorkflow(neededDefinition.getId(), parameters);
    }

    private WorkflowDefinition findAppropriateWorkflowDefinitionId() {
        WorkflowDefinition result = null;
        List definitions = this.workflowService.getDefinitions();
        for (WorkflowDefinition definition : definitions) {
            if (!definition.getId().startsWith(DESIRED_WORKFLOW_ID_PREFIX)) continue;
            result = definition;
            break;
        }
        return null != result ? result : (WorkflowDefinition)definitions.iterator().next();
    }

    @After
    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        if (null != this.transaction && 3 != this.transaction.getStatus() && 4 != this.transaction.getStatus()) {
            this.transaction.rollback();
        }
    }

    @Test
    public void testHasMoreItemsTrue() throws Exception {
        CollectionWithPagingInfo<ProcessInfo> actualProcesses = this.queryActiveProcessesAndAssertResult(0, 20);
        ProcessesImplTest.assertTrue((boolean)actualProcesses.hasMoreItems());
        actualProcesses = this.queryActiveProcessesAndAssertResult(10, 10);
        ProcessesImplTest.assertTrue((boolean)actualProcesses.hasMoreItems());
    }

    @Test
    public void testHasMoreFalseAsPerMnt10977() throws Exception {
        CollectionWithPagingInfo<ProcessInfo> actualProcesses = this.queryActiveProcessesAndAssertResult(5, 25);
        ProcessesImplTest.assertFalse((boolean)actualProcesses.hasMoreItems());
    }

    @Test
    public void testHasMoreFalseAsPerMnt13567() throws Exception {
        CollectionWithPagingInfo<ProcessInfo> actualProcesses = this.queryActiveProcessesAndAssertResult(25, 25);
        ProcessesImplTest.assertFalse((boolean)actualProcesses.hasMoreItems());
        actualProcesses = this.queryActiveProcessesAndAssertResult(26, 25);
        ProcessesImplTest.assertFalse((boolean)actualProcesses.hasMoreItems());
    }

    @Test
    public void testGetProcessesMatchesIgnoreCase() {
        CollectionWithPagingInfo<ProcessInfo> result = this.queryMatchesProcesses("(?i)test workflow api calls review and approve");
        ProcessesImplTest.assertNotNull(result);
        ProcessesImplTest.assertNotNull((Object)result.getCollection());
        ProcessesImplTest.assertTrue((result.getTotalItems() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetProcessesMatchesIgnoreCaseNoResults() {
        CollectionWithPagingInfo<ProcessInfo> result = this.queryMatchesProcesses("test workflow api calls review and approve");
        ProcessesImplTest.assertNotNull(result);
        ProcessesImplTest.assertNotNull((Object)result.getCollection());
        ProcessesImplTest.assertTrue((result.getTotalItems() == 0 ? 1 : 0) != 0);
    }

    private CollectionWithPagingInfo<ProcessInfo> queryMatchesProcesses(String matchesString) {
        Query query = this.getWhereClause(String.format(QUERY_WORKFLOWDESCRIPTION_MATCHES, matchesString));
        Params parameters = Params.valueOf((Params.RecognizedParams)new Params.RecognizedParams(null, Paging.valueOf((int)0, (int)25), null, null, null, null, query, null, false), null, null, null);
        return this.processes.getProcesses((Parameters)parameters);
    }

    private CollectionWithPagingInfo<ProcessInfo> queryActiveProcessesAndAssertResult(int skipCount, int maxItems) {
        int remainingProcessesAmount;
        Query query = this.getWhereClause(QUERY_STATUS_ACTIVE);
        Params parameters = Params.valueOf((Params.RecognizedParams)new Params.RecognizedParams(null, Paging.valueOf((int)skipCount, (int)maxItems), null, null, null, null, query, null, false), null, null, null);
        CollectionWithPagingInfo result = this.processes.getProcesses((Parameters)parameters);
        ProcessesImplTest.assertNotNull((Object)result);
        ProcessesImplTest.assertNotNull((Object)result.getCollection());
        int n = remainingProcessesAmount = skipCount > 25 ? 0 : 25 - skipCount;
        if (maxItems >= remainingProcessesAmount) {
            ProcessesImplTest.assertEquals((int)remainingProcessesAmount, (int)result.getCollection().size());
        } else {
            ProcessesImplTest.assertEquals((int)maxItems, (int)result.getCollection().size());
        }
        return result;
    }

    static {
        System.arraycopy(ApplicationContextHelper.CONFIG_LOCATIONS, 0, CONFIG_LOCATIONS, 0, ApplicationContextHelper.CONFIG_LOCATIONS.length);
        int index = ApplicationContextHelper.CONFIG_LOCATIONS.length;
        ProcessesImplTest.CONFIG_LOCATIONS[index++] = "classpath:alfresco/public-rest-context.xml";
        ProcessesImplTest.CONFIG_LOCATIONS[index++] = "classpath:alfresco/web-scripts-application-context.xml";
    }
}

