/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.alfresco.opencmis.BaseUrlGenerator;
import org.alfresco.opencmis.CMISDispatcherRegistry;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.web.scripts.TenantWebScriptServletRequest;
import org.alfresco.service.descriptor.Descriptor;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRuntime;

public class CMISHttpServletRequest
implements HttpServletRequest {
    protected WebScriptRequest req;
    protected HttpServletRequest httpReq;
    protected String networkId;
    protected String operation;
    protected String id;
    protected String serviceName;
    protected BaseUrlGenerator baseUrlGenerator;
    protected CMISDispatcherRegistry.Binding binding;
    protected Descriptor currentDescriptor;

    public CMISHttpServletRequest(WebScriptRequest req, String serviceName, BaseUrlGenerator baseUrlGenerator, CMISDispatcherRegistry.Binding binding, Descriptor currentDescriptor, TenantAdminService tenantAdminService) {
        HttpServletRequest httpReq;
        this.req = req;
        this.serviceName = serviceName;
        this.baseUrlGenerator = baseUrlGenerator;
        this.binding = binding;
        String pathInfo = req.getPathInfo();
        WebScriptRequest baseReq = this.getBaseRequest(req);
        if (!pathInfo.startsWith("/cmis") && baseReq instanceof TenantWebScriptServletRequest) {
            String user;
            String domain;
            TenantWebScriptServletRequest servletReq = (TenantWebScriptServletRequest)baseReq;
            String tenant = servletReq.getTenant();
            this.networkId = tenant.equalsIgnoreCase("-default-") ? ((domain = tenantAdminService.getUserDomain(user = AuthenticationUtil.getFullyAuthenticatedUser())) == null || domain.equals("") ? tenant : domain) : tenant;
        }
        Match match = req.getServiceMatch();
        Map templateVars = match.getTemplateVars();
        this.httpReq = httpReq = WebScriptServletRuntime.getHttpServletRequest((WebScriptRequest)req);
        this.operation = (String)templateVars.get("operation");
        this.id = (String)templateVars.get("id");
        this.addAttributes();
    }

    private WebScriptRequest getBaseRequest(WebScriptRequest req) {
        WebScriptRequest ret = req;
        while (ret instanceof WrappingWebScriptRequest) {
            WrappingWebScriptRequest wrapping = (WrappingWebScriptRequest)req;
            ret = wrapping.getNext();
        }
        return ret;
    }

    protected void addAttributes() {
        if (this.networkId != null) {
            this.httpReq.setAttribute("repositoryId", (Object)this.networkId);
        }
        this.httpReq.setAttribute("serviceName", (Object)this.serviceName);
    }

    public Object getAttribute(String arg0) {
        if (arg0.equals("org.apache.chemistry.opencmis.baseurl")) {
            return this.baseUrlGenerator.getBaseUrl(this, this.networkId, this.binding);
        }
        return this.httpReq.getAttribute(arg0);
    }

    public Enumeration getAttributeNames() {
        Enumeration e = this.httpReq.getAttributeNames();
        ArrayList attrNames = new ArrayList();
        while (e.hasMoreElements()) {
            attrNames.add(e.nextElement());
        }
        attrNames.add("org.apache.chemistry.opencmis.baseurl");
        final Iterator it = attrNames.iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
    }

    public String getCharacterEncoding() {
        return this.httpReq.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.httpReq.getContentLength();
    }

    public String getContentType() {
        return this.httpReq.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.httpReq.getInputStream();
    }

    public String getLocalAddr() {
        return this.httpReq.getLocalAddr();
    }

    public String getLocalName() {
        return this.httpReq.getLocalName();
    }

    public int getLocalPort() {
        return this.httpReq.getLocalPort();
    }

    public Locale getLocale() {
        return this.httpReq.getLocale();
    }

    public Enumeration getLocales() {
        return this.httpReq.getLocales();
    }

    public String getParameter(String arg0) {
        if (arg0.equals("repositoryId")) {
            return this.networkId;
        }
        return this.httpReq.getParameter(arg0);
    }

    public Map getParameterMap() {
        Map map = this.httpReq.getParameterMap();
        HashedMap ret = new HashedMap(map);
        if (this.networkId != null) {
            ret.put("repositoryId", new String[]{this.networkId});
        }
        return ret;
    }

    public Enumeration getParameterNames() {
        Enumeration e = this.httpReq.getParameterNames();
        ArrayList l = new ArrayList();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        if (this.networkId != null) {
            l.add("repositoryId");
        }
        final Iterator it = l.iterator();
        Enumeration ret = new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
        return ret;
    }

    public String[] getParameterValues(String arg0) {
        return this.httpReq.getParameterValues(arg0);
    }

    public String getProtocol() {
        return this.httpReq.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        return this.httpReq.getReader();
    }

    public String getRealPath(String arg0) {
        return this.httpReq.getRealPath(arg0);
    }

    public String getRemoteAddr() {
        return this.httpReq.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.httpReq.getRemoteHost();
    }

    public int getRemotePort() {
        return this.httpReq.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return this.httpReq.getRequestDispatcher(arg0);
    }

    public String getScheme() {
        return this.httpReq.getScheme();
    }

    public String getServerName() {
        return this.httpReq.getServerName();
    }

    public int getServerPort() {
        return this.httpReq.getServerPort();
    }

    public boolean isSecure() {
        return this.httpReq.isSecure();
    }

    public void removeAttribute(String arg0) {
        this.httpReq.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.httpReq.setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.httpReq.setCharacterEncoding(arg0);
    }

    public String getAuthType() {
        return this.httpReq.getAuthType();
    }

    public String getContextPath() {
        String contextPath = this.baseUrlGenerator.getContextPath(this.httpReq);
        return contextPath;
    }

    public Cookie[] getCookies() {
        return this.httpReq.getCookies();
    }

    public long getDateHeader(String arg0) {
        return this.httpReq.getDateHeader(arg0);
    }

    public String getHeader(String arg0) {
        return this.httpReq.getHeader(arg0);
    }

    public Enumeration getHeaderNames() {
        return this.httpReq.getHeaderNames();
    }

    public Enumeration getHeaders(String arg0) {
        return this.httpReq.getHeaders(arg0);
    }

    public int getIntHeader(String arg0) {
        return this.httpReq.getIntHeader(arg0);
    }

    public String getMethod() {
        return this.httpReq.getMethod();
    }

    public String getPathInfo() {
        StringBuilder sb = new StringBuilder("/");
        sb.append(this.networkId == null ? "-default-" : this.networkId);
        if (this.operation != null) {
            sb.append("/");
            sb.append(this.operation);
        }
        return sb.toString();
    }

    public String getPathTranslated() {
        return this.httpReq.getPathTranslated();
    }

    public String getQueryString() {
        StringBuilder queryString = new StringBuilder();
        String reqQueryString = this.httpReq.getQueryString();
        if (this.networkId != null && this.networkId.length() > 0) {
            if (reqQueryString != null) {
                queryString.append(reqQueryString + "&");
            }
            queryString.append("repositoryId=" + this.networkId);
            if (this.operation == null || this.operation.isEmpty()) {
                queryString.append("&cmisselector=");
                queryString.append("repositoryInfo");
            }
            return queryString.toString();
        }
        return reqQueryString;
    }

    public String getRemoteUser() {
        return this.httpReq.getRemoteUser();
    }

    public String getRequestURI() {
        String requestURI = this.baseUrlGenerator.getRequestURI(this.httpReq, this.networkId, this.operation, this.id);
        return requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.httpReq.getRequestURL();
    }

    public String getRequestedSessionId() {
        return this.httpReq.getRequestedSessionId();
    }

    public String getServletPath() {
        String servletPath = this.baseUrlGenerator.getServletPath(this.httpReq);
        return servletPath;
    }

    public HttpSession getSession() {
        return this.httpReq.getSession();
    }

    public HttpSession getSession(boolean arg0) {
        return this.httpReq.getSession(arg0);
    }

    public Principal getUserPrincipal() {
        return this.httpReq.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.httpReq.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.httpReq.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.httpReq.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.httpReq.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String arg0) {
        return this.httpReq.isUserInRole(arg0);
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this.httpReq.authenticate(response);
    }

    public void login(String username, String password) throws ServletException {
        this.httpReq.login(username, password);
    }

    public void logout() throws ServletException {
        this.httpReq.logout();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.httpReq.getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this.httpReq.getPart(name);
    }

    public ServletContext getServletContext() {
        return this.httpReq.getServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.httpReq.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.httpReq.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncStarted() {
        return this.httpReq.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.httpReq.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return this.httpReq.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.httpReq.getDispatcherType();
    }
}

