/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.links;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.links.AbstractLinksWebScript;
import org.alfresco.service.cmr.links.LinkInfo;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class LinkPut
extends AbstractLinksWebScript {
    private static final String MSG_ACCESS_DENIED = "links.err.access.denied";
    private static final String MSG_NOT_FOUND = "links.err.not.found";

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String linkName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        ResourceBundle rb = this.getResources();
        HashMap<String, Object> model = new HashMap<String, Object>();
        LinkInfo link = this.linksService.getLink(site.getShortName(), linkName);
        if (link == null) {
            String message = "No link found with that name";
            status.setCode(404);
            status.setMessage(message);
            model.put("message", rb.getString(MSG_NOT_FOUND));
            return model;
        }
        link.setTitle(this.getOrNull(json, "title"));
        link.setDescription(this.getOrNull(json, "description"));
        String url = this.getOrNull(json, "url");
        link.setURL(url);
        if (json.containsKey((Object)"internal")) {
            link.setInternal(true);
        } else {
            link.setInternal(false);
        }
        link.getTags().clear();
        List<String> tags = this.getTags(json);
        if (tags != null && tags.size() > 0) {
            link.getTags().addAll(tags);
        }
        try {
            link = this.linksService.updateLink(link);
        }
        catch (AccessDeniedException e) {
            String message = "You don't have permission to update that link";
            status.setCode(403);
            status.setMessage(message);
            model.put("message", rb.getString(MSG_ACCESS_DENIED));
            return model;
        }
        this.addActivityEntry("updated", link, site, req, json);
        model.put("message", "Node " + String.valueOf(link.getNodeRef()) + " updated");
        model.put("link", link);
        model.put("site", site);
        model.put("siteId", site.getShortName());
        return model;
    }
}

