/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.transfer;

import javax.servlet.http.HttpServletRequest;
import org.alfresco.repo.web.scripts.transfer.CommandProcessor;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.util.json.ExceptionJsonSerializer;
import org.alfresco.util.json.JsonSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public class StatusCommandProcessor
implements CommandProcessor {
    private static final String MSG_CAUGHT_UNEXPECTED_EXCEPTION = "transfer_service.receiver.caught_unexpected_exception";
    private TransferReceiver receiver;
    private JsonSerializer<Throwable, JSONObject> errorSerializer = new ExceptionJsonSerializer();
    private static final Log logger = LogFactory.getLog(StatusCommandProcessor.class);

    @Override
    public int process(WebScriptRequest req, WebScriptResponse resp) {
        WebScriptServletRequest webScriptServletRequest = null;
        Object current = req;
        do {
            if (current instanceof WebScriptServletRequest) {
                webScriptServletRequest = (WebScriptServletRequest)current;
                current = null;
                continue;
            }
            current = current instanceof WrappingWebScriptRequest ? ((WrappingWebScriptRequest)req).getNext() : null;
        } while (current != null);
        HttpServletRequest servletRequest = webScriptServletRequest.getHttpServletRequest();
        String transferId = servletRequest.getParameter("transferId");
        if (transferId == null) {
            logger.debug((Object)"transferId is missing");
            resp.setStatus(400);
            return 400;
        }
        try {
            TransferProgress progress = this.receiver.getProgressMonitor().getProgress(transferId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)progress);
            }
            JSONObject progressObject = new JSONObject();
            progressObject.put("transferId", (Object)transferId);
            progressObject.put("status", (Object)progress.getStatus().toString());
            progressObject.put("currentPosition", progress.getCurrentPosition());
            progressObject.put("endPosition", progress.getEndPosition());
            if (progress.getError() != null) {
                JSONObject errorObject = (JSONObject)this.errorSerializer.serialize((Object)progress.getError());
                progressObject.put("error", (Object)errorObject);
            }
            String response = progressObject.toString();
            resp.setContentType("application/json");
            resp.setContentEncoding("UTF-8");
            int length = response.getBytes("UTF-8").length;
            resp.addHeader("Content-Length", "" + length);
            resp.setStatus(200);
            resp.getWriter().write(response);
            return 200;
        }
        catch (TransferException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransferException(MSG_CAUGHT_UNEXPECTED_EXCEPTION, (Throwable)ex);
        }
    }

    public void setReceiver(TransferReceiver receiver) {
        this.receiver = receiver;
    }

    public void setErrorSerializer(JsonSerializer<Throwable, JSONObject> errorSerializer) {
        this.errorSerializer = errorSerializer;
    }
}

