/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVLockService;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.activities.ActivityPoster;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.sync.events.types.ContentEventImpl;
import org.alfresco.sync.events.types.Event;
import org.alfresco.sync.repo.Client;
import org.alfresco.sync.repo.events.EventPreparator;
import org.alfresco.sync.repo.events.EventPublisher;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.util.StringUtils;
import org.xml.sax.helpers.AttributesImpl;

public class WebDAVHelper {
    public static final String BEAN_NAME = "webDAVHelper";
    private static final String HTTPS_SCHEME = "https://";
    private static final String HTTP_SCHEME = "http://";
    public static final String PathSeperator = "/";
    public static final char PathSeperatorChar = '/';
    public static final String EMPTY_SITE_ID = "";
    protected static Log logger = LogFactory.getLog((String)"org.alfresco.webdav.protocol");
    private ServiceRegistry m_serviceRegistry;
    private NodeService m_nodeService;
    private FileFolderService m_fileFolderService;
    private SearchService m_searchService;
    private NamespaceService m_namespaceService;
    private DictionaryService m_dictionaryService;
    private MimetypeService m_mimetypeService;
    private WebDAVLockService m_lockService;
    private ActionService m_actionService;
    private AuthenticationService m_authService;
    private PermissionService m_permissionService;
    private TenantService m_tenantService;
    private HiddenAspect m_hiddenAspect;
    private EventPublisher eventPublisher;
    private ActivityPoster poster;
    private Pattern m_renameShufflePattern = Pattern.compile("(.*/\\..*)|(.*[a-f0-9]{8}+$)|(.*\\.tmp$)|(.*atmp[0-9]+$)|(.*\\.wbk$)|(.*\\.bak$)|(.*\\~$)|(.*backup.*\\.do[ct]{1}[x]?[m]?$)|(.*\\.sb\\-\\w{8}\\-\\w{6}$)");
    private final AttributesImpl m_nullAttribs = new AttributesImpl();
    private BehaviourFilter m_policyBehaviourFilter;
    private String m_urlPathPrefix;
    private long sizeLimit = -1L;

    public void setSizeLimitString(String limit) {
        long longLimit = -1L;
        try {
            longLimit = Long.parseLong(limit);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.sizeLimit = longLimit;
    }

    public void setRenameShufflePattern(Pattern renameShufflePattern) {
        this.m_renameShufflePattern = renameShufflePattern;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public final AuthenticationService getAuthenticationService() {
        return this.m_authService;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.m_serviceRegistry;
    }

    public final NodeService getNodeService() {
        return this.m_nodeService;
    }

    public FileFolderService getFileFolderService() {
        return this.m_fileFolderService;
    }

    public final SearchService getSearchService() {
        return this.m_searchService;
    }

    public final NamespaceService getNamespaceService() {
        return this.m_namespaceService;
    }

    public final DictionaryService getDictionaryService() {
        return this.m_dictionaryService;
    }

    public final MimetypeService getMimetypeService() {
        return this.m_mimetypeService;
    }

    public WebDAVLockService getLockService() {
        return this.m_lockService;
    }

    public final ActionService getActionService() {
        return this.m_actionService;
    }

    public final PermissionService getPermissionService() {
        return this.m_permissionService;
    }

    public final HiddenAspect getHiddenAspect() {
        return this.m_hiddenAspect;
    }

    public TenantService getTenantService() {
        return this.m_tenantService;
    }

    public final CopyService getCopyService() {
        return this.getServiceRegistry().getCopyService();
    }

    public void setTenantService(TenantService tenantService) {
        this.m_tenantService = tenantService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.m_serviceRegistry = serviceRegistry;
    }

    public void setNodeService(NodeService nodeService) {
        this.m_nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.m_fileFolderService = fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.m_searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.m_namespaceService = namespaceService;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setPoster(ActivityPoster poster) {
        this.poster = poster;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.m_dictionaryService = dictionaryService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.m_mimetypeService = mimetypeService;
    }

    public void setLockService(WebDAVLockService lockService) {
        this.m_lockService = lockService;
    }

    public void setActionService(ActionService actionService) {
        this.m_actionService = actionService;
    }

    public void setAuthenticationService(AuthenticationService authService) {
        this.m_authService = authService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.m_permissionService = permissionService;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.m_hiddenAspect = hiddenAspect;
    }

    public BehaviourFilter getPolicyBehaviourFilter() {
        return this.m_policyBehaviourFilter;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.m_policyBehaviourFilter = behaviourFilter;
    }

    public boolean isRenameShuffle(String newPath) {
        return this.m_renameShufflePattern.matcher(newPath.toLowerCase()).matches();
    }

    public final String[] splitPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path may not be null");
        }
        String[] pathStr = new String[]{EMPTY_SITE_ID, EMPTY_SITE_ID};
        int pos = path.lastIndexOf(47);
        if (pos == -1 || pos == path.length() - 1) {
            pathStr[1] = path;
        } else {
            pathStr[0] = path.substring(0, pos);
            pathStr[1] = path.substring(pos + 1);
        }
        return pathStr;
    }

    public List<String> splitAllPaths(String path) {
        if (path == null || path.length() == 0) {
            return Collections.emptyList();
        }
        StringTokenizer token = new StringTokenizer(path, PathSeperator);
        ArrayList<String> results = new ArrayList<String>(10);
        while (token.hasMoreTokens()) {
            results.add(token.nextToken());
        }
        return results;
    }

    public String getURLForPath(HttpServletRequest request, String path, boolean isCollection) {
        return this.getURLForPath(request, path, isCollection, null);
    }

    public String getURLForPath(HttpServletRequest request, String path, boolean isCollection, String userAgent) {
        String urlPathPrefix = this.getUrlPathPrefix(request);
        StringBuilder urlStr = new StringBuilder(urlPathPrefix);
        if (!path.equals(PathSeperator)) {
            StringTokenizer t = new StringTokenizer(path, PathSeperator);
            while (t.hasMoreTokens()) {
                urlStr.append(WebDAVHelper.encodeURL(t.nextToken(), userAgent));
                if (!t.hasMoreTokens()) continue;
                urlStr.append(PathSeperator);
            }
        }
        if (isCollection && urlStr.charAt(urlStr.length() - 1) != '/') {
            urlStr.append(PathSeperator);
        }
        logger.debug((Object)("getURLForPath() path:" + path + " => url:" + String.valueOf(urlStr)));
        return urlStr.toString();
    }

    public FileInfo getNodeForPath(NodeRef rootNodeRef, String path) throws FileNotFoundException {
        if (rootNodeRef == null) {
            throw new IllegalArgumentException("Root node may not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path may not be null");
        }
        FileFolderService fileFolderService = this.getFileFolderService();
        if (path.length() == 0 || path.equals(PathSeperator)) {
            return fileFolderService.getFileInfo(rootNodeRef);
        }
        List<String> splitPath = this.splitAllPaths(path);
        FileInfo fileInfo = this.m_fileFolderService.resolveNamePath(rootNodeRef, splitPath);
        String fileName = splitPath.get(splitPath.size() - 1);
        if (!fileInfo.getName().equals(fileName)) {
            throw new FileNotFoundException("Requested filename " + fileName + " does not match case of " + fileInfo.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched node for path: \n   root: " + String.valueOf(rootNodeRef) + "\n   path: " + path + "\n   result: " + String.valueOf(fileInfo)));
        }
        return fileInfo;
    }

    public boolean isRootPath(String path, String servletPath) {
        return path.length() == 0 || path.equals(PathSeperator) || EqualsHelper.nullSafeEquals((Object)path, (Object)servletPath);
    }

    public final FileInfo getParentNodeForPath(NodeRef rootNodeRef, String path) throws FileNotFoundException {
        if (rootNodeRef == null) {
            throw new IllegalArgumentException("Root node may not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path may not be null");
        }
        String[] paths = this.splitPath(path);
        return this.getNodeForPath(rootNodeRef, paths[0]);
    }

    public final String getPathFromNode(NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null || nodeRef == null) {
            throw new IllegalArgumentException("Invalid node(s) in getPathFromNode call");
        }
        if (rootNodeRef.equals((Object)nodeRef)) {
            return EMPTY_SITE_ID;
        }
        FileFolderService fileFolderService = this.getFileFolderService();
        List pathInfos = fileFolderService.getNameOnlyPath(rootNodeRef, nodeRef);
        StringBuilder sb = new StringBuilder(pathInfos.size() * 20);
        for (String fileInfo : pathInfos) {
            sb.append('/');
            sb.append(fileInfo);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Build name path for node: \n   root: " + String.valueOf(rootNodeRef) + "\n   target: " + String.valueOf(nodeRef) + "\n   path: " + String.valueOf(sb)));
        }
        return sb.toString();
    }

    public FileInfo createFile(FileInfo parentNodeInfo, String path) throws WebDAVServerException {
        return this.m_fileFolderService.create(parentNodeInfo.getNodeRef(), path, ContentModel.TYPE_CONTENT);
    }

    public List<FileInfo> getChildren(FileInfo fileInfo) throws WebDAVServerException {
        return this.m_fileFolderService.list(fileInfo.getNodeRef());
    }

    public final String makeETag(FileInfo nodeInfo) {
        StringBuilder etag = new StringBuilder();
        this.makeETagString(nodeInfo, etag);
        return etag.toString();
    }

    public final String makeQuotedETag(FileInfo nodeInfo) {
        StringBuilder etag = new StringBuilder();
        etag.append("\"");
        this.makeETagString(nodeInfo, etag);
        etag.append("\"");
        return etag.toString();
    }

    protected final void makeETagString(FileInfo nodeInfo, StringBuilder etag) {
        Object modVal = nodeInfo.getProperties().get(ContentModel.PROP_MODIFIED);
        etag.append(nodeInfo.getNodeRef().getId());
        if (modVal != null) {
            etag.append("_");
            etag.append(DefaultTypeConverter.INSTANCE.longValue(modVal));
        }
    }

    public final AttributesImpl getNullAttributes() {
        return this.m_nullAttribs;
    }

    public static final String encodeURL(String s) {
        return WebDAVHelper.encodeURL(s, null);
    }

    public static final String encodeURL(String s, String userAgent) {
        return URLEncoder.encode((String)s);
    }

    public static final String decodeURL(String s) {
        return URLDecoder.decode((String)s);
    }

    public static final String encodeHTML(String string) {
        if (string == null) {
            return EMPTY_SITE_ID;
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            Object enc = null;
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    enc = "&quot;";
                    break;
                }
                case '&': {
                    enc = "&amp;";
                    break;
                }
                case '<': {
                    enc = "&lt;";
                    break;
                }
                case '>': {
                    enc = "&gt;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append((String)enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static final String encodeUrlReservedSymbols(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return EMPTY_SITE_ID;
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String enc = null;
            char c = string.charAt(i);
            switch (c) {
                case ';': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '/': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '?': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case ':': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '@': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '&': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '=': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '+': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '\"': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '#': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '%': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '>': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '<': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public String determineSiteId(WebDAVMethod method) {
        return this.determineSiteId(method.getRootNodeRef(), method.getPath());
    }

    public String determineSiteId(NodeRef rootNodeRef, String path) {
        String siteId;
        SiteService siteService = this.getServiceRegistry().getSiteService();
        try {
            FileInfo fileInfo = this.getNodeForPath(rootNodeRef, path);
            siteId = siteService.getSiteShortName(fileInfo.getNodeRef());
            if (siteId == null) {
                throw new RuntimeException("Node is not contained by a site: " + path);
            }
        }
        catch (Exception error) {
            siteId = EMPTY_SITE_ID;
        }
        return siteId;
    }

    @Deprecated
    public String determineTenantDomain(WebDAVMethod method) {
        return this.determineTenantDomain();
    }

    public String determineTenantDomain() {
        TenantService tenantService = this.getTenantService();
        String tenantDomain = tenantService.getCurrentUserDomain();
        if (tenantDomain == null) {
            return EMPTY_SITE_ID;
        }
        return tenantDomain;
    }

    public String getDestinationPath(String contextPath, String servletPath, String destURL) {
        if (destURL != null && destURL.length() > 0) {
            int offset = -1;
            if (destURL.startsWith(HTTP_SCHEME)) {
                offset = HTTP_SCHEME.length();
            } else if (destURL.startsWith(HTTPS_SCHEME)) {
                offset = HTTPS_SCHEME.length();
            }
            if (offset != -1 && (offset = destURL.indexOf(PathSeperator, offset)) != -1) {
                String pathPrefix;
                String strPath = destURL.substring(offset);
                if (strPath.startsWith(pathPrefix = contextPath + servletPath + PathSeperator)) {
                    strPath = strPath.substring(pathPrefix.length());
                }
                return WebDAV.decodeURL(strPath);
            }
        }
        return null;
    }

    public void checkDestinationURL(HttpServletRequest request, String urlStr) throws WebDAVServerException {
        try {
            URL url = new URL(urlStr);
            boolean localPath = true;
            if (url.getPort() != -1 && url.getPort() != request.getServerPort()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination path, different server port");
                }
                localPath = false;
            } else if (!url.getHost().equalsIgnoreCase(request.getServerName()) && !url.getHost().equals(request.getLocalAddr())) {
                String targetHost = url.getHost();
                if (!IPAddress.isNumericAddress((String)targetHost)) {
                    String localHost = request.getServerName();
                    int pos = targetHost.indexOf(".");
                    if (pos != -1) {
                        targetHost = targetHost.substring(0, pos);
                    }
                    if ((pos = localHost.indexOf(".")) != -1) {
                        localHost = localHost.substring(0, pos);
                    }
                    if (!targetHost.equalsIgnoreCase(localHost)) {
                        localPath = false;
                    }
                } else {
                    try {
                        InetAddress targetAddr = InetAddress.getByName(targetHost);
                        if (NetworkInterface.getByInetAddress(targetAddr) == null) {
                            localPath = false;
                        }
                    }
                    catch (Exception ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Failed to check target IP address, " + targetHost));
                        }
                        localPath = false;
                    }
                }
                if (!localPath && logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination path, different server name/address");
                    logger.debug((Object)("  URL host=" + url.getHost() + ", ServerName=" + request.getServerName() + ", localAddr=" + request.getLocalAddr()));
                }
            } else if (!url.getPath().startsWith(this.getUrlPathPrefix(request))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination path, different serlet path");
                }
                localPath = false;
            }
            if (!localPath) {
                throw new WebDAVServerException(502);
            }
        }
        catch (MalformedURLException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Bad destination path, " + urlStr));
            }
            throw new WebDAVServerException(502);
        }
    }

    public void setUrlPathPrefix(String urlPathPrefix) {
        this.m_urlPathPrefix = urlPathPrefix;
    }

    public String getUrlPathPrefix(HttpServletRequest request) {
        StringBuilder urlStr = null;
        if (StringUtils.hasText((String)this.m_urlPathPrefix)) {
            urlStr = new StringBuilder(this.m_urlPathPrefix);
        } else {
            String servletPath;
            urlStr = new StringBuilder(request.getRequestURI());
            int rootPos = urlStr.indexOf(servletPath = request.getServletPath());
            if (rootPos != -1) {
                urlStr.setLength(rootPos + servletPath.length());
            }
        }
        if (urlStr.length() == 0 || urlStr.charAt(urlStr.length() - 1) != '/') {
            urlStr.append(PathSeperator);
        }
        return urlStr.toString();
    }

    protected void publishReadEvent(final FileInfo realNodeInfo, final String mimetype, final Long size, final String contentEncoding, String range) {
        if (!StringUtils.hasText((String)range)) {
            this.eventPublisher.publishEvent(new EventPreparator(){

                public Event prepareEvent(String user, String networkId, String transactionId) {
                    return new ContentEventImpl("content.download", user, networkId, transactionId, realNodeInfo.getNodeRef().getId(), null, realNodeInfo.getType().toString(), Client.asType((Client.ClientType)Client.ClientType.webdav), realNodeInfo.getName(), mimetype, size.longValue(), contentEncoding);
                }
            });
        }
    }

    public String getRepositoryPath(HttpServletRequest request) {
        String strPath = null;
        try {
            strPath = WebDAVHelper.decodeURL(request.getRequestURI());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String servletPath = request.getServletPath();
        int rootPos = strPath.indexOf(servletPath);
        if (rootPos != -1) {
            strPath = strPath.substring(rootPos);
        }
        if (strPath == null) {
            strPath = request.getServletPath();
        }
        if (strPath == null || strPath.length() == 0) {
            strPath = PathSeperator;
        } else if (strPath.startsWith(request.getServletPath())) {
            int len = request.getServletPath().length();
            strPath = strPath.length() > len ? strPath.substring(len) : PathSeperator;
        }
        if (strPath.length() > 1 && strPath.endsWith(PathSeperator)) {
            strPath = strPath.substring(0, strPath.length() - 1);
        }
        return strPath;
    }

    public boolean isLockedAndReadOnly(NodeRef nodeRef) {
        return this.m_serviceRegistry.getLockService().isLockedAndReadOnly(nodeRef);
    }
}

