/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.alfresco.repo.webdav.WebDAVLockService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebDAVSessionListener
implements HttpSessionListener,
ServletContextListener {
    private static Log logger = LogFactory.getLog(WebDAVSessionListener.class);
    private WebDAVLockService webDAVLockService;

    public void setWebDAVLockService(WebDAVLockService webDAVLockService) {
        this.webDAVLockService = webDAVLockService;
    }

    public void sessionCreated(HttpSessionEvent hse) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session created " + hse.getSession().getId()));
        }
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        this.webDAVLockService.setCurrentSession(hse.getSession());
        this.webDAVLockService.sessionDestroyed();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session destroyed " + hse.getSession().getId()));
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public void contextInitialized(ServletContextEvent sce) {
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sce.getServletContext());
        this.webDAVLockService = (WebDAVLockService)context.getBean("webDAVLockService");
    }
}

