/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.text.Collator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.authority.AuthorityException;
import org.alfresco.repo.security.authority.AuthorityInfo;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.rest.api.Groups;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.impl.GroupsFilter;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Group;
import org.alfresco.rest.api.model.GroupMember;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalkerOrSupported;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.AlfrescoCollator;
import org.alfresco.util.Pair;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public class GroupsImpl
implements Groups {
    private static final int MAX_ZONES = 1;
    private static final int MAX_DISPLAY_NAMES = 1;
    private static final String DISPLAY_NAME = "displayName";
    private static final String ZONE = "zone";
    private static final String AUTHORITY_NAME = "authorityName";
    private static final String ERR_MSG_MODIFY_FIXED_AUTHORITY = "Trying to modify a fixed authority";
    private static final Map<String, String> SORT_PARAMS_TO_NAMES;
    private static final Set<String> LIST_GROUPS_EQUALS_QUERY_PROPERTIES;
    private static final Set<String> LIST_GROUP_MEMBERS_QUERY_PROPERTIES;
    protected AuthorityService authorityService;
    private AuthorityDAO authorityDAO;
    protected People people;

    public AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setPeople(People people) {
        this.people = people;
    }

    @Override
    public Group create(Group group, Parameters parameters) {
        this.validateGroup(group, false);
        Set authorityZones = this.authorityService.getDefaultZones();
        String authorityDisplayName = null;
        if (group.getDisplayName() != null && !group.getDisplayName().isEmpty()) {
            authorityDisplayName = group.getDisplayName();
        }
        String authority = this.authorityService.createAuthority(AuthorityType.GROUP, group.getId(), authorityDisplayName, authorityZones);
        if (group.getParentIds() != null && !group.getParentIds().isEmpty()) {
            this.authorityService.addAuthority(group.getParentIds(), authority);
        }
        return this.getGroup(authority, parameters);
    }

    @Override
    public Group update(String groupId, Group group, Parameters parameters) {
        this.validateGroupId(groupId, false);
        this.validateGroup(group, true);
        try {
            this.authorityService.setAuthorityDisplayName(groupId, group.getDisplayName());
        }
        catch (AuthorityException ae) {
            this.handleAuthorityException(ae);
        }
        return this.getGroup(groupId, parameters);
    }

    @Override
    public Group getGroup(String groupId, Parameters parameters) throws EntityNotFoundException {
        AuthorityInfo authorityInfo = this.getAuthorityInfo(groupId);
        Set<String> rootAuthorities = this.getAllRootAuthorities(AuthorityType.GROUP);
        List<String> includeParam = parameters.getInclude();
        return this.getGroup(authorityInfo, includeParam, rootAuthorities);
    }

    @Override
    public CollectionWithPagingInfo<Group> getGroups(Parameters parameters) {
        PagingResults<AuthorityInfo> pagingResult;
        Paging paging = parameters.getPaging();
        Pair<String, Boolean> sortProp = this.getGroupsSortProp(parameters);
        GroupsFilter groupsFilters = this.getGroupsFilterFromQueryParameters(parameters.getQuery());
        AuthorityType authorityType = AuthorityType.GROUP;
        Set<String> rootAuthorities = this.getAllRootAuthorities(authorityType);
        try {
            pagingResult = this.getAuthoritiesInfo(authorityType, groupsFilters, rootAuthorities, sortProp, paging);
        }
        catch (UnknownAuthorityException e) {
            pagingResult = new PagingResults<AuthorityInfo>();
        }
        List<Group> groups = this.createGroupsResponse(pagingResult.getPage(), parameters.getInclude(), rootAuthorities);
        int totalItems = (Integer)pagingResult.getTotalResultCount().getFirst();
        return CollectionWithPagingInfo.asPaged(paging, groups, pagingResult.hasMoreItems(), totalItems);
    }

    private List<Group> createGroupsResponse(final List<AuthorityInfo> page, final List<String> includeParam, final Set<String> rootAuthorities) {
        AbstractList<Group> groups = new AbstractList<Group>(){

            @Override
            public Group get(int index) {
                AuthorityInfo authorityInfo = (AuthorityInfo)page.get(index);
                return GroupsImpl.this.getGroup(authorityInfo, includeParam, rootAuthorities);
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        return groups;
    }

    private GroupsFilter getGroupsFilterFromQueryParameters(Query queryParameters) {
        GroupsFilter.GroupsFilterBuilder groupsFilterBuilder = GroupsFilter.builder();
        if (queryParameters != null) {
            GroupsQueryWalker propertyWalker = new GroupsQueryWalker();
            QueryHelper.walk(queryParameters, propertyWalker);
            groupsFilterBuilder.withIsRoot(propertyWalker.getIsRoot()).withZoneFilter(this.getStringFilterFromList(propertyWalker.getZones(), ZONE, 1)).withDisplayNameFilter(this.getStringFilterFromList(propertyWalker.getDisplayNames(), DISPLAY_NAME, 1));
        }
        return groupsFilterBuilder.build();
    }

    private String getStringFilterFromList(List<String> listParam, String paramName, int maxItems) {
        String filter = null;
        if (listParam != null) {
            this.validateListParam(listParam, paramName, maxItems);
            filter = listParam.get(0);
        }
        return filter;
    }

    private void validateListParam(List<String> listParam, String paramName, int maxItems) {
        if (listParam.size() > maxItems) {
            throw new IllegalArgumentException("A maximum of " + maxItems + " " + paramName + "s may be specified.");
        }
        if (listParam.isEmpty()) {
            throw new IllegalArgumentException(StringUtils.capitalize((String)paramName) + "s filter list cannot be empty.");
        }
        listParam.stream().filter(String::isEmpty).findAny().ifPresent(displayName -> {
            throw new IllegalArgumentException(StringUtils.capitalize((String)paramName) + " cannot be empty (i.e. '')");
        });
    }

    @Override
    public CollectionWithPagingInfo<Group> getGroupsByPersonId(String requestedPersonId, Parameters parameters) {
        String personId = this.people.validatePerson(requestedPersonId);
        boolean isAdmin = this.authorityService.hasAdminAuthority();
        String currentUserId = AuthenticationUtil.getFullyAuthenticatedUser();
        if (!isAdmin && !currentUserId.equalsIgnoreCase(personId)) {
            throw new PermissionDeniedException();
        }
        Query q = parameters.getQuery();
        Boolean isRootParam = null;
        String zoneFilter = null;
        if (q != null) {
            GroupsQueryWalker propertyWalker = new GroupsQueryWalker();
            QueryHelper.walk(q, propertyWalker);
            isRootParam = propertyWalker.getIsRoot();
            List<String> zonesParam = propertyWalker.getZones();
            if (zonesParam != null) {
                this.validateListParam(zonesParam, ZONE, 1);
                zoneFilter = zonesParam.get(0);
            }
        }
        List<String> includeParam = parameters.getInclude();
        Paging paging = parameters.getPaging();
        Pair<String, Boolean> sortProp = this.getGroupsSortProp(parameters);
        Set userAuthorities = (Set)AuthenticationUtil.runAsSystem(() -> this.authorityService.getAuthoritiesForUser(personId));
        Set<String> rootAuthorities = this.getAllRootAuthorities(AuthorityType.GROUP);
        String finalZoneFilter = zoneFilter;
        Boolean finalIsRootParam = isRootParam;
        List groupAuthorities = userAuthorities.stream().filter(a -> a.startsWith(AuthorityType.GROUP.getPrefixString())).filter(a -> this.isRootPredicate(finalIsRootParam, rootAuthorities, (String)a)).filter(a -> this.zonePredicate((String)a, finalZoneFilter)).map(this::getAuthorityInfo).sorted(new AuthorityInfoComparator((String)sortProp.getFirst(), (Boolean)sortProp.getSecond())).collect(Collectors.toList());
        PagingResults pagingResult = Util.wrapPagingResults(paging, groupAuthorities);
        List page = pagingResult.getPage();
        int totalItems = (Integer)pagingResult.getTotalResultCount().getFirst();
        List groups = page.stream().map(authority -> this.getGroup((AuthorityInfo)authority, includeParam, rootAuthorities)).collect(Collectors.toList());
        return CollectionWithPagingInfo.asPaged(paging, groups, pagingResult.hasMoreItems(), totalItems);
    }

    private PagingResults<AuthorityInfo> getAuthoritiesInfo(AuthorityType authorityType, GroupsFilter groupsFilter, Set<String> rootAuthorities, Pair<String, Boolean> sortProp, Paging paging) {
        PagingResults pagingResult;
        Boolean isRootParam = groupsFilter.getIsRoot();
        String zoneFilter = groupsFilter.getZoneFilter();
        String displayNameFilter = groupsFilter.getDisplayNameFilter();
        if (isRootParam != null || displayNameFilter != null) {
            List groupList;
            if (isRootParam != null && isRootParam.booleanValue()) {
                List authorities = rootAuthorities.stream().map(this::getAuthorityInfo).filter(auth -> this.zonePredicate(auth.getAuthorityName(), zoneFilter)).filter(auth -> this.displayNamePredicate(auth.getAuthorityDisplayName(), displayNameFilter)).collect(Collectors.toList());
                groupList = new ArrayList(rootAuthorities.size());
                groupList.addAll(authorities);
                AuthorityInfoComparator authorityComparator = new AuthorityInfoComparator((String)sortProp.getFirst(), (Boolean)sortProp.getSecond());
                Collections.sort(groupList, authorityComparator);
            } else {
                PagingRequest pagingNoMaxItems = new PagingRequest(Integer.MAX_VALUE);
                PagingResults nonPagingResult = this.authorityService.getAuthoritiesInfo(authorityType, zoneFilter, null, (String)sortProp.getFirst(), ((Boolean)sortProp.getSecond()).booleanValue(), pagingNoMaxItems);
                groupList = nonPagingResult.getPage();
                if (groupList != null) {
                    groupList = groupList.stream().filter(auth -> this.isRootPredicate(isRootParam, rootAuthorities, auth.getAuthorityName())).filter(auth -> this.displayNamePredicate(auth.getAuthorityDisplayName(), displayNameFilter)).collect(Collectors.toList());
                }
            }
            pagingResult = Util.wrapPagingResults(paging, groupList);
        } else {
            PagingRequest pagingRequest = Util.getPagingRequest(paging);
            pagingResult = this.authorityService.getAuthoritiesInfo(authorityType, zoneFilter, null, (String)sortProp.getFirst(), ((Boolean)sortProp.getSecond()).booleanValue(), pagingRequest);
        }
        return pagingResult;
    }

    private boolean zonePredicate(String groupName, String zone) {
        Set zones = null;
        if (zone != null) {
            zones = this.authorityService.getAuthorityZones(groupName);
        }
        return this.zonePredicate(zones, zone);
    }

    private boolean isRootPredicate(Boolean isRootParam, Set<String> rootAuthorities, String authority) {
        if (isRootParam != null) {
            return isRootParam.booleanValue() == this.isRootAuthority(rootAuthorities, authority);
        }
        return true;
    }

    private boolean zonePredicate(Set<String> zones, String requiredZone) {
        if (requiredZone != null) {
            return zones != null && zones.contains(requiredZone);
        }
        return true;
    }

    private boolean displayNamePredicate(String groupDisplayName, String requiredDisplayName) {
        if (requiredDisplayName != null) {
            return groupDisplayName != null && groupDisplayName.equalsIgnoreCase(requiredDisplayName);
        }
        return true;
    }

    private Set<String> getAllRootAuthorities(AuthorityType authorityType) {
        Set authorities;
        try {
            authorities = this.authorityService.getAllRootAuthorities(authorityType);
        }
        catch (UnknownAuthorityException e) {
            authorities = Collections.emptySet();
        }
        return authorities;
    }

    private AuthorityInfo getAuthorityInfo(String id) {
        return this.getAuthorityInfo(id, false);
    }

    private AuthorityInfo getAuthorityInfo(String id, boolean defaultDisplayNameIfNull) {
        if (id == null || id.isEmpty()) {
            throw new InvalidArgumentException("id is null or empty");
        }
        if (!id.equals("GROUP_EVERYONE") && !this.authorityService.authorityExists(id)) {
            throw new EntityNotFoundException(id);
        }
        String authorityDisplayName = this.getAuthorityDisplayName(id, defaultDisplayNameIfNull);
        return new AuthorityInfo(null, authorityDisplayName, id);
    }

    private String getAuthorityDisplayName(String id, boolean defaultDisplayNameIfNull) {
        return defaultDisplayNameIfNull ? this.authorityService.getAuthorityDisplayName(id) : this.authorityDAO.getAuthorityDisplayName(id);
    }

    private Group getGroup(AuthorityInfo authorityInfo, List<String> includeParam, Set<String> rootAuthorities) {
        if (authorityInfo == null) {
            return null;
        }
        Group group = new Group();
        group.setId(authorityInfo.getAuthorityName());
        String authorityDisplayName = authorityInfo.getAuthorityDisplayName();
        if (authorityDisplayName == null || authorityDisplayName.isEmpty()) {
            authorityDisplayName = this.authorityService.getAuthorityDisplayName(authorityInfo.getAuthorityName());
        }
        group.setDisplayName(authorityDisplayName);
        group.setIsRoot(this.isRootAuthority(rootAuthorities, authorityInfo.getAuthorityName()));
        if (includeParam != null) {
            if (includeParam.contains("parentIds")) {
                String authority = authorityInfo.getAuthorityName();
                Set containingAuthorities = Collections.emptySet();
                if (!authority.equalsIgnoreCase("GROUP_EVERYONE")) {
                    containingAuthorities = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, authority, true);
                }
                group.setParentIds(containingAuthorities);
            }
            if (includeParam.contains("zones")) {
                Set authorityZones = this.authorityService.getAuthorityZones(authorityInfo.getAuthorityName());
                group.setZones(authorityZones);
            }
        }
        return group;
    }

    private boolean isRootAuthority(Set<String> rootAuthorities, String authorityName) {
        return rootAuthorities.contains(authorityName);
    }

    private Pair<String, Boolean> getGroupsSortProp(Parameters parameters) {
        Pair sortProp;
        List<SortColumn> sortCols = parameters.getSorting();
        if (sortCols != null && sortCols.size() > 0) {
            if (sortCols.size() > 1) {
                throw new InvalidArgumentException("Multiple sort fields not allowed.");
            }
            SortColumn sortCol = sortCols.get(0);
            String sortPropName = SORT_PARAMS_TO_NAMES.get(sortCol.column);
            if (sortPropName == null) {
                throw new InvalidArgumentException("Invalid sort field: " + sortCol.column);
            }
            sortProp = new Pair((Object)sortPropName, (Object)(sortCol.asc ? Boolean.TRUE : Boolean.FALSE));
        } else {
            sortProp = this.getGroupsSortPropDefault();
        }
        return sortProp;
    }

    private Pair<String, Boolean> getGroupsSortPropDefault() {
        return new Pair((Object)DISPLAY_NAME, (Object)Boolean.TRUE);
    }

    @Override
    public void delete(String groupId, Parameters parameters) {
        if (!this.isGroupAuthority(groupId)) {
            throw new InvalidArgumentException("Invalid group id: " + groupId);
        }
        boolean cascade = Boolean.valueOf(parameters.getParameter("cascade"));
        try {
            this.authorityService.deleteAuthority(groupId, cascade);
        }
        catch (AuthorityException ae) {
            this.handleAuthorityException(ae);
        }
    }

    private void handleAuthorityException(AuthorityException ae) {
        if (ae.getMsgId().equals(ERR_MSG_MODIFY_FIXED_AUTHORITY)) {
            throw new ConstraintViolatedException(ERR_MSG_MODIFY_FIXED_AUTHORITY);
        }
        throw ae;
    }

    @Override
    public CollectionWithPagingInfo<GroupMember> getGroupMembers(String groupId, Parameters parameters) {
        this.validateGroupId(groupId, false);
        if ("GROUP_EVERYONE".equals(groupId)) {
            throw new UnsupportedResourceOperationException();
        }
        Paging paging = parameters.getPaging();
        Pair<String, Boolean> sortProp = this.getGroupsSortProp(parameters);
        AuthorityType authorityType = null;
        Query q = parameters.getQuery();
        if (q != null) {
            MapBasedQueryWalkerOrSupported propertyWalker = new MapBasedQueryWalkerOrSupported(LIST_GROUP_MEMBERS_QUERY_PROPERTIES, null);
            QueryHelper.walk(q, propertyWalker);
            String memberTypeStr = propertyWalker.getProperty("memberType", 8, String.class);
            authorityType = this.getAuthorityType(memberTypeStr);
        }
        PagingResults<AuthorityInfo> pagingResult = this.getAuthoritiesInfo(authorityType, groupId, sortProp, paging);
        final List page = pagingResult.getPage();
        int totalItems = (Integer)pagingResult.getTotalResultCount().getFirst();
        AbstractList<GroupMember> groupMembers = new AbstractList<GroupMember>(){

            @Override
            public GroupMember get(int index) {
                AuthorityInfo authorityInfo = (AuthorityInfo)page.get(index);
                return GroupsImpl.this.getGroupMember(authorityInfo);
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        return CollectionWithPagingInfo.asPaged(paging, groupMembers, pagingResult.hasMoreItems(), totalItems);
    }

    @Override
    public GroupMember createGroupMember(String groupId, GroupMember groupMember) {
        this.validateGroupId(groupId, false);
        if ("GROUP_EVERYONE".equals(groupId)) {
            throw new ConstraintViolatedException(ERR_MSG_MODIFY_FIXED_AUTHORITY);
        }
        this.validateGroupMember(groupMember);
        AuthorityType authorityType = this.getAuthorityType(groupMember.getMemberType());
        if (!this.authorityService.authorityExists(groupMember.getId())) {
            throw new EntityNotFoundException(groupMember.getId());
        }
        AuthorityType existingAuthorityType = AuthorityType.getAuthorityType((String)groupMember.getId());
        if (existingAuthorityType != authorityType) {
            throw new IllegalArgumentException("Incorrect group member type, " + String.valueOf(AuthorityType.USER.equals((Object)existingAuthorityType) ? "PERSON" : existingAuthorityType) + " exists with the given id");
        }
        this.authorityService.addAuthority(groupId, groupMember.getId());
        String authority = this.authorityService.getName(authorityType, groupMember.getId());
        return this.getGroupMember(authority);
    }

    @Override
    public void deleteGroupMembership(String groupId, String groupMemberId) {
        this.validateGroupId(groupId, false);
        if ("GROUP_EVERYONE".equals(groupId)) {
            throw new ConstraintViolatedException(ERR_MSG_MODIFY_FIXED_AUTHORITY);
        }
        this.validateGroupMemberId(groupMemberId);
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)groupMemberId);
        Set parents = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, groupMemberId, true);
        if (!parents.contains(groupId)) {
            throw new NotFoundException(groupMemberId + " is not member of " + groupId);
        }
        this.authorityService.removeAuthority(groupId, groupMemberId);
    }

    private AuthorityType getAuthorityType(String memberType) {
        AuthorityType authorityType = null;
        if (memberType != null && !memberType.isEmpty()) {
            switch (memberType) {
                case "GROUP": {
                    authorityType = AuthorityType.GROUP;
                    break;
                }
                case "PERSON": {
                    authorityType = AuthorityType.USER;
                    break;
                }
                default: {
                    throw new InvalidArgumentException("MemberType is invalid (expected eg. GROUP, PERSON)");
                }
            }
        }
        return authorityType;
    }

    private PagingResults<AuthorityInfo> getAuthoritiesInfo(AuthorityType authorityType, String groupId, Pair<String, Boolean> sortProp, Paging paging) {
        Set authorities;
        try {
            authorities = this.authorityService.findAuthorities(authorityType, groupId, true, null, null);
        }
        catch (UnknownAuthorityException e) {
            authorities = Collections.emptySet();
        }
        ArrayList authorityInfoList = new ArrayList(authorities.size());
        authorityInfoList.addAll(authorities.stream().map(this::getAuthorityInfo).collect(Collectors.toList()));
        AuthorityInfoComparator authorityComparator = new AuthorityInfoComparator((String)sortProp.getFirst(), (Boolean)sortProp.getSecond());
        Collections.sort(authorityInfoList, authorityComparator);
        return Util.wrapPagingResults(paging, authorityInfoList);
    }

    private GroupMember getGroupMember(AuthorityInfo authorityInfo) {
        if (authorityInfo == null) {
            return null;
        }
        GroupMember groupMember = new GroupMember();
        groupMember.setId(authorityInfo.getAuthorityName());
        String authorityDisplayName = authorityInfo.getAuthorityDisplayName();
        if (authorityDisplayName == null || authorityDisplayName.isEmpty()) {
            authorityDisplayName = this.authorityService.getAuthorityDisplayName(authorityInfo.getAuthorityName());
        }
        groupMember.setDisplayName(authorityDisplayName);
        String memberType = null;
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)authorityInfo.getAuthorityName());
        switch (authorityType) {
            case GROUP: {
                memberType = "GROUP";
                break;
            }
            case USER: {
                memberType = "PERSON";
                break;
            }
        }
        groupMember.setMemberType(memberType);
        return groupMember;
    }

    private GroupMember getGroupMember(String authorityId) {
        AuthorityInfo authorityInfo = this.getAuthorityInfo(authorityId);
        return this.getGroupMember(authorityInfo);
    }

    private void validateGroupId(String groupId, boolean inferPrefix) {
        if (groupId == null || groupId.isEmpty()) {
            throw new InvalidArgumentException("groupId is null or empty");
        }
        if (!"GROUP_EVERYONE".equals(groupId) && !this.groupAuthorityExists(groupId, inferPrefix)) {
            throw new EntityNotFoundException(groupId);
        }
    }

    private void validateGroupMemberId(String groupMemberId) {
        if (groupMemberId == null || groupMemberId.isEmpty()) {
            throw new InvalidArgumentException("group member id is null or empty");
        }
        if (!this.personAuthorityExists(groupMemberId) && !this.groupAuthorityExists(groupMemberId, false)) {
            throw new EntityNotFoundException(groupMemberId);
        }
    }

    private void validateGroup(Group group, boolean isUpdate) {
        if (group == null) {
            throw new InvalidArgumentException("group is null");
        }
        if (!isUpdate) {
            String groupId = group.getId();
            if (groupId == null || groupId.isEmpty()) {
                throw new InvalidArgumentException("groupId is null or empty");
            }
            if (this.groupAuthorityExists(groupId)) {
                throw new ConstraintViolatedException("Group '" + group.getId() + "' already exists.");
            }
        } else {
            if (group.wasSet("id")) {
                throw new InvalidArgumentException("Group update does not support field: id");
            }
            if (group.wasSet("isRoot")) {
                throw new InvalidArgumentException("Group update does not support field: isRoot");
            }
            if (group.wasSet("parentIds")) {
                throw new InvalidArgumentException("Group update does not support field: parentIds");
            }
            if (group.wasSet("zones")) {
                throw new InvalidArgumentException("Group update does not support field: zones");
            }
        }
    }

    private void validateGroupMember(GroupMember groupMember) {
        if (groupMember == null) {
            throw new InvalidArgumentException("group member is null");
        }
        if (groupMember.getId() == null || groupMember.getId().isEmpty()) {
            throw new InvalidArgumentException("group member Id is null or empty");
        }
        if (groupMember.getMemberType() == null || groupMember.getMemberType().isEmpty()) {
            throw new InvalidArgumentException("group member type is null or empty");
        }
    }

    private boolean groupAuthorityExists(String authorityName) {
        return this.groupAuthorityExists(authorityName, true);
    }

    private boolean groupAuthorityExists(String authorityName, boolean inferPrefix) {
        return this.authorityExists(AuthorityType.GROUP, authorityName, inferPrefix);
    }

    private boolean personAuthorityExists(String authorityName) {
        return this.authorityExists(AuthorityType.USER, authorityName, false);
    }

    private boolean authorityExists(AuthorityType authorityType, String authorityName, boolean inferPrefix) {
        String name = inferPrefix ? this.authorityService.getName(authorityType, authorityName) : authorityName;
        return name != null && this.authorityService.authorityExists(name);
    }

    private boolean isGroupAuthority(String authorityName) {
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)authorityName);
        return AuthorityType.GROUP.equals((Object)authorityType) || AuthorityType.EVERYONE.equals((Object)authorityType);
    }

    static {
        HashMap<String, String> aMap = new HashMap<String, String>(2);
        aMap.put("id", AUTHORITY_NAME);
        aMap.put(DISPLAY_NAME, DISPLAY_NAME);
        SORT_PARAMS_TO_NAMES = Collections.unmodifiableMap(aMap);
        LIST_GROUPS_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("isRoot"));
        LIST_GROUP_MEMBERS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("memberType"));
    }

    private static class GroupsQueryWalker
    extends MapBasedQueryWalker {
        private List<String> zones;
        private List<String> displayNames;

        public GroupsQueryWalker() {
            super(LIST_GROUPS_EQUALS_QUERY_PROPERTIES, null);
        }

        @Override
        public void and() {
        }

        @Override
        public void in(String propertyName, boolean negated, String ... propertyValues) {
            if (propertyName.equalsIgnoreCase("zones")) {
                this.zones = Arrays.asList(propertyValues);
            }
            if (propertyName.equalsIgnoreCase(GroupsImpl.DISPLAY_NAME)) {
                this.displayNames = Arrays.asList(propertyValues);
            }
        }

        public List<String> getZones() {
            return this.zones;
        }

        public Boolean getIsRoot() {
            return this.getProperty("isRoot", 8, Boolean.class);
        }

        public List<String> getDisplayNames() {
            return this.displayNames;
        }
    }

    private static class AuthorityInfoComparator
    implements Comparator<AuthorityInfo> {
        private Map<AuthorityInfo, String> nameCache;
        private String sortBy;
        private Collator col = AlfrescoCollator.getInstance((Locale)I18NUtil.getLocale());
        private int orderMultiplier = 1;

        private AuthorityInfoComparator(String sortBy, boolean sortAsc) {
            this.sortBy = sortBy;
            this.nameCache = new HashMap<AuthorityInfo, String>();
            if (!sortAsc) {
                this.orderMultiplier = -1;
            }
        }

        @Override
        public int compare(AuthorityInfo g1, AuthorityInfo g2) {
            return this.col.compare(this.get(g1), this.get(g2)) * this.orderMultiplier;
        }

        private String get(AuthorityInfo g) {
            String v = this.nameCache.get(g);
            if (v == null) {
                if (GroupsImpl.DISPLAY_NAME.equals(this.sortBy)) {
                    v = g.getAuthorityDisplayName();
                } else if (GroupsImpl.AUTHORITY_NAME.equals(this.sortBy)) {
                    v = g.getAuthorityName();
                } else {
                    throw new InvalidArgumentException("Invalid sort field: " + this.sortBy);
                }
                if (v == null) {
                    v = g.getAuthorityName();
                }
                this.nameCache.put(g, v);
            }
            return v;
        }
    }
}

