/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.tagging.NonExistentTagException;
import org.alfresco.repo.tagging.TagExistsException;
import org.alfresco.repo.tagging.TaggingException;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.Tags;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Tag;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.util.Pair;
import org.alfresco.util.TypeConstraint;

public class TagsImpl
implements Tags {
    private static final Object PARAM_INCLUDE_COUNT = "count";
    private Nodes nodes;
    private TaggingService taggingService;
    private TypeConstraint typeConstraint;

    public void setTypeConstraint(TypeConstraint typeConstraint) {
        this.typeConstraint = typeConstraint;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    @Override
    public List<Tag> addTags(String nodeId, final List<Tag> tags) {
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        if (!this.typeConstraint.matches(nodeRef)) {
            throw new UnsupportedResourceOperationException("Cannot tag this node");
        }
        AbstractList<String> tagValues = new AbstractList<String>(){

            @Override
            public String get(int arg0) {
                String tag = ((Tag)tags.get(arg0)).getTag();
                return tag;
            }

            @Override
            public int size() {
                return tags.size();
            }
        };
        try {
            List tagNodeRefs = this.taggingService.addTags(nodeRef, (List)tagValues);
            ArrayList<Tag> ret = new ArrayList<Tag>(tags.size());
            for (Pair pair : tagNodeRefs) {
                ret.add(new Tag((NodeRef)pair.getSecond(), (String)pair.getFirst()));
            }
            return ret;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    @Override
    public void deleteTag(String nodeId, String tagId) {
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        this.getTag(tagId);
        NodeRef existingTagNodeRef = this.validateTag(tagId);
        String tagValue = this.taggingService.getTagName(existingTagNodeRef);
        this.taggingService.removeTag(nodeRef, tagValue);
    }

    @Override
    public CollectionWithPagingInfo<Tag> getTags(StoreRef storeRef, Parameters params) {
        Paging paging = params.getPaging();
        PagingResults results = this.taggingService.getTags(storeRef, Util.getPagingRequest(paging));
        this.taggingService.getPagedTags(storeRef, 0, paging.getMaxItems());
        Integer totalItems = (Integer)results.getTotalResultCount().getFirst();
        List page = results.getPage();
        ArrayList<Tag> tags = new ArrayList<Tag>(page.size());
        List tagsByCount = null;
        HashMap<String, Integer> tagsByCountMap = new HashMap<String, Integer>();
        if (params.getInclude().contains(PARAM_INCLUDE_COUNT) && (tagsByCount = this.taggingService.findTaggedNodesAndCountByTagName(storeRef)) != null) {
            for (Pair tagByCountElem : tagsByCount) {
                tagsByCountMap.put((String)tagByCountElem.getFirst(), (Integer)tagByCountElem.getSecond());
            }
        }
        for (Pair pair : page) {
            Tag selectedTag = new Tag((NodeRef)pair.getFirst(), (String)pair.getSecond());
            selectedTag.setCount((Integer)tagsByCountMap.get(selectedTag.getTag()));
            tags.add(selectedTag);
        }
        return CollectionWithPagingInfo.asPaged(paging, tags, results.hasMoreItems(), totalItems == null ? null : Integer.valueOf(totalItems));
    }

    public NodeRef validateTag(String tagId) {
        NodeRef tagNodeRef = this.nodes.validateNode(tagId);
        if (tagNodeRef == null) {
            throw new EntityNotFoundException(tagId);
        }
        return tagNodeRef;
    }

    public NodeRef validateTag(StoreRef storeRef, String tagId) {
        NodeRef tagNodeRef = this.nodes.validateNode(storeRef, tagId);
        if (tagNodeRef == null) {
            throw new EntityNotFoundException(tagId);
        }
        return tagNodeRef;
    }

    @Override
    public Tag changeTag(StoreRef storeRef, String tagId, Tag tag) {
        try {
            NodeRef existingTagNodeRef = this.validateTag(storeRef, tagId);
            String existingTagName = this.taggingService.getTagName(existingTagNodeRef);
            String newTagName = tag.getTag();
            NodeRef newTagNodeRef = this.taggingService.changeTag(storeRef, existingTagName, newTagName);
            return new Tag(newTagNodeRef, newTagName);
        }
        catch (NonExistentTagException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (TagExistsException e) {
            throw new ConstraintViolatedException(e.getMessage());
        }
        catch (TaggingException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    public Tag getTag(String tagId) {
        return this.getTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, tagId);
    }

    @Override
    public Tag getTag(StoreRef storeRef, String tagId) {
        NodeRef tagNodeRef = this.validateTag(storeRef, tagId);
        String tagValue = this.taggingService.getTagName(tagNodeRef);
        return new Tag(tagNodeRef, tagValue);
    }

    @Override
    public CollectionWithPagingInfo<Tag> getTags(String nodeId, Parameters params) {
        NodeRef nodeRef = this.validateTag(nodeId);
        PagingResults results = this.taggingService.getTags(nodeRef, Util.getPagingRequest(params.getPaging()));
        Integer totalItems = (Integer)results.getTotalResultCount().getFirst();
        List page = results.getPage();
        ArrayList<Tag> tags = new ArrayList<Tag>(page.size());
        for (Pair pair : page) {
            tags.add(new Tag((NodeRef)pair.getFirst(), (String)pair.getSecond()));
        }
        return CollectionWithPagingInfo.asPaged(params.getPaging(), tags, results.hasMoreItems(), totalItems == null ? null : Integer.valueOf(totalItems));
    }
}

