/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TooBusyException;
import org.alfresco.repo.web.scripts.BufferedRequest;
import org.alfresco.repo.web.scripts.BufferedResponse;
import org.alfresco.repo.web.scripts.RepositoryImageResolver;
import org.alfresco.repo.web.scripts.RepositoryServerModel;
import org.alfresco.repo.web.scripts.TempOutputStream;
import org.alfresco.repo.web.scripts.bean.LoginPost;
import org.alfresco.service.cmr.repository.ArchivedIOException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.webscripts.AbstractRuntimeContainer;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.ServerModel;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class RepositoryContainer
extends AbstractRuntimeContainer {
    protected static final Log logger = LogFactory.getLog(RepositoryContainer.class);
    private Repository repository;
    private RepositoryImageResolver imageResolver;
    private TransactionService transactionService;
    private RetryingTransactionHelper fallbackTransactionHelper;
    private AuthorityService authorityService;
    private DescriptorService descriptorService;
    private boolean encryptTempFiles = false;
    private String tempDirectoryName = null;
    private int memoryThreshold = 0x400000;
    private long maxContentSize = 0x100000000L;
    private Supplier<TempOutputStream> streamFactory = null;
    private String preserveHeadersPattern = null;
    private Class<?>[] notPublicExceptions = new Class[0];
    private Class<?>[] publicExceptions = new Class[0];

    public void setup() {
        this.streamFactory = TempOutputStream.factory(TempFileProvider.getTempDir((String)this.tempDirectoryName), this.memoryThreshold, this.maxContentSize, this.encryptTempFiles);
    }

    public void setEncryptTempFiles(Boolean encryptTempFiles) {
        if (encryptTempFiles != null) {
            this.encryptTempFiles = encryptTempFiles;
        }
    }

    public void setTempDirectoryName(String tempDirectoryName) {
        this.tempDirectoryName = tempDirectoryName;
    }

    public void setMemoryThreshold(Integer memoryThreshold) {
        if (memoryThreshold != null) {
            this.memoryThreshold = memoryThreshold;
        }
    }

    public void setMaxContentSize(Long maxContentSize) {
        if (maxContentSize != null) {
            this.maxContentSize = maxContentSize;
        }
    }

    public void setPreserveHeadersPattern(String preserveHeadersPattern) {
        this.preserveHeadersPattern = preserveHeadersPattern;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setRepositoryImageResolver(RepositoryImageResolver imageResolver) {
        this.imageResolver = imageResolver;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setFallbackTransactionHelper(RetryingTransactionHelper fallbackTransactionHelper) {
        this.fallbackTransactionHelper = fallbackTransactionHelper;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNotPublicExceptions(List<Class<?>> notPublicExceptions) {
        this.notPublicExceptions = new Class[0];
        if (null != notPublicExceptions && !notPublicExceptions.isEmpty()) {
            this.notPublicExceptions = notPublicExceptions.toArray(this.notPublicExceptions);
        }
    }

    public Class<?>[] getNotPublicExceptions() {
        return this.notPublicExceptions;
    }

    public void setPublicExceptions(List<Class<?>> publicExceptions) {
        this.publicExceptions = new Class[0];
        if (null != publicExceptions && !publicExceptions.isEmpty()) {
            this.publicExceptions = publicExceptions.toArray(this.publicExceptions);
        }
    }

    public Class<?>[] getPublicExceptions() {
        return this.publicExceptions;
    }

    public ServerModel getDescription() {
        return new RepositoryServerModel(this.descriptorService.getCurrentRepositoryDescriptor(), this.descriptorService.getServerDescriptor());
    }

    public Map<String, Object> getScriptParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(super.getScriptParameters());
        this.addRepoParameters(params);
        return params;
    }

    public Map<String, Object> getTemplateParameters() {
        return (Map)this.fallbackTransactionHelper.doInTransaction(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>(RepositoryContainer.super.getTemplateParameters());
            params.put("imageresolver", this.imageResolver.getImageResolver());
            this.addRepoParameters(params);
            return params;
        }, true);
    }

    private void addRepoParameters(Map<String, Object> params) {
        if (AlfrescoTransactionSupport.getTransactionId() != null && AuthenticationUtil.getFullAuthentication() != null) {
            NodeRef person;
            NodeRef companyHome;
            NodeRef rootHome = this.repository.getRootHome();
            if (rootHome != null) {
                params.put("roothome", rootHome);
            }
            if ((companyHome = this.repository.getCompanyHome()) != null) {
                params.put("companyhome", companyHome);
            }
            if ((person = this.repository.getFullyAuthenticatedPerson()) != null) {
                params.put("person", person);
                NodeRef userHome = this.repository.getUserHome(person);
                if (userHome != null) {
                    params.put("userhome", userHome);
                }
            }
        }
    }

    public void executeScript(WebScriptRequest scriptReq, WebScriptResponse scriptRes, Authenticator auth) throws IOException {
        try {
            this.executeScriptInternal(scriptReq, scriptRes, auth);
        }
        catch (RuntimeException e) {
            Throwable hideCause = ExceptionStackUtil.getCause((Throwable)e, (Class[])this.notPublicExceptions);
            Throwable displayCause = ExceptionStackUtil.getCause((Throwable)e, (Class[])this.publicExceptions);
            if (displayCause == null && hideCause != null) {
                AlfrescoRuntimeException alf = e instanceof AlfrescoRuntimeException ? (AlfrescoRuntimeException)((Object)e) : new AlfrescoRuntimeException("WebScript execution failed", (Throwable)e);
                String num = alf.getNumericalId();
                logger.error((Object)("Server error (" + num + ")"), (Throwable)e);
                throw new RuntimeException("Server error (" + num + ").  Details can be found in the server logs.");
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeScriptInternal(WebScriptRequest scriptReq, WebScriptResponse scriptRes, Authenticator auth) throws IOException {
        String currentUser;
        WebScript script = scriptReq.getServiceMatch().getWebScript();
        Description desc = script.getDescription();
        boolean debug = logger.isDebugEnabled();
        Description.RequiredAuthentication containerRequiredAuthentication = this.getRequiredAuthentication();
        Description.RequiredAuthentication required = desc.getRequiredAuthentication().compareTo((Enum)containerRequiredAuthentication) < 0 && !auth.emptyCredentials() ? containerRequiredAuthentication : desc.getRequiredAuthentication();
        boolean isGuest = scriptReq.isGuest();
        if (required == Description.RequiredAuthentication.none) {
            this.transactionedExecuteAs(script, scriptReq, scriptRes);
            return;
        }
        if (required != Description.RequiredAuthentication.guest && isGuest) {
            throw new WebScriptException(401, "Web Script " + desc.getId() + " requires user authentication; however, a guest has attempted access.");
        }
        try {
            boolean requiresNew;
            AuthenticationUtil.pushAuthentication();
            if (debug) {
                currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                logger.debug((Object)("Current authentication: " + (String)(currentUser == null ? "unauthenticated" : "authenticated as " + currentUser)));
                logger.debug((Object)("Authentication required: " + String.valueOf(required)));
                logger.debug((Object)("Guest login requested: " + isGuest));
            }
            RetryingTransactionHelper.RetryingTransactionCallback authWork = () -> {
                if (auth != null && !auth.authenticate(required, isGuest)) {
                    return false;
                }
                this.checkScriptAccess(required, desc.getId());
                if (debug) {
                    String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                    logger.debug((Object)("Authentication: " + (String)(currentUser == null ? "unauthenticated" : "authenticated as " + currentUser)));
                }
                return true;
            };
            boolean readOnly = this.transactionService.isReadOnly();
            boolean bl = requiresNew = !readOnly && AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY;
            if (!((Boolean)this.transactionService.getRetryingTransactionHelper().doInTransaction(authWork, readOnly, requiresNew)).booleanValue()) {
                throw new WebScriptException(401, "Authentication failed for Web Script " + desc.getId());
            }
            this.transactionedExecuteAs(script, scriptReq, scriptRes, required);
        }
        catch (Throwable throwable) {
            AuthenticationUtil.popAuthentication();
            if (debug) {
                String currentUser2 = AuthenticationUtil.getFullyAuthenticatedUser();
                logger.debug((Object)("Authentication reset: " + (String)(currentUser2 == null ? "unauthenticated" : "authenticated as " + currentUser2)));
            }
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        if (debug) {
            currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
            logger.debug((Object)("Authentication reset: " + (String)(currentUser == null ? "unauthenticated" : "authenticated as " + currentUser)));
        }
    }

    private boolean isSystemUser() {
        return Objects.equals(AuthenticationUtil.getFullyAuthenticatedUser(), AuthenticationUtil.getSystemUserName());
    }

    private boolean isSysAdminUser() {
        return this.authorityService.hasSysAdminAuthority();
    }

    private boolean isAdmin() {
        return this.authorityService.hasAdminAuthority();
    }

    public final boolean isAdminOrSystemUser() {
        return this.isAdmin() || this.isSystemUser();
    }

    private void checkGuestAccess(Description.RequiredAuthentication required, String scriptDescriptorId) {
        if (required == Description.RequiredAuthentication.user || required == Description.RequiredAuthentication.admin || required == Description.RequiredAuthentication.sysadmin) {
            String authenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
            String runAsUser = AuthenticationUtil.getRunAsUser();
            if (authenticatedUser == null || authenticatedUser.equals(runAsUser) && this.authorityService.hasGuestAuthority() || !authenticatedUser.equals(runAsUser) && this.authorityService.isGuestAuthority(authenticatedUser)) {
                throw new WebScriptException(401, "Web Script " + scriptDescriptorId + " requires user authentication; however, a guest has attempted access.");
            }
        }
    }

    private void checkScriptAccess(Description.RequiredAuthentication required, String scriptDescriptorId) {
        this.checkGuestAccess(required, scriptDescriptorId);
        if (required == Description.RequiredAuthentication.sysadmin && !this.isSysAdminUser() && !this.isAdminOrSystemUser()) {
            throw new WebScriptException(401, "Web Script " + scriptDescriptorId + " requires system-admin authentication; however, a non-system-admin has attempted access.");
        }
        if (required == Description.RequiredAuthentication.admin && !this.isAdminOrSystemUser()) {
            throw new WebScriptException(401, "Web Script " + scriptDescriptorId + " requires admin authentication; however, a non-admin has attempted access.");
        }
    }

    protected void transactionedExecute(WebScript script, WebScriptRequest scriptReq, WebScriptResponse scriptRes) throws IOException {
        Description description = script.getDescription();
        try {
            if (description.getRequiredTransaction() == Description.RequiredTransaction.none) {
                script.execute(scriptReq, scriptRes);
                return;
            }
        }
        catch (ArchivedIOException e) {
            this.handleArchivedIOException(e);
        }
        catch (IOException e) {
            RepositoryContainer.handleIOException(e);
        }
        Description.RequiredTransactionParameters trxParams = description.getRequiredTransactionParameters();
        try (BufferedRequest bufferedReq = RepositoryContainer.newBufferedRequest(trxParams, scriptReq, this.streamFactory);
             BufferedResponse bufferedRes = RepositoryContainer.newBufferedResponse(trxParams, scriptRes, this.streamFactory);){
            boolean requiresNew;
            boolean readonly = description.getRequiredTransactionParameters().getCapability() == Description.TransactionCapability.readonly;
            boolean bl = requiresNew = description.getRequiredTransaction() == Description.RequiredTransaction.requiresnew;
            if (logger.isDebugEnabled() && !readonly && "GET".equalsIgnoreCase(description.getMethod())) {
                logger.debug((Object)("Webscript with URL '" + scriptReq.getURL() + "' is a GET request but it's descriptor has declared a readwrite transaction is required"));
            }
            try {
                RetryingTransactionHelper transactionHelper = this.transactionService.getRetryingTransactionHelper();
                if (script instanceof LoginPost) {
                    transactionHelper.setForceWritable(true);
                }
                transactionHelper.doInTransaction(() -> {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Begin retry transaction block: " + String.valueOf(description.getRequiredTransaction()) + "," + String.valueOf(description.getRequiredTransactionParameters().getCapability())));
                        }
                        if (bufferedReq == null || bufferedRes == null) {
                            script.execute(scriptReq, scriptRes);
                        } else {
                            bufferedReq.reset();
                            bufferedRes.reset(this.preserveHeadersPattern);
                            script.execute((WebScriptRequest)bufferedReq, (WebScriptResponse)bufferedRes);
                        }
                    }
                    catch (Exception e) {
                        block16: {
                            UserTransaction userTrx;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Transaction exception: " + String.valueOf(description.getRequiredTransaction()) + ": " + e.getMessage()));
                                userTrx = RetryingTransactionHelper.getActiveUserTransaction();
                                if (userTrx != null) {
                                    logger.debug((Object)("Transaction status: " + userTrx.getStatus()));
                                }
                            }
                            if ((userTrx = RetryingTransactionHelper.getActiveUserTransaction()) != null && userTrx.getStatus() != 1) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Marking web script transaction for rollback");
                                }
                                try {
                                    userTrx.setRollbackOnly();
                                }
                                catch (Throwable re) {
                                    if (!logger.isDebugEnabled()) break block16;
                                    logger.debug((Object)("Caught and ignoring exception during marking for rollback: " + re.getMessage()));
                                }
                            }
                        }
                        throw e;
                    }
                    finally {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("End retry transaction block: " + String.valueOf(description.getRequiredTransaction()) + "," + String.valueOf(description.getRequiredTransactionParameters().getCapability())));
                        }
                    }
                    return null;
                }, readonly, requiresNew);
            }
            catch (TooBusyException e) {
                throw new WebScriptException(503, e.getMessage(), (Throwable)e);
            }
            catch (ArchivedIOException e) {
                this.handleArchivedIOException(e);
            }
            if (bufferedRes != null) {
                bufferedRes.writeResponse();
            }
        }
    }

    private void handleArchivedIOException(ArchivedIOException e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ArchivedIOException error ", (Throwable)e);
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("ArchivedIOException error. Message: " + e.getMessage()));
        }
        throw new WebScriptException(412, "Content is archived and not accessible.");
    }

    private static void handleIOException(IOException ioe) throws IOException {
        Throwable socketException = ExceptionStackUtil.getCause((Throwable)ioe, (Class[])new Class[]{SocketException.class});
        Class<?> clientAbortException = null;
        try {
            clientAbortException = Class.forName("org.apache.catalina.connector.ClientAbortException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (socketException != null && socketException.getMessage().contains("Broken pipe") || clientAbortException != null && ExceptionStackUtil.getCause((Throwable)ioe, (Class[])new Class[]{clientAbortException}) != null) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)"Client has cut off communication", (Throwable)ioe);
            } else {
                logger.info((Object)"Client has cut off communication");
            }
        } else {
            throw ioe;
        }
    }

    private void transactionedExecuteAs(WebScript script, WebScriptRequest scriptReq, WebScriptResponse scriptRes) throws IOException {
        String runAs = script.getDescription().getRunAs();
        if (runAs == null) {
            this.transactionedExecute(script, scriptReq, scriptRes);
        } else {
            AuthenticationUtil.runAs(() -> {
                this.transactionedExecute(script, scriptReq, scriptRes);
                return null;
            }, (String)runAs);
        }
    }

    private void transactionedExecuteAs(WebScript script, WebScriptRequest scriptReq, WebScriptResponse scriptRes, Description.RequiredAuthentication requiredAuthentication) throws IOException {
        if (requiredAuthentication == Description.RequiredAuthentication.sysadmin && this.isSysAdminUser() && !this.isAdmin()) {
            AuthenticationUtil.runAs(() -> {
                this.transactionedExecute(script, scriptReq, scriptRes);
                return null;
            }, (String)"System");
        } else {
            this.transactionedExecuteAs(script, scriptReq, scriptRes);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()).equals(this.applicationContext)) {
            AuthenticationUtil.runAs(() -> {
                this.reset();
                return null;
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    public Description.RequiredAuthentication getRequiredAuthentication() {
        if (AuthenticationUtil.isMtEnabled()) {
            return Description.RequiredAuthentication.guest;
        }
        return Description.RequiredAuthentication.none;
    }

    public boolean authenticate(Authenticator auth, Description.RequiredAuthentication required) {
        if (auth != null) {
            AuthenticationUtil.clearCurrentSecurityContext();
            return auth.authenticate(required, false);
        }
        return false;
    }

    public void reset() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.internalReset();
            return null;
        }, true, false);
    }

    private void internalReset() {
        super.reset();
    }

    private static BufferedRequest newBufferedRequest(Description.RequiredTransactionParameters trxParams, WebScriptRequest scriptReq, Supplier<TempOutputStream> streamFactory) {
        if (trxParams.getCapability() != Description.TransactionCapability.readwrite) {
            return null;
        }
        if (trxParams.getBufferSize() <= 0) {
            return null;
        }
        return new BufferedRequest(scriptReq, streamFactory);
    }

    private static BufferedResponse newBufferedResponse(Description.RequiredTransactionParameters trxParams, WebScriptResponse scriptRes, Supplier<TempOutputStream> streamFactory) {
        if (trxParams.getCapability() != Description.TransactionCapability.readwrite) {
            return null;
        }
        if (trxParams.getBufferSize() <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Transactional Response bypassed for ReadWrite - buffersize=0");
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating Transactional Response for ReadWrite transaction; buffersize=" + trxParams.getBufferSize()));
        }
        return new BufferedResponse(scriptRes, trxParams.getBufferSize(), streamFactory);
    }
}

