/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.List;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.nodes.AbstractNodeRelation;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;

@RelationshipResource(name="sources", entityResource=NodesEntityResource.class, title="Node Sources")
public class NodeSourcesRelation
extends AbstractNodeRelation
implements RelationshipResourceAction.Read<Node> {
    @Override
    @WebApiDescription(title="Return a paged list of sources nodes based on (peer) assocs")
    public CollectionWithPagingInfo<Node> readAll(String targetNodeId, Parameters parameters) {
        NodeRef targetNodeRef = this.nodes.validateOrLookupNode(targetNodeId, null);
        QNamePattern assocTypeQNameParam = this.getAssocTypeFromWhereElseAll(parameters);
        List assocRefs = this.nodeService.getSourceAssocs(targetNodeRef, assocTypeQNameParam);
        return this.listNodePeerAssocs(assocRefs, parameters, false);
    }
}

