/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.resource.content.BasicContentInfo;
import org.alfresco.rest.framework.resource.content.ContentInfoImpl;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryImpl;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class Params
implements Parameters {
    private final boolean isCollectionResource;
    private final String entityId;
    private final String relationshipId;
    private final String relationship2Id;
    private final Object passedIn;
    private final InputStream stream;
    private final RecognizedParams recognizedParams;
    private final String addressedProperty;
    private final BasicContentInfo contentInfo;
    private final WebScriptRequest request;
    private static final RecognizedParams NULL_PARAMS = new RecognizedParams(null, null, null, null, null, null, null, null, false);
    private static final BasicContentInfo DEFAULT_CONTENT_INFO = new ContentInfoImpl("application/octet-stream", "UTF-8", -1L, null);

    protected Params(Boolean isCollectionResource, String entityId, String relationshipId, String relationship2Id, Object passedIn, InputStream stream, String addressedProperty, RecognizedParams recognizedParams, BasicContentInfo contentInfo, WebScriptRequest request) {
        this.isCollectionResource = isCollectionResource != null ? isCollectionResource : entityId == null;
        this.entityId = entityId;
        this.relationshipId = relationshipId;
        this.relationship2Id = relationship2Id;
        this.passedIn = passedIn;
        this.stream = stream;
        this.recognizedParams = recognizedParams;
        this.addressedProperty = addressedProperty;
        this.request = request;
        this.contentInfo = contentInfo == null ? DEFAULT_CONTENT_INFO : contentInfo;
    }

    public static Params valueOf(BeanPropertiesFilter paramFilter, String entityId, WebScriptRequest request) {
        return new Params(null, entityId, null, null, null, null, null, new RecognizedParams(null, null, paramFilter, null, null, null, null, null, false), null, request);
    }

    public static Params valueOf(String entityId, String relationshipId, WebScriptRequest request) {
        return new Params(null, entityId, relationshipId, null, null, null, null, NULL_PARAMS, null, request);
    }

    public static Params valueOf(RecognizedParams recognizedParams, String entityId, String relationshipId, WebScriptRequest request) {
        return new Params(null, entityId, relationshipId, null, null, null, null, recognizedParams, null, request);
    }

    public static Params valueOf(String entityId, RecognizedParams recognizedParams, Object passedIn, WebScriptRequest request) {
        return new Params(null, entityId, null, null, passedIn, null, null, recognizedParams, null, request);
    }

    public static Params valueOf(String entityId, String relationshipId, RecognizedParams recognizedParams, Object passedIn, WebScriptRequest request) {
        return new Params(null, entityId, relationshipId, null, passedIn, null, null, recognizedParams, null, request);
    }

    public static Params valueOf(String entityId, String relationshipId, Object passedIn, InputStream stream, String addressedProperty, RecognizedParams recognizedParams, BasicContentInfo contentInfo, WebScriptRequest request) {
        return new Params(null, entityId, relationshipId, null, passedIn, stream, addressedProperty, recognizedParams, contentInfo, request);
    }

    public static Params valueOf(boolean isCollectionResource, String entityId, String relationshipId, String relationship2Id, Object passedIn, InputStream stream, String addressedProperty, RecognizedParams recognizedParams, BasicContentInfo contentInfo, WebScriptRequest request) {
        return new Params(isCollectionResource, entityId, relationshipId, relationship2Id, passedIn, stream, addressedProperty, recognizedParams, contentInfo, request);
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    public Object getPassedIn() {
        return this.passedIn;
    }

    @Override
    public String getRelationshipId() {
        return this.relationshipId;
    }

    @Override
    public String getRelationship2Id() {
        return this.relationship2Id;
    }

    @Override
    public boolean isCollectionResource() {
        return this.isCollectionResource;
    }

    @Override
    public Query getQuery() {
        return this.recognizedParams.query;
    }

    @Override
    public Paging getPaging() {
        return this.recognizedParams.paging;
    }

    @Override
    public BeanPropertiesFilter getFilter() {
        return this.recognizedParams.filter;
    }

    @Override
    public boolean includeSource() {
        return this.recognizedParams.includeSource;
    }

    public Map<String, BeanPropertiesFilter> getRelationsFilter() {
        return this.recognizedParams.relationshipFilter;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Params [entityId=");
        builder.append(this.entityId);
        builder.append(", relationshipId=");
        builder.append(this.relationshipId);
        builder.append(", relationship2Id=");
        builder.append(this.relationship2Id);
        builder.append(", passedIn=");
        builder.append(this.passedIn);
        builder.append(", paging=");
        builder.append(this.recognizedParams.paging);
        builder.append(", query=");
        builder.append(this.recognizedParams.query);
        builder.append(", sorting=");
        builder.append(this.recognizedParams.sorting);
        builder.append(", include=");
        builder.append(this.recognizedParams.include);
        builder.append(", select=");
        builder.append(this.recognizedParams.select);
        builder.append(", filter=");
        builder.append(this.recognizedParams.filter);
        builder.append(", relationshipFilter=");
        builder.append(this.recognizedParams.relationshipFilter);
        builder.append(", includeSource=");
        builder.append(this.recognizedParams.includeSource);
        builder.append(", addressedProperty=");
        builder.append(this.addressedProperty);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getParameter(String parameterName) {
        String[] vals;
        if (this.recognizedParams.requestParameters != null && !this.recognizedParams.requestParameters.isEmpty() && (vals = this.recognizedParams.requestParameters.get(parameterName)) != null && vals.length > 0) {
            return vals[0];
        }
        return null;
    }

    @Override
    public T getParameter(String parameterName, Class<T> clazz) throws InvalidArgumentException {
        String param = this.getParameter(parameterName);
        if (param == null) {
            return null;
        }
        Object obj = ConvertUtils.convert((String)param, clazz);
        if (obj != null && obj.getClass().equals(clazz)) {
            return (T)obj;
        }
        throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new Object[]{parameterName});
    }

    @Override
    public boolean hasBinaryProperty(String propertyName) {
        return this.addressedProperty != null && this.addressedProperty.equals(propertyName);
    }

    @Override
    public List<SortColumn> getSorting() {
        return this.recognizedParams.sorting;
    }

    @Override
    public String getBinaryProperty() {
        return this.addressedProperty;
    }

    @Override
    public List<String> getSelectedProperties() {
        return this.recognizedParams.select;
    }

    @Override
    public List<String> getInclude() {
        return this.recognizedParams.include;
    }

    @Override
    public BasicContentInfo getContentInfo() {
        return this.contentInfo;
    }

    @Override
    public WebScriptRequest getRequest() {
        return this.request;
    }

    public static class RecognizedParams {
        final Paging paging;
        private final BeanPropertiesFilter filter;
        private final Map<String, BeanPropertiesFilter> relationshipFilter;
        private final Map<String, String[]> requestParameters;
        private final Query query;
        private final List<String> include;
        @Deprecated
        private final List<String> select;
        private final List<SortColumn> sorting;
        private final boolean includeSource;

        public RecognizedParams(Map<String, String[]> requestParameters, Paging paging, BeanPropertiesFilter filter, Map<String, BeanPropertiesFilter> relationshipFilter, List<String> include, List<String> select, Query query, List<SortColumn> sorting, boolean includeSource) {
            this.requestParameters = requestParameters;
            this.paging = paging == null ? Paging.DEFAULT : paging;
            this.filter = filter == null ? BeanPropertiesFilter.ALLOW_ALL : filter;
            this.query = query == null ? QueryImpl.EMPTY : query;
            this.relationshipFilter = relationshipFilter == null ? Collections.emptyMap() : relationshipFilter;
            this.include = include == null ? Collections.emptyList() : include;
            this.select = select == null ? Collections.emptyList() : select;
            this.sorting = sorting == null ? Collections.emptyList() : sorting;
            this.includeSource = includeSource;
        }
    }
}

