/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.webdav.LockMethod;
import org.alfresco.repo.webdav.PutMethod;
import org.alfresco.repo.webdav.UnlockMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.UnableToAquireLockException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Category(value={LuceneTests.class})
public class PutMethodTest {
    private static ApplicationContext ctx;
    private static final String USER1_NAME;
    private static final String USER2_NAME;
    private static final String TEST_DATA_FILE_NAME = "filewithdata.txt";
    private static final String DAV_LOCK_INFO_ADMIN = "davLockInfoAdmin.xml";
    private static final String DAV_LOCK_INFO_USER2 = "davLockInfoUser2.xml";
    private byte[] testDataFile;
    private byte[] davLockInfoAdminFile;
    private byte[] davLockInfoUser2File;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private WebDAVMethod method;
    private UserTransaction txn = null;
    private SearchService searchService;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private WebDAVHelper webDAVHelper;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private LockService lockService;
    private ContentService contentService;
    private CheckOutCheckInService checkOutCheckInService;
    private PermissionService permissionService;
    private ActionService actionService;
    private Repository repositoryHelper;
    private NodeRef companyHomeNodeRef;
    private NodeRef versionableDoc;
    private String versionableDocName;
    private StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
    private NamespaceService namespaceService;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/remote-api-context.xml"});
    }

    @Before
    public void setUp() throws Exception {
        this.searchService = (SearchService)ctx.getBean("SearchService", SearchService.class);
        this.fileFolderService = (FileFolderService)ctx.getBean("FileFolderService", FileFolderService.class);
        this.nodeService = (NodeService)ctx.getBean("NodeService", NodeService.class);
        this.transactionService = (TransactionService)ctx.getBean("transactionService", TransactionService.class);
        this.webDAVHelper = (WebDAVHelper)ctx.getBean("webDAVHelper", WebDAVHelper.class);
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService", MutableAuthenticationService.class);
        this.personService = (PersonService)ctx.getBean("PersonService", PersonService.class);
        this.lockService = (LockService)ctx.getBean("LockService", LockService.class);
        this.contentService = (ContentService)ctx.getBean("contentService", ContentService.class);
        this.checkOutCheckInService = (CheckOutCheckInService)ctx.getBean("CheckOutCheckInService", CheckOutCheckInService.class);
        this.permissionService = (PermissionService)ctx.getBean("PermissionService", PermissionService.class);
        this.namespaceService = (NamespaceService)ctx.getBean("namespaceService", NamespaceService.class);
        this.actionService = (ActionService)ctx.getBean("ActionService", ActionService.class);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.repositoryHelper = (Repository)ctx.getBean("repositoryHelper");
        this.companyHomeNodeRef = this.repositoryHelper.getCompanyHome();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.createUser(USER1_NAME);
        this.createUser(USER2_NAME);
        InputStream testDataIS = this.getClass().getClassLoader().getResourceAsStream(TEST_DATA_FILE_NAME);
        InputStream davLockInfoAdminIS = this.getClass().getClassLoader().getResourceAsStream(DAV_LOCK_INFO_ADMIN);
        InputStream davLockInfoUser2IS = this.getClass().getClassLoader().getResourceAsStream(DAV_LOCK_INFO_USER2);
        this.testDataFile = IOUtils.toByteArray((InputStream)testDataIS);
        this.davLockInfoAdminFile = IOUtils.toByteArray((InputStream)davLockInfoAdminIS);
        this.davLockInfoUser2File = IOUtils.toByteArray((InputStream)davLockInfoUser2IS);
        testDataIS.close();
        davLockInfoAdminIS.close();
        davLockInfoUser2IS.close();
        HashMap<QName, String> properties = new HashMap<QName, String>();
        this.versionableDocName = "doc-" + GUID.generate();
        properties.put(ContentModel.PROP_NAME, this.versionableDocName);
        this.versionableDoc = this.nodeService.createNode(this.companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)this.versionableDocName), ContentModel.TYPE_CONTENT, properties).getChildRef();
        this.contentService.getWriter(this.versionableDoc, ContentModel.PROP_CONTENT, true).putContent("WebDAVTestContent");
        this.nodeService.addAspect(this.versionableDoc, ContentModel.ASPECT_VERSIONABLE, null);
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap();
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.method = null;
        this.request = null;
        this.response = null;
        this.testDataFile = null;
        this.davLockInfoAdminFile = null;
        if (this.txn.getStatus() == 1) {
            this.txn.rollback();
        } else {
            this.txn.commit();
        }
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.deleteUser(USER1_NAME);
        this.deleteUser(USER2_NAME);
        this.nodeService.deleteNode(this.versionableDoc);
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        HashMap<QName, CallSite> properties = new HashMap<QName, CallSite>();
        String nodeName = "leak-session-doc-" + GUID.generate();
        properties.put(ContentModel.PROP_NAME, (CallSite)((Object)nodeName));
        NodeRef nodeRef = this.nodeService.createNode(this.companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)nodeName), ContentModel.TYPE_CONTENT, properties).getChildRef();
        this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true).putContent("WebDAVTestContent");
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.nodeService.deleteNode(nodeRef);
        this.txn.commit();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void deleteUser(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
        if (this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.deleteAuthentication(userName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testPutContentToNonExistingFile() throws Exception {
        String fileName = "file-" + GUID.generate();
        NodeRef fileNoderef = null;
        try {
            this.executeMethod("PUT", fileName, this.testDataFile, null);
            List refs = this.searchService.selectNodes(this.nodeService.getRootNode(this.storeRef), "/app:company_home/cm:" + fileName, null, (NamespacePrefixResolver)this.namespaceService, false);
            fileNoderef = (NodeRef)refs.get(0);
            Assert.assertTrue((String)"File does not exist.", (boolean)this.nodeService.exists(fileNoderef));
            Assert.assertEquals((String)"Filename is not correct", (Object)fileName, (Object)this.nodeService.getProperty(fileNoderef, ContentModel.PROP_NAME));
            Assert.assertTrue((String)("Expected return status is 201, but returned is " + this.response.getStatus()), (201 == this.response.getStatus() ? 1 : 0) != 0);
            InputStream updatedFileIS = this.fileFolderService.getReader(fileNoderef).getContentInputStream();
            byte[] updatedFile = IOUtils.toByteArray((InputStream)updatedFileIS);
            updatedFileIS.close();
            Assert.assertTrue((String)"The content has to be equal", (boolean)ArrayUtils.isEquals((Object)this.testDataFile, (Object)updatedFile));
            if (fileNoderef == null) return;
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
            return;
        }
        finally {
            if (fileNoderef != null) {
                this.nodeService.deleteNode(fileNoderef);
            }
        }
        this.nodeService.deleteNode(fileNoderef);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutContentToAnExistingFile() throws Exception {
        FileInfo testFileInfo = this.fileFolderService.create(this.companyHomeNodeRef, "file-" + GUID.generate(), ContentModel.TYPE_CONTENT);
        try {
            this.executeMethod("PUT", testFileInfo.getName(), this.testDataFile, null);
            Assert.assertTrue((String)"File does not exist.", (boolean)this.nodeService.exists(testFileInfo.getNodeRef()));
            Assert.assertEquals((String)"Filename is not correct.", (Object)testFileInfo.getName(), (Object)this.nodeService.getProperty(testFileInfo.getNodeRef(), ContentModel.PROP_NAME));
            Assert.assertTrue((String)("Expected return status is 204, but returned is " + this.response.getStatus()), (204 == this.response.getStatus() ? 1 : 0) != 0);
            InputStream updatedFileIS = this.fileFolderService.getReader(testFileInfo.getNodeRef()).getContentInputStream();
            byte[] updatedFile = IOUtils.toByteArray((InputStream)updatedFileIS);
            updatedFileIS.close();
            Assert.assertTrue((String)"The content has to be equal", (boolean)ArrayUtils.isEquals((Object)this.testDataFile, (Object)updatedFile));
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        finally {
            this.nodeService.deleteNode(testFileInfo.getNodeRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutContentBadPath() throws Exception {
        String fileName = "file-" + GUID.generate();
        NodeRef fileNoderef = null;
        try {
            this.executeMethod("PUT", "non/existent/path" + fileName, this.testDataFile, null);
            Assert.fail((String)"The PUT execution should fail with a 400 error");
        }
        catch (WebDAVServerException wse) {
            Assert.assertTrue((wse.getHttpStatusCode() == 409 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        finally {
            if (fileNoderef != null) {
                this.nodeService.deleteNode(fileNoderef);
            }
        }
    }

    @Test
    public void testPutContentToFolder() throws Exception {
        FileInfo testFileInfo = this.fileFolderService.create(this.companyHomeNodeRef, "folder-" + GUID.generate(), ContentModel.TYPE_FOLDER);
        try {
            this.executeMethod("PUT", testFileInfo.getName(), this.testDataFile, null);
            Assert.fail((String)"The PUT execution should fail with a 400 error");
        }
        catch (WebDAVServerException wse) {
            Assert.assertTrue((wse.getHttpStatusCode() == 400 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        finally {
            this.nodeService.deleteNode(testFileInfo.getNodeRef());
        }
    }

    @Test
    public void testPutContentToLockedFIle() throws Exception {
        FileInfo testFileInfo = this.fileFolderService.create(this.companyHomeNodeRef, "file-" + GUID.generate(), ContentModel.TYPE_CONTENT);
        this.lockService.lock(testFileInfo.getNodeRef(), LockType.WRITE_LOCK);
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)USER1_NAME);
            this.executeMethod("PUT", testFileInfo.getName(), this.testDataFile, null);
            Assert.fail((String)"The PUT execution should fail with a 423 error");
        }
        catch (WebDAVServerException wse) {
            Assert.assertTrue((wse.getHttpStatusCode() == 423 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        finally {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            this.nodeService.deleteNode(testFileInfo.getNodeRef());
        }
    }

    @Test
    public void testPutContentToWorkingCopy() throws Exception {
        FileInfo folder = this.fileFolderService.create(this.companyHomeNodeRef, "folder-" + GUID.generate(), ContentModel.TYPE_FOLDER);
        this.permissionService.setInheritParentPermissions(folder.getNodeRef(), false);
        this.permissionService.setPermission(folder.getNodeRef(), USER1_NAME, this.permissionService.getAllPermission(), true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER1_NAME);
        FileInfo testFileInfo = this.fileFolderService.create(folder.getNodeRef(), "file-" + GUID.generate(), ContentModel.TYPE_CONTENT);
        NodeRef workingCopyNodeRef = this.checkOutCheckInService.checkout(testFileInfo.getNodeRef());
        String workingCopyName = this.fileFolderService.getFileInfo(workingCopyNodeRef).getName();
        String pathToWC = "/" + folder.getName() + "/" + workingCopyName;
        String pathToOriginal = "/" + folder.getName() + "/" + testFileInfo.getName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER2_NAME);
        try {
            this.lockService.lock(workingCopyNodeRef, LockType.WRITE_LOCK);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        try {
            this.executeMethod("LOCK", pathToWC, this.davLockInfoUser2File, null);
            Assert.fail((String)"The LOCK execution should fail with a 401 error");
        }
        catch (WebDAVServerException wse) {
            Assert.assertTrue((String)("The status code was " + wse.getHttpStatusCode() + ", but should be 401"), (wse.getHttpStatusCode() == 401 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception occurred: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        String lockToken = workingCopyNodeRef.getId() + ":" + USER2_NAME;
        String lockHeaderValue = "(<opaquelocktoken:" + lockToken + ">)";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("If", lockHeaderValue);
        try {
            this.executeMethod("PUT", pathToWC, this.testDataFile, headers);
            Assert.fail((String)"The PUT execution should fail with a 423 error");
        }
        catch (WebDAVServerException wse) {
            Assert.assertTrue((String)("The status code was " + wse.getHttpStatusCode() + ", but should be 401"), (wse.getHttpStatusCode() == 401 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception occurred: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.permissionService.setPermission(folder.getNodeRef(), USER2_NAME, this.permissionService.getAllPermission(), true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER2_NAME);
        try {
            this.executeMethod("LOCK", pathToWC, this.davLockInfoUser2File, null);
            Assert.assertEquals((String)"File should be locked", (Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(workingCopyNodeRef));
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to lock a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        headers = new HashMap();
        headers.put("If", lockHeaderValue);
        try {
            this.executeMethod("PUT", pathToWC, this.testDataFile, headers);
            Assert.assertTrue((String)"File does not exist.", (boolean)this.nodeService.exists(workingCopyNodeRef));
            Assert.assertEquals((String)"Filename is not correct", (Object)workingCopyName, (Object)this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_NAME));
            Assert.assertTrue((String)("Expected return status is 204, but returned is " + this.response.getStatus()), (204 == this.response.getStatus() ? 1 : 0) != 0);
            Assert.assertTrue((String)"File should have NO_CONTENT aspect", (boolean)this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_NO_CONTENT));
            InputStream updatedFileIS = this.fileFolderService.getReader(workingCopyNodeRef).getContentInputStream();
            byte[] updatedFile = IOUtils.toByteArray((InputStream)updatedFileIS);
            updatedFileIS.close();
            Assert.assertTrue((String)"The content has to be equal", (boolean)ArrayUtils.isEquals((Object)this.testDataFile, (Object)updatedFile));
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        headers = new HashMap();
        headers.put("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
        try {
            this.executeMethod("UNLOCK", pathToWC, null, headers);
            Assert.assertTrue((String)("Expected return status is 204, but returned is " + this.response.getStatus()), (204 == this.response.getStatus() ? 1 : 0) != 0);
            Assert.assertFalse((String)"File should not have NO_CONTENT aspect", (boolean)this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_NO_CONTENT));
            Assert.assertEquals((String)"File should be unlocked", (Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(workingCopyNodeRef));
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to unlock a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER2_NAME);
        try {
            this.lockService.lock(testFileInfo.getNodeRef(), LockType.WRITE_LOCK);
        }
        catch (UnableToAquireLockException e) {
            // empty catch block
        }
        try {
            this.executeMethod("LOCK", pathToOriginal, this.davLockInfoUser2File, null);
            Assert.fail((String)"The LOCK execution should fail with a 423 error");
        }
        catch (WebDAVServerException wse) {
            Assert.assertTrue((String)("The status code was " + wse.getHttpStatusCode() + ", but should be 423"), (wse.getHttpStatusCode() == 423 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception occurred: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        lockToken = testFileInfo.getNodeRef().getId() + ":" + USER2_NAME;
        lockHeaderValue = "(<opaquelocktoken:" + lockToken + ">)";
        headers = new HashMap();
        headers.put("If", lockHeaderValue);
        try {
            this.executeMethod("PUT", pathToOriginal, this.testDataFile, headers);
            Assert.fail((String)"The PUT execution should fail with a 423 error");
        }
        catch (WebDAVServerException wse) {
            Assert.assertTrue((String)("The status code was " + wse.getHttpStatusCode() + ", but should be 423"), (wse.getHttpStatusCode() == 423 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception occurred: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER1_NAME);
        this.checkOutCheckInService.checkin(workingCopyNodeRef, null);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.nodeService.deleteNode(folder.getNodeRef());
    }

    @Test
    public void testPutContentCheckVersions() throws Exception {
        Assert.assertEquals((String)"The version should be 1.0 as no file modifications were done yet.", (Object)"1.0", (Object)this.nodeService.getProperty(this.versionableDoc, ContentModel.PROP_VERSION_LABEL));
        try {
            this.executeMethod("LOCK", this.versionableDocName, this.davLockInfoAdminFile, null);
            Assert.assertEquals((String)"The version should not advance", (Object)"1.0", (Object)this.nodeService.getProperty(this.versionableDoc, ContentModel.PROP_VERSION_LABEL));
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to lock a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        Assert.assertEquals((String)"The version should not advance", (Object)"1.0", (Object)this.nodeService.getProperty(this.versionableDoc, ContentModel.PROP_VERSION_LABEL));
        String lockToken = this.versionableDoc.getId() + ":" + AuthenticationUtil.getAdminUserName();
        String lockHeaderValue = "(<opaquelocktoken:" + lockToken + ">)";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("If", lockHeaderValue);
        try {
            this.executeMethod("PUT", this.versionableDocName, this.testDataFile, headers);
            Assert.assertEquals((String)"The version should not advance", (Object)"1.0", (Object)this.nodeService.getProperty(this.versionableDoc, ContentModel.PROP_VERSION_LABEL));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upload a file", e);
        }
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        Assert.assertEquals((String)"The version should advance", (Object)"1.1", (Object)this.nodeService.getProperty(this.versionableDoc, ContentModel.PROP_VERSION_LABEL));
        headers = new HashMap();
        headers.put("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
        try {
            this.executeMethod("UNLOCK", this.versionableDocName, null, headers);
            Assert.assertEquals((String)"The version should not advance from 1.1", (Object)"1.1", (Object)this.nodeService.getProperty(this.versionableDoc, ContentModel.PROP_VERSION_LABEL));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unlock a file", e);
        }
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        Assert.assertEquals((String)"The version should not advance from 1.1", (Object)"1.1", (Object)this.nodeService.getProperty(this.versionableDoc, ContentModel.PROP_VERSION_LABEL));
    }

    @Test
    public void testPutNoContentFileAndUpdate() throws Exception {
        String fileName = "file-" + GUID.generate();
        NodeRef fileNoderef = null;
        try {
            this.executeMethod("PUT", fileName, new byte[0], null);
            List refs = this.searchService.selectNodes(this.nodeService.getRootNode(this.storeRef), "/app:company_home/cm:" + fileName, null, (NamespacePrefixResolver)this.namespaceService, false);
            fileNoderef = (NodeRef)refs.get(0);
            Assert.assertTrue((String)"File should exist.", (boolean)this.nodeService.exists(fileNoderef));
            Assert.assertEquals((String)"Filename is not correct", (Object)fileName, (Object)this.nodeService.getProperty(fileNoderef, ContentModel.PROP_NAME));
            Assert.assertTrue((String)("Expected return status is 201, but returned is " + this.response.getStatus()), (201 == this.response.getStatus() ? 1 : 0) != 0);
            byte[] updatedFile = IOUtils.toByteArray((InputStream)this.fileFolderService.getReader(fileNoderef).getContentInputStream());
            Assert.assertTrue((String)"The content should be empty", (updatedFile.length == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upload a file", e);
        }
        try {
            this.executeMethod("LOCK", fileName, this.davLockInfoAdminFile, null);
            Assert.assertEquals((String)"File should be locked", (Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(fileNoderef));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lock a file", e);
        }
        String lockToken = fileNoderef.getId() + ":" + AuthenticationUtil.getAdminUserName();
        String lockHeaderValue = "(<opaquelocktoken:" + lockToken + ">)";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("If", lockHeaderValue);
        try {
            this.executeMethod("PUT", fileName, this.testDataFile, headers);
            Assert.assertTrue((String)"File does not exist.", (boolean)this.nodeService.exists(fileNoderef));
            Assert.assertEquals((String)"Filename is not correct", (Object)fileName, (Object)this.nodeService.getProperty(fileNoderef, ContentModel.PROP_NAME));
            Assert.assertTrue((String)("Expected return status is 204, but returned is " + this.response.getStatus()), (204 == this.response.getStatus() ? 1 : 0) != 0);
            Assert.assertTrue((String)"File should have NO_CONTENT aspect", (boolean)this.nodeService.hasAspect(fileNoderef, ContentModel.ASPECT_NO_CONTENT));
            InputStream updatedFileIS = this.fileFolderService.getReader(fileNoderef).getContentInputStream();
            byte[] updatedFile = IOUtils.toByteArray((InputStream)updatedFileIS);
            updatedFileIS.close();
            Assert.assertTrue((String)"The content has to be equal", (boolean)ArrayUtils.isEquals((Object)this.testDataFile, (Object)updatedFile));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upload a file", e);
        }
        headers = new HashMap();
        headers.put("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
        try {
            this.executeMethod("UNLOCK", fileName, null, headers);
            Assert.assertTrue((String)("Expected return status is 204, but returned is " + this.response.getStatus()), (204 == this.response.getStatus() ? 1 : 0) != 0);
            Assert.assertFalse((String)"File should not have NO_CONTENT aspect", (boolean)this.nodeService.hasAspect(fileNoderef, ContentModel.ASPECT_NO_CONTENT));
            Assert.assertEquals((String)"File should be unlocked", (Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(fileNoderef));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unlock a file", e);
        }
        if (fileNoderef != null) {
            this.nodeService.deleteNode(fileNoderef);
        }
    }

    @Test
    public void testPutNullContent() throws Exception {
        String fileName = "file-" + GUID.generate();
        NodeRef fileNoderef = null;
        try {
            this.executeMethod("LOCK", fileName, this.davLockInfoAdminFile, null);
            List refs = this.searchService.selectNodes(this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), "/app:company_home/cm:" + fileName, null, (NamespacePrefixResolver)this.namespaceService, false);
            fileNoderef = (NodeRef)refs.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lock a file", e);
        }
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        String lockToken = fileNoderef.getId() + ":" + AuthenticationUtil.getAdminUserName();
        String lockHeaderValue = "(<opaquelocktoken:" + lockToken + ">)";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("If", lockHeaderValue);
        ActionService mockActionService = (ActionService)Mockito.mock(ActionService.class);
        Mockito.when((Object)mockActionService.createAction("extract-metadata")).thenThrow(new Throwable[]{new AlfrescoRuntimeException("Negative test")});
        try {
            this.webDAVHelper.setActionService(mockActionService);
            this.executeMethod("PUT", fileName, null, headers);
            Assert.fail((String)"The execution should fail.");
        }
        catch (WebDAVServerException wse) {
            if (this.nodeService.exists(fileNoderef)) {
                this.nodeService.deleteNode(fileNoderef);
                Assert.fail((String)"File exist, but should not.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upload a file", e);
        }
        finally {
            this.webDAVHelper.setActionService(this.actionService);
        }
        if (fileNoderef != null && this.nodeService.exists(fileNoderef)) {
            this.nodeService.deleteNode(fileNoderef);
        }
    }

    private void executeMethod(String methodName, String fileName, byte[] content, Map<String, String> headers) throws Exception {
        if (methodName == "PUT") {
            this.method = new PutMethod();
        } else if (methodName == "LOCK") {
            this.method = new LockMethod();
        } else if (methodName == "UNLOCK") {
            this.method = new UnlockMethod();
        }
        if (this.method != null) {
            this.request = new MockHttpServletRequest(methodName, "/alfresco/webdav/" + fileName);
            this.response = new MockHttpServletResponse();
            this.request.setServerPort(8080);
            this.request.setServletPath("/webdav");
            if (content != null) {
                this.request.setContent(content);
            }
            if (headers != null && !headers.isEmpty()) {
                for (String key : headers.keySet()) {
                    this.request.addHeader(key, (Object)headers.get(key));
                }
            }
            this.method.setDetails((HttpServletRequest)this.request, (HttpServletResponse)this.response, this.webDAVHelper, this.companyHomeNodeRef);
            this.method.execute();
        }
    }

    static {
        USER1_NAME = "user1-" + PutMethodTest.class.getName();
        USER2_NAME = "user2-" + PutMethodTest.class.getName();
    }
}

