/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.rest.api.tests.util.MultiPartBuilder;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.jacksonextensions.ExecutionResult;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.content.BinaryProperty;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tests.api.mocks.Animal;
import org.alfresco.rest.framework.tests.api.mocks.Farmer;
import org.alfresco.rest.framework.tests.api.mocks.Goat;
import org.alfresco.rest.framework.tests.api.mocks.Grass;
import org.alfresco.rest.framework.tests.api.mocks.Sheep;
import org.alfresco.rest.framework.tests.api.mocks3.Flock;
import org.alfresco.rest.framework.tests.api.mocks3.SlimGoat;
import org.alfresco.rest.framework.tests.core.AbstractContextTest;
import org.alfresco.rest.framework.tests.core.ParamsExtender;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.framework.webscripts.AbstractResourceWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.servlet.FormData;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;

public class SerializeTests
extends AbstractContextTest
implements RecognizedParamsExtractor {
    @Test
    public void testInvokeEntity() throws IOException {
        ResourceWithMetadata entityResource = this.locator.locateEntityResource(api, "sheep", HttpMethod.GET);
        Assert.assertNotNull((Object)entityResource);
        EntityResourceAction.ReadById getter = (EntityResourceAction.ReadById)entityResource.getResource();
        String out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, NOT_USED, getter.readById("1234A3", (Parameters)NOT_USED)));
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.startsWith((CharSequence)out, (CharSequence)"{\"entry\":"));
        EntityResourceAction.Read getAll = (EntityResourceAction.Read)entityResource.getResource();
        CollectionWithPagingInfo resources = getAll.readAll(null);
        out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)resources));
        Assert.assertTrue((String)"There must be json output as List", (boolean)StringUtils.startsWith((CharSequence)out, (CharSequence)"{\"list\":"));
    }

    @Test
    public void testInvokeMultiPartEntity() throws IOException {
        ResourceWithMetadata entityResource = this.locator.locateEntityResource(api, "multiparttest", HttpMethod.POST);
        Assert.assertNotNull((Object)entityResource);
        MultiPartResourceAction.Create resource = (MultiPartResourceAction.Create)entityResource.getResource();
        File file = TempFileProvider.createTempFile((String)"ParamsExtractorTests-", (String)".txt");
        PrintWriter writer = new PrintWriter(file);
        writer.println("Multipart Mock test2.");
        writer.close();
        MultiPartBuilder.MultiPartRequest reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(file.getName(), file, "text/plain")).build();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest("POST", "");
        mockRequest.setContent(reqBody.getBody());
        mockRequest.setContentType(reqBody.getContentType());
        String out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, NOT_USED, resource.create(new FormData((HttpServletRequest)mockRequest), (Parameters)NOT_USED, callBack)));
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.startsWith((CharSequence)out, (CharSequence)"{\"entry\":"));
    }

    @Test
    public void testSerializeResponse() throws IOException {
        ResourceWithMetadata relationResource = this.locator.locateRelationResource(api, "sheep", "baaahh", HttpMethod.GET);
        Assert.assertNotNull((Object)relationResource);
        RelationshipResourceAction.Read getter = (RelationshipResourceAction.Read)relationResource.getResource();
        CollectionWithPagingInfo resources = getter.readAll("123", (Parameters)Params.valueOf((String)"", null, null));
        String out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)resources));
        Assert.assertTrue((String)"There must be json output as List", (boolean)StringUtils.startsWith((CharSequence)out, (CharSequence)"{\"list\":"));
    }

    @Test
    public void testPagedCollection() throws IOException {
        ResourceWithMetadata relationResource = this.locator.locateRelationResource(api, "sheep", "baaahh", HttpMethod.GET);
        Assert.assertNotNull((Object)relationResource);
        RelationshipResourceAction.Read getter = (RelationshipResourceAction.Read)relationResource.getResource();
        CollectionWithPagingInfo resources = getter.readAll("123", (Parameters)Params.valueOf((String)"", null, null));
        Assert.assertNotNull((Object)resources);
        Assert.assertTrue((resources.getTotalItems() == 3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)resources.hasMoreItems());
        String out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)resources));
        Assert.assertTrue((String)"There must be json output as List with pagination", (boolean)StringUtils.startsWith((CharSequence)out, (CharSequence)"{\"list\":{\"pagination\":{\"count\":3,"));
        resources = getter.readAll("123", (Parameters)ParamsExtender.valueOf(Paging.valueOf((int)0, (int)1), "123"));
        Assert.assertTrue((resources.getCollection().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)resources.hasMoreItems());
        out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)resources));
        Assert.assertTrue((String)"There must be json output as List with pagination", (boolean)StringUtils.startsWith((CharSequence)out, (CharSequence)"{\"list\":{\"pagination\":{\"count\":1,"));
    }

    @Test
    public void testExpandEmbedded() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        Farmer aFarmer = new Farmer("180");
        aFarmer.setGoatId("1111");
        aFarmer.setSheepId("2222");
        ExecutionResult res = (ExecutionResult)this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)aFarmer);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)Farmer.class.equals(res.getRoot().getClass()));
        Map embeds = res.getEmbedded();
        Assert.assertNotNull((Object)embeds);
        Assert.assertTrue((embeds.size() > 0 ? 1 : 0) != 0);
        ExecutionResult goat = (ExecutionResult)embeds.get("goat");
        Assert.assertTrue((boolean)Goat.class.equals(goat.getRoot().getClass()));
        ExecutionResult grassEmbed = (ExecutionResult)goat.getEmbedded().get("grass");
        Grass grass = (Grass)grassEmbed.getRoot();
        Assert.assertNotNull((Object)grass);
        Assert.assertTrue((boolean)"Goat1111".equals(grass.getId()));
        ExecutionResult sheep = (ExecutionResult)embeds.get("sheep");
        Assert.assertTrue((boolean)Sheep.class.equals(sheep.getRoot().getClass()));
        Sheep aSheep = (Sheep)sheep.getRoot();
        Assert.assertTrue((boolean)"2222".equals(aSheep.getId()));
        String out = this.writeResponse(res);
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
    }

    @Test
    public void testExpandRelations() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        Map rFilter = this.getRelationFilter("blacksheep,baaahh");
        ExecutionResult res = (ExecutionResult)this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, "sheep", ParamsExtender.valueOf(rFilter, "1"), (Object)new Farmer("180"));
        Assert.assertNotNull((Object)res);
        String out = this.writeResponse(res);
        Assert.assertTrue((boolean)Farmer.class.equals(res.getRoot().getClass()));
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
        Paging pageRequest = Paging.valueOf((int)1, (int)2);
        Object resultCollection = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, "sheep", ParamsExtender.valueOf(rFilter, "1"), (Object)CollectionWithPagingInfo.asPaged((Paging)pageRequest, Arrays.asList(new Farmer("180"), new Farmer("190"), new Farmer("280"))));
        Assert.assertNotNull((Object)resultCollection);
        out = this.writeResponse(resultCollection);
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
    }

    @Test
    public void testIncludeSource() throws IOException {
        ExecutionResult exec1 = new ExecutionResult((Object)new Farmer("180"), null);
        ExecutionResult exec2 = new ExecutionResult((Object)new Farmer("456"), null);
        CollectionWithPagingInfo coll = CollectionWithPagingInfo.asPaged(null, Arrays.asList(exec1, exec2));
        Object resultCollection = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, "sheep", ParamsExtender.valueOf(true, "1"), (Object)coll);
        Assert.assertNotNull((Object)resultCollection);
        String out = this.writeResponse(resultCollection);
        Assert.assertTrue((String)"There must 'source' json output", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"source\":{\"name\":\"Dolly\",\"age\":3,\"sheepGuid\":\"1\"}"));
        resultCollection = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, "sheep", ParamsExtender.valueOf(false, "1"), (Object)coll);
        Assert.assertNotNull((Object)resultCollection);
        out = this.writeResponse(resultCollection);
        Assert.assertFalse((String)"There must not 'source' json output", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"source\":{\"name\":\"Dolly\",\"age\":3,\"sheepGuid\":\"1\"}"));
        coll = CollectionWithPagingInfo.asPaged(null, Arrays.asList(exec1, exec2), (boolean)false, (Integer)2, (Object)new Sheep("barbie"));
        resultCollection = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, "sheep", ParamsExtender.valueOf(true, "1"), (Object)coll);
        Assert.assertNotNull((Object)resultCollection);
        out = this.writeResponse(resultCollection);
        Assert.assertTrue((String)"There must 'source' json output", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"source\":{\"name\":\"Dolly\",\"age\":3,\"sheepGuid\":\"barbie\""));
    }

    @Test
    public void testExpandRecursiveRelations() throws IOException {
        ExecutionResult exec1 = new ExecutionResult((Object)new Farmer("180"), null);
        ExecutionResult exec2 = new ExecutionResult((Object)new Farmer("456"), this.getFilter("age"));
        CollectionWithPagingInfo coll = CollectionWithPagingInfo.asPaged(null, Arrays.asList(exec1, exec2));
        ExecutionResult execResult = new ExecutionResult((Object)new Sheep("ssheep"), null);
        HashMap<String, CollectionWithPagingInfo> related = new HashMap<String, CollectionWithPagingInfo>();
        related.put("farmers", coll);
        execResult.addRelated(related);
        String out = this.writeResponse(execResult);
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
        Assert.assertFalse((String)"collections should be serialized correctly.  There may be a problem with this one.", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"collection\":["));
        Assert.assertTrue((String)"collections should be serialized correctly.  There should be embed relations", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"relations\":{\"farmers\":{\"list\":"));
    }

    @Test
    public void testSerializeExecutionResult() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        Object res = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)new Farmer("180"));
        String out = this.writeResponse(res);
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
    }

    @Test
    public void testSerializePagedCollection() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        CollectionWithPagingInfo paged = CollectionWithPagingInfo.asPaged(null, null);
        String out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)paged));
        Assert.assertTrue((String)"There must be json output as List with pagination", (boolean)StringUtils.startsWith((CharSequence)out, (CharSequence)"{\"list\":{\"pagination\":{\"count\":0,"));
        Paging pageRequest = Paging.valueOf((int)1, (int)2);
        paged = CollectionWithPagingInfo.asPaged((Paging)pageRequest, Arrays.asList(new Goat(), new Sheep("ABCD"), new Sheep("XYZ")));
        out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)paged));
        Assert.assertTrue((String)"There must be json output as List with pagination", (boolean)StringUtils.startsWith((CharSequence)out, (CharSequence)"{\"list\":{\"pagination\":{\"count\":3,"));
        paged = CollectionWithPagingInfo.asPaged((Paging)pageRequest, Arrays.asList(new Goat(), new Sheep("ABCD"), new Sheep("XYZ")), (boolean)true, (Integer)5000);
        out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)paged));
        Assert.assertTrue((String)"There must be json output as List with pagination", (boolean)StringUtils.startsWith((CharSequence)out, (CharSequence)"{\"list\":{\"pagination\":{\"count\":3,\"hasMoreItems\":true,\"totalItems\":5000"));
    }

    @Test
    public void testSerializeMap() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        HashMap<String, Animal> aMap = new HashMap<String, Animal>();
        aMap.put("goatie", new Goat());
        aMap.put("sheepie", new Sheep("ABCD"));
        aMap.put("sheepy", new Sheep("XYZ"));
        Object res = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), aMap);
        String out = this.writeResponse(res);
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
    }

    @Test
    public void testSerializeSet() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        HashSet<Animal> aSet = new HashSet<Animal>();
        aSet.add(new Goat());
        aSet.add(new Sheep("ABCD"));
        aSet.add(new Sheep("XYZ"));
        Object res = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), aSet);
        String out = this.writeResponse(res);
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
    }

    @Test
    public void testSerializeListOfSimpleType() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        CollectionWithPagingInfo pString = CollectionWithPagingInfo.asPaged(null, Arrays.asList("goat", "sheep", "horse"));
        Object res = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)pString);
        String out = this.writeResponse(res);
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
        CollectionWithPagingInfo pInts = CollectionWithPagingInfo.asPaged(null, Arrays.asList(234, 45, 890, 3456));
        res = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)pInts);
        out = this.writeResponse(res);
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
    }

    @Test
    public void testSerializeList() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        Object res = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), Arrays.asList(new Goat(), new Sheep("ABCD"), new Sheep("XYZ")));
        String out = this.writeResponse(res);
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
    }

    @Test
    public void testSerializeCustom() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        String uuid = GUID.generate();
        String out = this.writeResponse(uuid);
        NodeRef n = (NodeRef)this.jsonHelper.construct((Reader)new StringReader(out), NodeRef.class);
        Assert.assertNotNull((Object)n);
        Assert.assertEquals((Object)uuid, (Object)n.getId());
    }

    @Test
    public void testSerializeUniqueId() throws IOException {
        Assert.assertNotNull((Object)this.helper);
        Object res = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)new Sheep("ABCD"));
        String out = this.writeResponse(res);
        Assert.assertTrue((String)"Id field must be called sheepGuid.", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"sheepGuid\":\"ABCD\""));
    }

    @Test
    public void testInvokeRelation() throws IOException {
        ResourceWithMetadata relationResource = this.locator.locateRelationResource(api, "sheep", "baaahh", HttpMethod.GET);
        Assert.assertNotNull((Object)relationResource);
        RelationshipResourceAction.Read getter = (RelationshipResourceAction.Read)relationResource.getResource();
        String out = this.writeResponse(this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), api, null, Params.valueOf((String)"notUsed", null, null), (Object)getter.readAll("1234A3", (Parameters)Params.valueOf((String)"notUsed", null, null))));
        Assert.assertTrue((String)"There must be json output", (boolean)StringUtils.isNotBlank((CharSequence)out));
    }

    @Test
    public void testSerializeBinaryProperty() throws IOException {
        BinaryProperty prop = new BinaryProperty(Format.JSON.mimetype(), "UTF-8");
        String out = this.writeResponse(prop);
        Assert.assertTrue((String)"Only show the mimeType", (boolean)out.equals("{\"mimeType\":\"application/json\"}"));
        prop = new BinaryProperty(Format.XML.mimetype(), "UTF-8", 45L, null);
        out = this.writeResponse(prop);
        Assert.assertTrue((String)"Type is xml.", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"mimeType\":\"text/xml\""));
        Assert.assertTrue((String)"Size must be serialized.", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"sizeInBytes\":45"));
        prop = new BinaryProperty(Format.XML.mimetype(), "UTF-8", 99L, Locale.CANADA_FRENCH);
        out = this.writeResponse(prop);
        Assert.assertFalse((String)"Locale should not be serialized", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"locale\""));
        Flock flock = new Flock("myflock", 50, null, prop);
        out = this.writeResponse(flock);
        Assert.assertFalse((String)"Locale should not be serialized", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"locale\""));
        Assert.assertTrue((String)"Type is xml.", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"mimeType\":\"text/xml\""));
        Assert.assertTrue((String)"Size must be serialized.", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"\"sizeInBytes\":99"));
    }

    @Test
    public void testInvokeProperty() throws IOException {
        Api api3 = Api.valueOf((String)"alfrescomock", (String)"private", (String)"3");
        ResourceWithMetadata propResource = this.locator.locateRelationResource(api3, "flock", "photo", HttpMethod.GET);
        AbstractResourceWebScript executor = this.getExecutor();
        Object result = executor.execute(propResource, Params.valueOf((String)"234", null, null), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), true);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testInvokeVersions() throws IOException {
        HashMap<String, Object> respons = new HashMap<String, Object>();
        ResourceWithMetadata entityResource = this.locator.locateEntityResource(api, "goat", HttpMethod.GET);
        Assert.assertNotNull((Object)entityResource);
        EntityResourceAction.ReadById getter = (EntityResourceAction.ReadById)entityResource.getResource();
        Object readById = getter.readById("1234A3", (Parameters)NOT_USED);
        Assert.assertTrue((String)"Version 1 must be a goat.", (boolean)Goat.class.equals(readById.getClass()));
        String out = this.writeResponse(readById);
        Assert.assertNotNull((Object)out);
        Api v3 = Api.valueOf((String)api.getName(), (String)api.getScope().toString(), (String)"3");
        entityResource = this.locator.locateEntityResource(v3, "goat", HttpMethod.GET);
        Assert.assertNotNull((Object)entityResource);
        getter = (EntityResourceAction.ReadById)entityResource.getResource();
        Object readByIdForNewVersion = getter.readById("1234A3", (Parameters)NOT_USED);
        Assert.assertTrue((String)"Version 3 must be a slim goat.", (boolean)SlimGoat.class.equals(readByIdForNewVersion.getClass()));
        respons.put("v3Goat", readByIdForNewVersion);
        out = this.writeResponse(readByIdForNewVersion);
        entityResource = this.locator.locateEntityResource(api, "grass", HttpMethod.GET);
        Assert.assertNotNull((Object)entityResource);
        try {
            entityResource = this.locator.locateEntityResource(v3, "grass", HttpMethod.GET);
            Assert.fail((String)"Should throw an UnsupportedResourceOperationException");
        }
        catch (UnsupportedResourceOperationException unsupportedResourceOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testFilter() throws IOException, JSONException {
        Assert.assertNotNull((Object)this.helper);
        BeanPropertiesFilter theFilter = this.getFilter("age");
        Object res = new ExecutionResult((Object)new Sheep("bob"), theFilter);
        String out = this.writeResponse(res);
        Assert.assertTrue((String)"Filter must only return the age.", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"{\"age\":3}"));
        theFilter = this.getFilter("age,name");
        res = new ExecutionResult((Object)new Sheep("bob"), theFilter);
        out = this.writeResponse(res);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(out));
        Assert.assertEquals((long)1L, (long)jsonRsp.length());
        JSONObject entry = jsonRsp.getJSONObject("entry");
        Assert.assertEquals((long)2L, (long)entry.length());
        Assert.assertEquals((String)"The name should be 'Dolly'", (Object)"Dolly", (Object)entry.getString("name"));
        Assert.assertTrue((String)"The age should be 3", (entry.getInt("age") == 3 ? 1 : 0) != 0);
        List theInclude = this.getIncludeClause("name");
        theFilter = this.getFilter("age", theInclude);
        res = new ExecutionResult((Object)new Sheep("bob"), theFilter);
        out = this.writeResponse(res);
        jsonRsp = new JSONObject(new JSONTokener(out));
        Assert.assertEquals((long)1L, (long)jsonRsp.length());
        entry = jsonRsp.getJSONObject("entry");
        Assert.assertEquals((long)2L, (long)entry.length());
        Assert.assertEquals((String)"The name should be 'Dolly'", (Object)"Dolly", (Object)entry.getString("name"));
        Assert.assertTrue((String)"The age should be 3", (entry.getInt("age") == 3 ? 1 : 0) != 0);
        Api v3 = Api.valueOf((String)api.getName(), (String)api.getScope().toString(), (String)"3");
        Map relFiler = this.getRelationFilter("herd");
        res = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), v3, "goat", ParamsExtender.valueOf(relFiler, "notUsed"), (Object)new SlimGoat());
        out = this.writeResponse(res);
        jsonRsp = new JSONObject(new JSONTokener(out));
        entry = jsonRsp.getJSONObject("relations").getJSONObject("herd").getJSONObject("list").getJSONArray("entries").getJSONObject(0).getJSONObject("entry");
        Assert.assertEquals((String)"The name should be 'bigun'", (Object)"bigun", (Object)entry.getString("name"));
        Assert.assertTrue((String)"The quantity should be 56", (entry.getInt("quantity") == 56 ? 1 : 0) != 0);
        relFiler = this.getRelationFilter("herd(name)");
        res = this.helper.processAdditionsToTheResponse((WebScriptResponse)Mockito.mock(WebScriptResponse.class), v3, "goat", ParamsExtender.valueOf(relFiler, "notUsed"), (Object)new SlimGoat());
        out = this.writeResponse(res);
        Assert.assertTrue((String)"Must return only the herd name.", (boolean)StringUtils.contains((CharSequence)out, (CharSequence)"{\"name\":\"bigun\"}"));
    }

    @Test
    public void schema() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonSchema schema = objectMapper.generateJsonSchema(Farmer.class);
        Assert.assertNotNull((Object)schema);
        System.out.println("\nschema:");
        System.out.println(schema.toString());
    }

    private String writeResponse(final Object respons) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.jsonHelper.withWriter((OutputStream)out, new JacksonHelper.Writer(){

            public void writeContents(JsonGenerator generator, ObjectMapper objectMapper) throws JsonGenerationException, JsonMappingException, IOException {
                objectMapper.writeValue(generator, respons);
            }
        });
        System.out.println(out.toString());
        return out.toString();
    }
}

