/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.transform.client.registry.TransformServiceRegistry;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class MimetypesGet
extends DeclarativeWebScript {
    public static final String MODEL_MIMETYPES = "mimetypes";
    public static final String MODEL_EXTENSIONS = "extensions";
    public static final String MODEL_MIMETYPE_DETAILS = "details";
    private MimetypeService mimetypeService;
    private TransformServiceRegistry localTransformServiceRegistry;
    private MetadataExtracterRegistry metadataExtracterRegistry;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setLocalTransformServiceRegistry(TransformServiceRegistry localTransformServiceRegistry) {
        this.localTransformServiceRegistry = localTransformServiceRegistry;
    }

    public void setMetadataExtracterRegistry(MetadataExtracterRegistry metadataExtracterRegistry) {
        this.metadataExtracterRegistry = metadataExtracterRegistry;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Object[] mimetypesA = this.mimetypeService.getMimetypes().toArray(new String[0]);
        Arrays.sort(mimetypesA);
        ArrayList<Object> mimetypes = new ArrayList<Object>(Arrays.asList(mimetypesA));
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        for (String string : mimetypes) {
            String ext = this.mimetypeService.getExtension(string);
            extensions.put(string, ext);
        }
        HashMap details = new HashMap();
        String string = req.getParameter("mimetype");
        for (String string2 : mimetypes) {
            if (!string2.equals(string) && !"*".equals(string)) continue;
            HashMap<String, List<String>> mtd = new HashMap<String, List<String>>();
            mtd.put("extractors", this.getExtractors(string2));
            mtd.put("transformFrom", this.getTransformersFrom(string2, -1L, mimetypes));
            mtd.put("transformTo", this.getTransformersTo(string2, -1L, mimetypes));
            details.put(string2, mtd);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MODEL_MIMETYPES, mimetypes);
        model.put(MODEL_EXTENSIONS, extensions);
        model.put(MODEL_MIMETYPE_DETAILS, details);
        return model;
    }

    protected List<String> getExtractors(String mimetype) {
        ArrayList<String> exts = new ArrayList<String>();
        MetadataExtracter extractor = this.metadataExtracterRegistry.getExtracter(mimetype);
        if (extractor != null) {
            exts.add(extractor.getClass().getName());
        }
        return exts;
    }

    protected List<String> getTransformersFrom(String mimetype, long sourceSize, List<String> allMimetypes) {
        ArrayList<String> transforms = new ArrayList<String>();
        for (String toMT : allMimetypes) {
            String details;
            if (toMT.equals(mimetype) || (details = this.getTransformer(mimetype, sourceSize, toMT)) == null) continue;
            transforms.add(toMT + " = " + details);
        }
        return transforms;
    }

    protected List<String> getTransformersTo(String mimetype, long sourceSize, List<String> allMimetypes) {
        ArrayList<String> transforms = new ArrayList<String>();
        for (String fromMT : allMimetypes) {
            String details;
            if (fromMT.equals(mimetype) || (details = this.getTransformer(fromMT, sourceSize, mimetype)) == null) continue;
            transforms.add(fromMT + " = " + details);
        }
        return transforms;
    }

    protected String getTransformer(String from, long sourceSize, String to) {
        return this.localTransformServiceRegistry.findTransformerName(from, sourceSize, to, Collections.emptyMap(), null);
    }
}

