/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.LimitedStreamCopier;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.LockInfoImpl;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVLockService;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class WebDAVMethod {
    private static final String VERSION_NUM_PATTERN = "\\d+\\.\\d+(\\.\\d+)?";
    protected static Log logger = LogFactory.getLog((String)"org.alfresco.webdav.protocol");
    private static final boolean XMLPrettyPrint = true;
    private static final Map<String, Integer> accessDeniedStatusCodes = new LinkedHashMap<String, Integer>();
    protected HttpServletRequest m_request;
    protected HttpServletResponse m_response;
    private File m_requestBody;
    private ServletInputStream m_inputStream;
    private CharArrayWriter m_xmlWriter;
    private BufferedReader m_reader;
    protected WebDAVHelper m_davHelper;
    protected NodeRef m_rootNodeRef;
    protected String m_strPath = null;
    protected String m_userAgent = null;
    protected LinkedList<Condition> m_conditions = null;
    protected String m_resourceTag = null;
    protected int m_depth = -1;
    protected Map<NodeRef, NodeRef> m_childToParent = new HashMap<NodeRef, NodeRef>();
    protected Map<NodeRef, LockInfo> m_parentLockInfo = new HashMap<NodeRef, LockInfo>();
    private String siteId;
    private String tenantDomain;

    public void setDetails(final HttpServletRequest req, HttpServletResponse resp, WebDAVHelper davHelper, NodeRef rootNode) {
        this.m_request = new HttpServletRequestWrapper(req){

            public ServletInputStream getInputStream() throws IOException {
                if (WebDAVMethod.this.m_reader != null) {
                    throw new IllegalStateException("Reader in use");
                }
                if (WebDAVMethod.this.m_inputStream == null) {
                    final FileInputStream in = new FileInputStream(WebDAVMethod.this.getRequestBodyAsFile(req));
                    WebDAVMethod.this.m_inputStream = new ServletInputStream(){

                        public int read() throws IOException {
                            return in.read();
                        }

                        public int read(byte[] b) throws IOException {
                            return in.read(b);
                        }

                        public int read(byte[] b, int off, int len) throws IOException {
                            return in.read(b, off, len);
                        }

                        public long skip(long n) throws IOException {
                            return in.skip(n);
                        }

                        public int available() throws IOException {
                            return in.available();
                        }

                        public void close() throws IOException {
                            in.close();
                        }

                        public void mark(int readlimit) {
                            in.mark(readlimit);
                        }

                        public void reset() throws IOException {
                            in.reset();
                        }

                        public boolean markSupported() {
                            return in.markSupported();
                        }
                    };
                }
                return WebDAVMethod.this.m_inputStream;
            }

            public BufferedReader getReader() throws IOException {
                if (WebDAVMethod.this.m_inputStream != null) {
                    throw new IllegalStateException("Input Stream in use");
                }
                if (WebDAVMethod.this.m_reader == null) {
                    String encoding = req.getCharacterEncoding();
                    WebDAVMethod.this.m_reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(WebDAVMethod.this.getRequestBodyAsFile(req)), encoding == null ? "ISO-8859-1" : encoding));
                }
                return WebDAVMethod.this.m_reader;
            }
        };
        this.m_response = resp;
        this.m_davHelper = davHelper;
        this.m_rootNodeRef = rootNode;
        this.m_strPath = this.m_davHelper.getRepositoryPath(this.m_request);
    }

    private File getRequestBodyAsFile(HttpServletRequest req) throws IOException {
        if (this.m_requestBody == null) {
            this.m_requestBody = TempFileProvider.createTempFile((String)("webdav_" + req.getMethod() + "_"), (String)".bin");
            LimitedStreamCopier streamCopier = new LimitedStreamCopier();
            long bytes = streamCopier.copyStreamsLong((InputStream)req.getInputStream(), (OutputStream)new FileOutputStream(this.m_requestBody), this.m_davHelper.getSizeLimit());
            long contentLength = -1L;
            try {
                contentLength = Long.valueOf(req.getHeader("Content-Length"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (contentLength >= 0L && contentLength != bytes) {
                throw new IOException("Request body does not have specified Content Length");
            }
        }
        return this.m_requestBody;
    }

    protected boolean isReadOnly() {
        return false;
    }

    public final int getDepth() {
        return this.m_depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws WebDAVServerException {
        this.parseRequestHeaders();
        try {
            this.parseRequestBody();
        }
        catch (WebDAVServerException e) {
            if (e.getCause() != null && e.getCause() instanceof SAXParseException) {
                block19: {
                    SAXParseException saxParseEx = (SAXParseException)e.getCause();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Malformed request body", (Throwable)saxParseEx);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Malformed request body: " + saxParseEx.getMessage()));
                    }
                    try {
                        this.m_response.sendError(e.getHttpStatusCode());
                    }
                    catch (IOException ioe) {
                        if (!logger.isDebugEnabled()) break block19;
                        logger.debug((Object)"Unable to send status code", (Throwable)ioe);
                    }
                }
                return;
            }
            throw e;
        }
        this.m_userAgent = this.m_request.getHeader("User-Agent");
        RetryingTransactionHelper.RetryingTransactionCallback<Object> executeImplCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                WebDAVMethod.this.m_inputStream = null;
                WebDAVMethod.this.m_reader = null;
                WebDAVMethod.this.getDAVHelper().getLockService().setCurrentSession(WebDAVMethod.this.m_request.getSession());
                WebDAVMethod.this.executeImpl();
                return null;
            }
        };
        try {
            boolean isReadOnly = this.isReadOnly();
            this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)executeImplCallback, isReadOnly);
            this.generateResponseImpl();
        }
        catch (AccessDeniedException e) {
            throw new WebDAVServerException(this.getStatusForAccessDeniedException());
        }
        catch (Throwable e) {
            if (e instanceof WebDAVServerException) {
                throw (WebDAVServerException)e;
            }
            if (e.getCause() instanceof WebDAVServerException) {
                throw (WebDAVServerException)e.getCause();
            }
            boolean logOnly = false;
            Throwable t = e;
            while ((t = t.getCause()) != null) {
                if (!(t instanceof SocketException)) continue;
                logOnly = true;
                if (!logger.isTraceEnabled() && !logger.isDebugEnabled()) break;
                String message = "Client dropped connection [uri=" + this.m_request.getRequestURI() + "]";
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)message, e);
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)message);
                break;
            }
            if (!logOnly) {
                throw new WebDAVServerException(500, e);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        if (this.m_requestBody != null) {
            try {
                this.m_requestBody.delete();
                this.m_requestBody = null;
            }
            catch (Throwable t) {
                logger.error((Object)"Failed to delete temp file", t);
            }
        }
    }

    protected abstract void executeImpl() throws WebDAVServerException, Exception;

    protected void generateResponseImpl() throws Exception {
    }

    protected abstract void parseRequestBody() throws WebDAVServerException;

    protected abstract void parseRequestHeaders() throws WebDAVServerException;

    protected Document getRequestBodyAsDocument() throws WebDAVServerException {
        Document body = null;
        if (this.m_request.getContentLength() > 0) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                body = this.m_request.getCharacterEncoding() == null ? builder.parse(new InputSource((InputStream)this.m_request.getInputStream())) : builder.parse(new InputSource(this.m_request.getReader()));
            }
            catch (ParserConfigurationException e) {
                throw new WebDAVServerException(400, (Throwable)e);
            }
            catch (SAXException e) {
                throw new WebDAVServerException(400, (Throwable)e);
            }
            catch (IOException e) {
                throw new WebDAVServerException(400, (Throwable)e);
            }
        }
        return body;
    }

    protected void parseDepthHeader() throws WebDAVServerException {
        String strDepth = this.m_request.getHeader("Depth");
        if (strDepth != null && strDepth.length() > 0) {
            this.m_depth = strDepth.equals("0") ? 0 : (strDepth.equals("1") ? 1 : -1);
        }
    }

    protected void parseIfHeader() throws WebDAVServerException {
        String strIf = this.m_request.getHeader("If");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing If header: " + strIf));
        }
        if (strIf != null && strIf.length() > 0) {
            if (strIf.startsWith("<")) {
                this.m_resourceTag = strIf.substring(1, strIf.indexOf(">"));
                strIf = strIf.substring(this.m_resourceTag.length() + 3);
            }
            this.m_conditions = new LinkedList();
            String[] parts = strIf.split("\\) \\(");
            for (int i = 0; i < parts.length; ++i) {
                String partString = parts[i].replaceAll("\\(", "").replaceAll("\\)", "");
                Condition c = new Condition();
                String[] conditions = partString.split(" ");
                for (int j = 0; j < conditions.length; ++j) {
                    int index;
                    boolean fNot = false;
                    String eTag = null;
                    String lockToken = null;
                    if ("Not".equals(conditions[j])) {
                        if (j == conditions.length - 1) {
                            throw new WebDAVServerException(412);
                        }
                        fNot = true;
                        ++j;
                    }
                    if ((index = conditions[j].indexOf(60)) != -1) {
                        try {
                            String s = conditions[j].substring(index + 1, conditions[j].indexOf(">"));
                            if (!s.startsWith("opaquelocktoken:")) {
                                if (!fNot) {
                                    throw new WebDAVServerException(412);
                                }
                            } else {
                                lockToken = s;
                                c.addLockTocken(lockToken, fNot);
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new WebDAVServerException(412);
                        }
                    }
                    if ((index = conditions[j].indexOf("[\"")) == -1) continue;
                    int index2 = conditions[j].indexOf("]");
                    if (index2 == -1) {
                        logger.warn((Object)("No closing ']': " + conditions[j]));
                        index2 = conditions[j].length();
                    }
                    eTag = conditions[j].substring(index + 1, index2);
                    c.addETag(eTag, fNot);
                }
                this.m_conditions.add(c);
            }
        }
    }

    protected final WebDAVHelper getDAVHelper() {
        return this.m_davHelper;
    }

    protected final ServiceRegistry getServiceRegistry() {
        return this.m_davHelper.getServiceRegistry();
    }

    protected final TransactionService getTransactionService() {
        return this.m_davHelper.getServiceRegistry().getTransactionService();
    }

    protected final NodeService getNodeService() {
        return this.m_davHelper.getNodeService();
    }

    protected final SearchService getSearchService() {
        return this.m_davHelper.getSearchService();
    }

    protected final NamespaceService getNamespaceService() {
        return this.m_davHelper.getNamespaceService();
    }

    protected final FileFolderService getFileFolderService() {
        return this.m_davHelper.getFileFolderService();
    }

    protected final ContentService getContentService() {
        return this.m_davHelper.getServiceRegistry().getContentService();
    }

    protected final MimetypeService getMimetypeService() {
        return this.m_davHelper.getMimetypeService();
    }

    protected final WebDAVLockService getDAVLockService() {
        return this.m_davHelper.getLockService();
    }

    protected final ActionService getActionService() {
        return this.m_davHelper.getActionService();
    }

    protected final PermissionService getPermissionService() {
        return this.m_davHelper.getPermissionService();
    }

    protected final AuthenticationService getAuthenticationService() {
        return this.m_davHelper.getAuthenticationService();
    }

    protected final String getServletPath() {
        return this.m_request.getServletPath();
    }

    protected final String getContextPath() {
        return this.m_request.getContextPath();
    }

    protected final NodeRef getRootNodeRef() {
        return this.m_rootNodeRef;
    }

    public String getPath() {
        return this.m_strPath;
    }

    protected OutputFormat getXMLOutputFormat() {
        return OutputFormat.createPrettyPrint();
    }

    protected final XMLWriter createXMLWriter() throws IOException {
        this.m_xmlWriter = new CharArrayWriter(1024);
        return new XMLWriter((Writer)this.m_xmlWriter, this.getXMLOutputFormat());
    }

    protected void generateLockDiscoveryXML(XMLWriter xml, FileInfo lockNodeInfo, LockInfo lockInfo) throws Exception {
        String owner = lockInfo.getOwner();
        Date expiry = lockInfo.getExpires();
        String scope = lockInfo.getScope();
        String depth = lockInfo.getDepth();
        this.generateLockDiscoveryXML(xml, lockNodeInfo, false, scope, depth, WebDAV.makeLockToken(lockNodeInfo.getNodeRef(), owner), owner, expiry);
    }

    protected void generateLockDiscoveryXML(XMLWriter xml, FileInfo lockNodeInfo, boolean emptyNamespace, String scope, String depth, String lToken, String owner, Date expiryDate) throws Exception {
        String ns;
        AttributesImpl nullAttr = this.getDAVHelper().getNullAttributes();
        String string = ns = emptyNamespace ? "" : "D";
        if (lockNodeInfo != null) {
            xml.startElement(ns, "lockdiscovery", emptyNamespace ? "lockdiscovery" : "D:lockdiscovery", (Attributes)nullAttr);
            xml.startElement(ns, "activelock", emptyNamespace ? "activelock" : "D:activelock", (Attributes)nullAttr);
            xml.startElement(ns, "locktype", emptyNamespace ? "locktype" : "D:locktype", (Attributes)nullAttr);
            xml.write(DocumentHelper.createElement((String)(emptyNamespace ? "write" : "D:write")));
            xml.endElement(ns, "locktype", emptyNamespace ? "locktype" : "D:locktype");
            xml.startElement(ns, "lockscope", emptyNamespace ? "lockscope" : "D:lockscope", (Attributes)nullAttr);
            xml.write(DocumentHelper.createElement((String)(emptyNamespace ? scope : "D:" + scope)));
            xml.endElement(ns, "lockscope", emptyNamespace ? "lockscope" : "D:lockscope");
            xml.startElement(ns, "depth", emptyNamespace ? "depth" : "D:depth", (Attributes)nullAttr);
            xml.write(depth);
            xml.endElement(ns, "depth", emptyNamespace ? "depth" : "D:depth");
            xml.startElement(ns, "owner", emptyNamespace ? "owner" : "D:owner", (Attributes)nullAttr);
            xml.write(owner);
            xml.endElement(ns, "owner", emptyNamespace ? "owner" : "D:owner");
            xml.startElement(ns, "timeout", emptyNamespace ? "timeout" : "D:timeout", (Attributes)nullAttr);
            Object strTimeout = "Infinite";
            if (expiryDate != null) {
                long timeoutRemaining = (expiryDate.getTime() - System.currentTimeMillis()) / 1000L;
                strTimeout = "Second-" + timeoutRemaining;
            }
            xml.write((String)strTimeout);
            xml.endElement(ns, "timeout", emptyNamespace ? "timeout" : "D:timeout");
            xml.startElement(ns, "locktoken", emptyNamespace ? "locktoken" : "D:locktoken", (Attributes)nullAttr);
            xml.startElement(ns, "href", emptyNamespace ? "href" : "D:href", (Attributes)nullAttr);
            xml.write(lToken);
            xml.endElement(ns, "href", emptyNamespace ? "href" : "D:href");
            xml.endElement(ns, "locktoken", emptyNamespace ? "locktoken" : "D:locktoken");
            xml.endElement(ns, "activelock", emptyNamespace ? "activelock" : "D:activelock");
            xml.endElement(ns, "lockdiscovery", emptyNamespace ? "lockdiscovery" : "D:lockdiscovery");
        }
    }

    protected String generateNamespaceDeclarations(HashMap<String, String> nameSpaces) {
        StringBuilder ns = new StringBuilder();
        ns.append(" ");
        ns.append("xmlns");
        ns.append(":");
        ns.append("D");
        ns.append("=\"");
        ns.append("DAV:");
        ns.append("\"");
        if (nameSpaces != null) {
            for (String strNamespaceUri : nameSpaces.keySet()) {
                String strNamespaceName = nameSpaces.get(strNamespaceUri);
                ns.append(" ").append("xmlns").append(":").append(strNamespaceName).append("=\"");
                ns.append(strNamespaceUri == null ? "" : strNamespaceUri).append("\" ");
            }
        }
        return ns.toString();
    }

    protected LockInfo checkNode(FileInfo fileInfo, boolean ignoreShared, boolean lockMethod) throws WebDAVServerException {
        LockInfo nodeLockInfo = this.getNodeLockInfo(fileInfo);
        NodeRef nodeRef = fileInfo.getNodeRef();
        if (this.getDAVHelper().isLockedAndReadOnly(nodeRef)) {
            throw new WebDAVServerException(423);
        }
        String nodeETag = this.getDAVHelper().makeQuotedETag(fileInfo);
        if (this.m_conditions == null && (!nodeLockInfo.isExclusive() || this.m_userAgent != null && this.m_userAgent.equals("Microsoft Data Access Internet Publishing Provider DAV"))) {
            if (!ignoreShared && nodeLockInfo.isShared() && !nodeLockInfo.getSharedLockTokens().isEmpty()) {
                throw new WebDAVServerException(423);
            }
            return nodeLockInfo;
        }
        this.checkLockToken(nodeLockInfo, ignoreShared, lockMethod);
        this.checkConditions(nodeLockInfo.getExclusiveLockToken(), nodeETag);
        return nodeLockInfo;
    }

    protected LockInfo checkNode(FileInfo fileInfo) throws WebDAVServerException {
        return this.checkNode(fileInfo, false, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkLockToken(LockInfo lockInfo, boolean ignoreShared, boolean lockMethod) throws WebDAVServerException {
        block13: {
            String nodeLockToken = lockInfo.getExclusiveLockToken();
            Set sharedLockTokens = lockInfo.getSharedLockTokens();
            if (this.m_conditions != null) {
                if (lockInfo.isShared()) {
                    if (!sharedLockTokens.isEmpty()) {
                        if (ignoreShared) {
                            return;
                        }
                        Iterator iterator = this.m_conditions.iterator();
                        block0: while (true) {
                            String sharedLockToken;
                            if (!iterator.hasNext()) {
                                throw new WebDAVServerException(423);
                            }
                            Condition condition = (Condition)iterator.next();
                            Iterator iterator2 = sharedLockTokens.iterator();
                            do {
                                if (!iterator2.hasNext()) continue block0;
                                sharedLockToken = (String)iterator2.next();
                            } while (!condition.getLockTokensMatch().contains(sharedLockToken));
                            break;
                        }
                        return;
                    }
                    break block13;
                } else {
                    Condition condition;
                    if (nodeLockToken == null) {
                        return;
                    }
                    Iterator iterator = this.m_conditions.iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        throw new WebDAVServerException(423);
                    } while (!(condition = (Condition)iterator.next()).getLockTokensMatch().contains(nodeLockToken));
                    return;
                }
            }
            if (lockInfo.isShared()) {
                if (!lockMethod) {
                    return;
                }
                throw new WebDAVServerException(423);
            }
        }
        if (lockInfo.isExpired()) {
            return;
        }
        throw new WebDAVServerException(423);
    }

    private void checkConditions(String nodeLockToken, String nodeETag) throws WebDAVServerException {
        if (this.m_conditions == null) {
            return;
        }
        for (Condition condition : this.m_conditions) {
            boolean fMatchETag = true;
            boolean fMatchLockToken = true;
            if (condition.getETagsMatch() != null) {
                boolean bl = fMatchETag = condition.getETagsMatch().contains(nodeETag);
            }
            if (condition.getETagsNotMatch() != null) {
                boolean bl = fMatchETag = !condition.getETagsNotMatch().contains(nodeETag);
            }
            if (condition.getLockTokensMatch() != null) {
                boolean bl = fMatchLockToken = nodeLockToken == null || condition.getLockTokensMatch().contains(nodeLockToken);
            }
            if (condition.getLockTokensNotMatch() != null) {
                boolean bl = fMatchLockToken = nodeLockToken == null || !condition.getLockTokensNotMatch().contains(nodeLockToken);
            }
            if (!fMatchETag || !fMatchLockToken) continue;
            return;
        }
        throw new WebDAVServerException(412);
    }

    protected LockInfo getNodeLockInfo(final FileInfo nodeInfo) {
        if (nodeInfo.getNodeRef() == null) {
            return new LockInfoImpl();
        }
        return (LockInfo)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<LockInfo>(){

            public LockInfo doWork() throws Exception {
                return WebDAVMethod.this.getNodeLockInfoImpl(nodeInfo);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private LockInfo getNodeLockInfoImpl(final FileInfo nodeInfo) {
        LockInfo lockInfo = this.getNodeLockInfoDirect(nodeInfo);
        if (lockInfo != null) {
            return lockInfo;
        }
        return (LockInfo)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<LockInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public LockInfo doWork() throws Exception {
                NodeService nodeService = WebDAVMethod.this.getNodeService();
                NodeRef node = nodeInfo.getNodeRef();
                while (true) {
                    NodeRef parent;
                    if ((parent = WebDAVMethod.this.m_childToParent.get(node)) == null && !WebDAVMethod.this.m_childToParent.containsKey(node)) {
                        ChildAssociationRef childAssocRef = nodeService.getPrimaryParent(node);
                        parent = childAssocRef.getParentRef();
                        if (!childAssocRef.getTypeQName().equals((Object)ContentModel.ASSOC_CONTAINS)) {
                            parent = null;
                        }
                        WebDAVMethod.this.m_childToParent.put(node, parent);
                    }
                    if (parent == null) {
                        return new LockInfoImpl();
                    }
                    LockInfo lockInfo = WebDAVMethod.this.m_parentLockInfo.get(parent);
                    if (lockInfo != null && lockInfo.isLocked()) {
                        return lockInfo;
                    }
                    if (lockInfo == null) {
                        try {
                            lockInfo = WebDAVMethod.this.getNodeLockInfoIndirect(parent);
                            if (lockInfo != null) {
                                LockInfo lockInfo2 = lockInfo;
                                return lockInfo2;
                            }
                        }
                        finally {
                            if (lockInfo == null) {
                                lockInfo = new LockInfoImpl();
                            }
                            WebDAVMethod.this.m_parentLockInfo.put(parent, lockInfo);
                        }
                    }
                    node = parent;
                }
            }
        });
    }

    private LockInfo getNodeLockInfoDirect(FileInfo nodeInfo) {
        LockInfo lock = this.getDAVLockService().getLockInfo(nodeInfo.getNodeRef());
        if (lock == null) {
            return null;
        }
        if (lock.isLocked()) {
            return lock;
        }
        return null;
    }

    private LockInfo getNodeLockInfoIndirect(NodeRef parent) {
        LockInfo parentLock = this.getDAVLockService().getLockInfo(parent);
        if (parentLock == null) {
            return null;
        }
        if (parentLock.isLocked() && "infinity".equals(parentLock.getDepth())) {
            return parentLock;
        }
        return null;
    }

    protected FileInfo getNodeForPath(NodeRef rootNodeRef, String path) throws FileNotFoundException {
        return this.getDAVHelper().getNodeForPath(rootNodeRef, path);
    }

    protected String getURLForPath(HttpServletRequest request, String path, boolean isFolder) {
        return this.getDAVHelper().getURLForPath(request, path, isFolder, this.m_userAgent);
    }

    protected boolean shouldFlushXMLWriter() {
        return true;
    }

    protected final void flushXML(XMLWriter writer) throws IOException {
        if (this.shouldFlushXMLWriter()) {
            writer.flush();
        }
        this.m_response.getWriter().write(this.m_xmlWriter.toCharArray());
        this.m_xmlWriter.reset();
    }

    protected FileInfo getWorkingCopy(NodeRef nodeRef) {
        String workingCopyOwner;
        FileInfo result = null;
        NodeRef workingCopy = this.getServiceRegistry().getCheckOutCheckInService().getWorkingCopy(nodeRef);
        if (workingCopy != null && (workingCopyOwner = this.getNodeService().getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_OWNER).toString()).equals(this.getAuthenticationService().getCurrentUserName())) {
            result = this.getFileFolderService().getFileInfo(workingCopy);
        }
        return result;
    }

    protected int getStatusForAccessDeniedException() {
        if (this.m_request != null && this.m_request.getHeader("User-Agent") != null) {
            String userAgent = this.m_request.getHeader("User-Agent");
            for (Map.Entry<String, Integer> entry : accessDeniedStatusCodes.entrySet()) {
                if (!Pattern.compile(entry.getKey()).matcher(userAgent).find()) continue;
                return entry.getValue();
            }
        }
        return 401;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_request != null) {
            sb.append("WebDAV ");
            sb.append(this.m_request.getMethod());
            sb.append(" request for ");
            sb.append(this.m_strPath);
        } else {
            sb.append("Inactive WebDAV request via ");
            String clz = this.getClass().getName();
            sb.append(clz.substring(clz.lastIndexOf(46) + 1));
        }
        return sb.toString();
    }

    protected String getSiteId() {
        if (this.siteId == null) {
            this.siteId = this.getDAVHelper().determineSiteId(this);
        }
        return this.siteId;
    }

    protected String getTenantDomain() {
        if (this.tenantDomain == null) {
            this.tenantDomain = this.getDAVHelper().determineTenantDomain(this);
        }
        return this.tenantDomain;
    }

    static {
        accessDeniedStatusCodes.put("^WebDAVLib/\\d+\\.\\d+(\\.\\d+)?$", 500);
        accessDeniedStatusCodes.put("^WebDAVFS/\\d+\\.\\d+(\\.\\d+)? \\(\\d+\\)\\s+Darwin/\\d+\\.\\d+(\\.\\d+)?\\s+\\(.*\\)$", 500);
        accessDeniedStatusCodes.put(".*", 403);
    }

    protected class Condition {
        private LinkedList<String> lockTokensMatch = new LinkedList();
        private LinkedList<String> lockTokensNotMatch = new LinkedList();
        private LinkedList<String> eTagsMatch;
        private LinkedList<String> eTagsNotMatch;

        public LinkedList<String> getLockTokensMatch() {
            return this.lockTokensMatch;
        }

        public LinkedList<String> getLockTokensNotMatch() {
            return this.lockTokensNotMatch;
        }

        public LinkedList<String> getETagsMatch() {
            return this.eTagsMatch;
        }

        public LinkedList<String> getETagsNotMatch() {
            return this.eTagsNotMatch;
        }

        public void addLockTocken(String lockToken, boolean notMatch) {
            if (notMatch) {
                this.lockTokensNotMatch.add(lockToken);
            } else {
                this.lockTokensMatch.add(lockToken);
            }
        }

        public void addETag(String eTag, boolean notMatch) {
            if (notMatch) {
                if (this.eTagsNotMatch == null) {
                    this.eTagsNotMatch = new LinkedList();
                }
                this.eTagsNotMatch.add(eTag);
            } else {
                if (this.eTagsMatch == null) {
                    this.eTagsMatch = new LinkedList();
                }
                this.eTagsMatch.add(eTag);
            }
        }
    }
}

