/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.auth.BaseAuthenticationFilter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HTTPRequestAuthenticationFilter
extends BaseAuthenticationFilter
implements Filter {
    private static Log logger = LogFactory.getLog(HTTPRequestAuthenticationFilter.class);
    private ServletContext m_context;
    private String httpServletRequestAuthHeaderName;
    private AuthenticationComponent m_authComponent;
    private String m_authPatternString = null;
    private Pattern m_authPattern = null;

    public void init(FilterConfig config) throws ServletException {
        this.m_context = config.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.m_context);
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.setNodeService(serviceRegistry.getNodeService());
        this.setAuthenticationService((AuthenticationService)serviceRegistry.getAuthenticationService());
        this.setTransactionService(serviceRegistry.getTransactionService());
        this.setPersonService((PersonService)ctx.getBean("PersonService"));
        this.m_authComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.httpServletRequestAuthHeaderName = config.getInitParameter("httpServletRequestAuthHeaderName");
        if (this.httpServletRequestAuthHeaderName == null) {
            this.httpServletRequestAuthHeaderName = "x-user";
        }
        this.m_authPatternString = config.getInitParameter("authPatternString");
        if (this.m_authPatternString != null) {
            try {
                this.m_authPattern = Pattern.compile(this.m_authPatternString);
            }
            catch (PatternSyntaxException e) {
                logger.warn((Object)("Invalid pattern: " + this.m_authPatternString), (Throwable)e);
                this.m_authPattern = null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        SessionUser user = (SessionUser)httpReq.getSession().getAttribute("_alfDAVAuthTicket");
        if (user == null) {
            String authHdr = httpReq.getHeader(this.httpServletRequestAuthHeaderName);
            if (logger.isTraceEnabled()) {
                if (authHdr == null) {
                    logger.trace((Object)("Header not found: " + this.httpServletRequestAuthHeaderName));
                } else {
                    logger.trace((Object)("Header is <" + authHdr + ">"));
                }
            }
            if (authHdr != null && authHdr.length() > 0) {
                String userName;
                block19: {
                    if (this.m_authPattern != null) {
                        Matcher matcher = this.m_authPattern.matcher(authHdr);
                        if (matcher.matches()) {
                            userName = matcher.group();
                            if (userName == null || userName.length() < 1) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Extracted null or empty user name from pattern " + this.m_authPatternString + " against " + authHdr));
                                }
                                this.reject(httpReq, httpResp);
                                return;
                            }
                            break block19;
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("no pattern match for " + this.m_authPatternString + " against " + authHdr));
                            }
                            this.reject(httpReq, httpResp);
                            return;
                        }
                    }
                    userName = authHdr;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("User = " + AuthenticationUtil.maskUsername((String)userName)));
                }
                user = (SessionUser)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SessionUser>(){

                    public SessionUser execute() throws Throwable {
                        try {
                            HTTPRequestAuthenticationFilter.this.m_authComponent.clearCurrentSecurityContext();
                            HTTPRequestAuthenticationFilter.this.m_authComponent.setCurrentUser(userName);
                            return HTTPRequestAuthenticationFilter.this.createUserEnvironment(httpReq.getSession(), userName, HTTPRequestAuthenticationFilter.this.authenticationService.getCurrentTicket(), true);
                        }
                        catch (AuthenticationException ex) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Failed", (Throwable)ex);
                            }
                            return null;
                        }
                    }
                });
            } else {
                String ticket = req.getParameter("ticket");
                if (ticket != null && ticket.length() > 0) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Logon via ticket from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + ":" + req.getRemotePort() + ") ticket=" + ticket));
                    }
                    try {
                        this.authenticationService.validate(ticket);
                        user = this.createUserEnvironment(httpReq.getSession(), this.authenticationService.getCurrentUserName(), ticket, true);
                    }
                    catch (AuthenticationException authErr) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Failed", (Throwable)authErr);
                        }
                        user = null;
                    }
                }
            }
            if (user == null) {
                this.reject(httpReq, httpResp);
                return;
            }
        }
        chain.doFilter(req, resp);
    }

    private void reject(HttpServletRequest httpReq, HttpServletResponse httpResp) throws IOException {
        httpResp.setHeader("WWW-Authenticate", "BASIC realm=\"Alfresco DAV Server\"");
        httpResp.setStatus(401);
        httpResp.flushBuffer();
    }

    public void destroy() {
    }

    @Override
    protected Log getLogger() {
        return logger;
    }
}

