/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.repo.web.auth.WebCredentials;
import org.alfresco.repo.webdav.auth.BaseKerberosAuthenticationFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KerberosAuthenticationFilter
extends BaseKerberosAuthenticationFilter {
    private static Log logger = LogFactory.getLog(KerberosAuthenticationFilter.class);

    @Override
    public String getLoginPageLink() {
        return this.loginPageLink;
    }

    @Override
    protected void onValidateFailed(ServletContext sc, HttpServletRequest req, HttpServletResponse res, HttpSession session, WebCredentials credentials) throws IOException {
        super.onValidateFailed(sc, req, res, session, credentials);
        this.restartLoginChallenge(sc, req, res);
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected boolean checkLoginPage(HttpServletRequest req, HttpServletResponse resp) {
        return req.getRequestURI().endsWith("/jsp/login.jsp");
    }

    @Override
    protected void writeLoginPageLink(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html");
        try (PrintWriter out = resp.getWriter();){
            out.println("<html><head>");
            out.println("</head><body><p>Login failed. Please try again.</p>");
            out.println("</body></html>");
        }
    }
}

