/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.web.scripts.TenantWebScriptServletRuntime;
import org.alfresco.rest.api.PublicApiTenantWebScriptServletRequest;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;

public class PublicApiTenantWebScriptServletRuntime
extends TenantWebScriptServletRuntime
implements ResponseWriter {
    private static final Pattern CMIS_URI_PATTERN = Pattern.compile(".*/cmis/versions/[0-9]+\\.[0-9]+/.*");
    private ApiAssistant apiAssistant;

    public PublicApiTenantWebScriptServletRuntime(RuntimeContainer container, ServletAuthenticatorFactory authFactory, HttpServletRequest req, HttpServletResponse res, ServerProperties serverProperties, ApiAssistant apiAssistant) {
        super(container, authFactory, req, res, serverProperties);
        this.apiAssistant = apiAssistant;
    }

    @Override
    protected String getScriptUrl() {
        int idx;
        String requestURI = this.req.getRequestURI();
        String serviceContextPath = this.req.getContextPath() + this.req.getServletPath();
        String pathInfo = serviceContextPath.length() > requestURI.length() ? this.req.getPathInfo() : (CMIS_URI_PATTERN.matcher(requestURI).matches() ? requestURI.substring(serviceContextPath.length()) : URLDecoder.decode((String)requestURI.substring(serviceContextPath.length())));
        if (pathInfo.length() < 2 || pathInfo.equals("/")) {
            pathInfo = "networks";
        } else if (!pathInfo.substring(0, 6).toLowerCase().equals("/cmis/") && !pathInfo.equals("/discovery") && ((pathInfo = pathInfo.substring((idx = pathInfo.indexOf(47, 1)) == -1 ? pathInfo.length() : idx)).equals("") || pathInfo.equals("/"))) {
            pathInfo = "network";
        }
        return pathInfo;
    }

    @Override
    protected WebScriptRequest createRequest(Match match) {
        this.servletReq = new PublicApiTenantWebScriptServletRequest((Runtime)this, this.req, match, this.serverProperties);
        return this.servletReq;
    }

    @Override
    public String getName() {
        return "PublicApiTenantServletRuntime";
    }

    protected void renderErrorResponse(Match match, Throwable exception, WebScriptRequest request, WebScriptResponse response) {
        if (CMIS_URI_PATTERN.matcher(this.req.getRequestURI()).matches() || !(exception instanceof Exception)) {
            super.renderErrorResponse(match, exception, request, response);
        } else {
            try {
                this.renderException((Exception)exception, response, this.apiAssistant);
            }
            catch (IOException e) {
                logger.error((Object)"Internal error", (Throwable)e);
                throw new WebScriptException("Internal error", (Throwable)e);
            }
        }
    }
}

