/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.alfresco.heartbeat.RenditionsDataCollector;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.repo.rendition2.RenditionService2;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.thumbnail.script.ScriptThumbnailService;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.Renditions;
import org.alfresco.rest.api.impl.NodesImpl;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.ContentInfo;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.StaleEntityException;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.content.CacheDirective;
import org.alfresco.rest.framework.resource.content.ContentInfoImpl;
import org.alfresco.rest.framework.resource.content.FileBinaryResource;
import org.alfresco.rest.framework.resource.content.NodeBinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionDoesNotExistException;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class RenditionsImpl
implements Renditions,
ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(RenditionsImpl.class);
    private static final Set<String> RENDITION_STATUS_COLLECTION_EQUALS_QUERY_PROPERTIES = Collections.singleton("status");
    private Nodes nodes;
    private NodeService nodeService;
    private ScriptThumbnailService scriptThumbnailService;
    private MimetypeService mimetypeService;
    private ServiceRegistry serviceRegistry;
    private ResourceLoader resourceLoader;
    private TenantService tenantService;
    private RenditionService2 renditionService2;
    private RenditionsDataCollector renditionsDataCollector;
    private VersionService versionService;

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setScriptThumbnailService(ScriptThumbnailService scriptThumbnailService) {
        this.scriptThumbnailService = scriptThumbnailService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setRenditionService2(RenditionService2 renditionService2) {
        this.renditionService2 = renditionService2;
    }

    public void setRenditionsDataCollector(RenditionsDataCollector renditionsDataCollector) {
        this.renditionsDataCollector = renditionsDataCollector;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodes", (Object)this.nodes);
        PropertyCheck.mandatory((Object)this, (String)"scriptThumbnailService", (Object)this.scriptThumbnailService);
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"renditionService2", (Object)this.renditionService2);
        PropertyCheck.mandatory((Object)this, (String)"renditionsDataCollector", (Object)((Object)this.renditionsDataCollector));
        this.nodeService = this.serviceRegistry.getNodeService();
        this.versionService = this.serviceRegistry.getVersionService();
        this.mimetypeService = this.serviceRegistry.getMimetypeService();
    }

    @Override
    public CollectionWithPagingInfo<Rendition> getRenditions(NodeRef nodeRef, Parameters parameters) {
        return this.getRenditions(nodeRef, null, parameters);
    }

    @Override
    public CollectionWithPagingInfo<Rendition> getRenditions(NodeRef nodeRef, String versionLabelId, Parameters parameters) {
        List nodeRefRenditions;
        NodeRef validatedNodeRef = this.validateNode(nodeRef.getStoreRef(), nodeRef.getId(), versionLabelId, parameters);
        ContentData contentData = this.getContentData(validatedNodeRef, true);
        String sourceMimetype = contentData.getMimetype();
        boolean includeCreated = true;
        boolean includeNotCreated = true;
        String status = this.getStatus(parameters);
        if (status != null) {
            includeCreated = Rendition.RenditionStatus.CREATED.equals((Object)Rendition.RenditionStatus.valueOf(status));
            includeNotCreated = !includeCreated;
        }
        long size = contentData.getSize();
        RenditionDefinitionRegistry2 renditionDefinitionRegistry2 = this.renditionService2.getRenditionDefinitionRegistry2();
        Set renditionNames = renditionDefinitionRegistry2.getRenditionNamesFrom(sourceMimetype, size);
        TreeMap<Object, Rendition> apiRenditions = new TreeMap<Object, Rendition>();
        if (includeNotCreated) {
            for (Object renditionName : renditionNames) {
                apiRenditions.put(renditionName, this.toApiRendition((String)renditionName));
            }
        }
        if (!(nodeRefRenditions = this.renditionService2.getRenditions(validatedNodeRef)).isEmpty()) {
            for (ChildAssociationRef childAssociationRef : nodeRefRenditions) {
                NodeRef renditionNodeRef = childAssociationRef.getChildRef();
                Rendition apiRendition = this.toApiRendition(renditionNodeRef);
                String renditionName = apiRendition.getId();
                if (renditionNames.contains(renditionName)) {
                    if (includeCreated) {
                        apiRenditions.put(renditionName, apiRendition);
                        continue;
                    }
                    apiRenditions.remove(renditionName);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Skip unknown rendition [" + renditionName + ", " + String.valueOf(renditionNodeRef) + "]"));
            }
        }
        Paging paging = parameters.getPaging();
        PagingResults results = Util.wrapPagingResults(paging, apiRenditions.values());
        return CollectionWithPagingInfo.asPaged(paging, results.getPage(), results.hasMoreItems(), (Integer)results.getTotalResultCount().getFirst());
    }

    @Override
    public Rendition getRendition(NodeRef nodeRef, String renditionId, Parameters parameters) {
        return this.getRendition(nodeRef, null, renditionId, parameters);
    }

    @Override
    public Rendition getRendition(NodeRef nodeRef, String versionLabelId, String renditionId, Parameters parameters) {
        NodeRef validatedNodeRef = this.validateNode(nodeRef.getStoreRef(), nodeRef.getId(), versionLabelId, parameters);
        NodeRef renditionNodeRef = this.getRenditionByName(validatedNodeRef, renditionId, parameters);
        boolean includeNotCreated = true;
        String status = this.getStatus(parameters);
        if (status != null) {
            boolean bl = includeNotCreated = !Rendition.RenditionStatus.CREATED.equals((Object)Rendition.RenditionStatus.valueOf(status));
        }
        if (renditionNodeRef == null && includeNotCreated) {
            ContentData contentData = this.getContentData(validatedNodeRef, true);
            String sourceMimetype = contentData.getMimetype();
            long size = contentData.getSize();
            RenditionDefinitionRegistry2 renditionDefinitionRegistry2 = this.renditionService2.getRenditionDefinitionRegistry2();
            RenditionDefinition2 renditionDefinition = renditionDefinitionRegistry2.getRenditionDefinition(renditionId);
            if (renditionDefinition == null) {
                throw new NotFoundException(renditionId + " is not registered.");
            }
            Set renditionNames = renditionDefinitionRegistry2.getRenditionNamesFrom(sourceMimetype, size);
            boolean found = false;
            for (String renditionName : renditionNames) {
                if (!renditionId.equals(renditionName)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new NotFoundException(renditionId + " is not applicable for the node's mimeType " + sourceMimetype);
            }
            return this.toApiRendition(renditionId);
        }
        if (renditionNodeRef == null) {
            throw new NotFoundException("The rendition with id: " + renditionId + " was not found.");
        }
        return this.toApiRendition(renditionNodeRef);
    }

    @Override
    public void createRendition(NodeRef nodeRef, Rendition rendition, Parameters parameters) {
        this.createRendition(nodeRef, rendition, true, parameters);
    }

    @Override
    public void createRendition(NodeRef nodeRef, Rendition rendition, boolean executeAsync, Parameters parameters) {
        this.createRendition(nodeRef, null, rendition, executeAsync, parameters);
    }

    @Override
    public void createRendition(NodeRef nodeRef, String versionLabelId, Rendition rendition, boolean executeAsync, Parameters parameters) {
        if (!this.renditionService2.isEnabled()) {
            throw new DisabledServiceException("Rendition generation has been disabled.");
        }
        NodeRef sourceNodeRef = this.validateNode(nodeRef.getStoreRef(), nodeRef.getId(), versionLabelId, parameters);
        NodeRef renditionNodeRef = this.getRenditionByName(sourceNodeRef, rendition.getId(), parameters);
        if (renditionNodeRef != null) {
            throw new ConstraintViolatedException(rendition.getId() + " rendition already exists.");
        }
        try {
            this.renditionService2.render(sourceNodeRef, rendition.getId());
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(rendition.getId() + " is not registered.");
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new StaleEntityException(e.getMessage());
        }
    }

    @Override
    public void createRenditions(NodeRef nodeRef, List<Rendition> renditions, Parameters parameters) throws NotFoundException, ConstraintViolatedException {
        this.createRenditions(nodeRef, null, renditions, parameters);
    }

    @Override
    public void createRenditions(NodeRef nodeRef, String versionLabelId, List<Rendition> renditions, Parameters parameters) throws NotFoundException, ConstraintViolatedException {
        if (renditions.isEmpty()) {
            return;
        }
        if (!this.renditionService2.isEnabled()) {
            throw new DisabledServiceException("Rendition generation has been disabled.");
        }
        NodeRef sourceNodeRef = this.validateNode(nodeRef.getStoreRef(), nodeRef.getId(), versionLabelId, parameters);
        RenditionDefinitionRegistry2 renditionDefinitionRegistry2 = this.renditionService2.getRenditionDefinitionRegistry2();
        HashSet<String> renditionNames = new HashSet<String>();
        for (Rendition rendition : renditions) {
            String name = this.getName(rendition);
            Set<String> requestedRenditions = NodesImpl.getRequestedRenditions(name);
            if (requestedRenditions == null) {
                renditionNames.add(null);
                continue;
            }
            renditionNames.addAll(requestedRenditions);
        }
        StringJoiner renditionNamesAlreadyExist = new StringJoiner(",");
        StringJoiner renditionNamesNotRegistered = new StringJoiner(",");
        ArrayList<String> renditionNamesToCreate = new ArrayList<String>();
        for (String renditionName : renditionNames) {
            NodeRef renditionNodeRef;
            if (renditionName == null) {
                throw new IllegalArgumentException("Null rendition name supplied");
            }
            RenditionDefinition2 renditionDefinition = renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
            if (renditionDefinition == null) {
                renditionNamesNotRegistered.add(renditionName);
            }
            if ((renditionNodeRef = this.getRenditionByName(sourceNodeRef, renditionName, parameters)) == null) {
                renditionNamesToCreate.add(renditionName);
                continue;
            }
            renditionNamesAlreadyExist.add(renditionName);
        }
        if (renditionNamesNotRegistered.length() != 0) {
            throw new NotFoundException("Renditions not registered: " + String.valueOf(renditionNamesNotRegistered));
        }
        if (renditionNamesToCreate.size() == 0) {
            throw new ConstraintViolatedException("All renditions requested already exist: " + String.valueOf(renditionNamesAlreadyExist));
        }
        for (String renditionName : renditionNamesToCreate) {
            try {
                this.renditionService2.render(sourceNodeRef, renditionName);
            }
            catch (UnsupportedOperationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (IllegalStateException e) {
                throw new StaleEntityException(e.getMessage());
            }
        }
    }

    @Override
    public void deleteRendition(NodeRef nodeRef, String renditionId, Parameters parameters) {
        this.deleteRendition(nodeRef, null, renditionId, parameters);
    }

    @Override
    public void deleteRendition(NodeRef nodeRef, String versionId, String renditionId, Parameters parameters) {
        if (!this.renditionService2.isEnabled()) {
            throw new DisabledServiceException("Rendition generation has been disabled.");
        }
        NodeRef validatedNodeRef = this.validateNode(nodeRef.getStoreRef(), nodeRef.getId(), versionId, parameters);
        NodeRef renditionNodeRef = this.getRenditionByName(validatedNodeRef, renditionId, parameters);
        if (renditionNodeRef == null) {
            throw new NotFoundException(renditionId + " is not registered.");
        }
        this.renditionService2.clearRenditionContentDataInTransaction(renditionNodeRef);
    }

    private String getName(Rendition rendition) {
        String renditionName = rendition.getId();
        if (renditionName != null && (renditionName = renditionName.trim()).isEmpty()) {
            renditionName = null;
        }
        return renditionName;
    }

    @Override
    public BinaryResource getContent(NodeRef nodeRef, String renditionId, Parameters parameters) {
        return this.getContent(nodeRef, null, renditionId, parameters);
    }

    @Override
    public BinaryResource getContent(NodeRef nodeRef, String versionLabelId, String renditionId, Parameters parameters) {
        NodeRef validatedNodeRef = this.validateNode(nodeRef.getStoreRef(), nodeRef.getId(), versionLabelId, parameters);
        return this.getContentImpl(validatedNodeRef, renditionId, parameters);
    }

    @Override
    public BinaryResource getContentNoValidation(NodeRef nodeRef, String renditionId, Parameters parameters) {
        return this.getContentNoValidation(nodeRef, null, renditionId, parameters);
    }

    @Override
    public BinaryResource getContentNoValidation(NodeRef nodeRef, String versionLabelId, String renditionId, Parameters parameters) {
        nodeRef = this.findVersionIfApplicable(nodeRef, versionLabelId);
        return this.getContentImpl(nodeRef, renditionId, parameters);
    }

    @Override
    public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, String versionId, String renditionId, boolean attachment, Long validFor) {
        NodeRef validatedNodeRef = this.validateNode(nodeRef.getStoreRef(), nodeRef.getId(), versionId, null);
        NodeRef renditionNodeRef = this.getRenditionByName(validatedNodeRef, renditionId, null);
        if (renditionNodeRef == null) {
            throw new NotFoundException("The rendition with id: " + renditionId + " was not found.");
        }
        return this.nodes.requestContentDirectUrl(renditionNodeRef, attachment, validFor);
    }

    private BinaryResource getContentImpl(NodeRef nodeRef, String renditionId, Parameters parameters) {
        String attachFileName;
        NodeRef renditionNodeRef = this.getRenditionByName(nodeRef, renditionId, parameters);
        boolean attach = true;
        String attachment = parameters.getParameter("attachment");
        if (attachment != null) {
            attach = Boolean.valueOf(attachment);
        }
        String string = attachFileName = attach ? renditionId : null;
        if (renditionNodeRef == null) {
            boolean isPlaceholder = Boolean.valueOf(parameters.getParameter("placeholder"));
            if (!isPlaceholder) {
                throw new NotFoundException("Thumbnail was not found for [" + renditionId + "]");
            }
            String sourceNodeMimeType = null;
            try {
                sourceNodeMimeType = nodeRef != null ? this.getMimeType(nodeRef) : null;
            }
            catch (InvalidArgumentException invalidArgumentException) {
                // empty catch block
            }
            String phPath = this.scriptThumbnailService.getMimeAwarePlaceHolderResourcePath(renditionId, sourceNodeMimeType);
            if (phPath == null) {
                throw new NotFoundException("Thumbnail was not found and no placeholder resource available for [" + renditionId + "]");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieving content from resource path [" + phPath + "]"));
            }
            String ext = "";
            int extIndex = phPath.lastIndexOf(46);
            if (extIndex != -1) {
                ext = phPath.substring(extIndex);
            }
            try {
                String resourcePath = "classpath:" + phPath;
                InputStream inputStream = this.resourceLoader.getResource(resourcePath).getInputStream();
                File file = TempFileProvider.createTempFile((InputStream)inputStream, (String)"RenditionsApi-", (String)ext);
                return new FileBinaryResource(file, attachFileName);
            }
            catch (Exception ex) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Couldn't load the placeholder." + ex.getMessage()));
                }
                throw new ApiException("Couldn't load the placeholder.");
            }
        }
        Map nodeProps = this.nodeService.getProperties(renditionNodeRef);
        ContentData contentData = (ContentData)nodeProps.get(ContentModel.PROP_CONTENT);
        Date modified = (Date)nodeProps.get(ContentModel.PROP_MODIFIED);
        ContentInfoImpl contentInfo = null;
        if (contentData != null) {
            contentInfo = new ContentInfoImpl(contentData.getMimetype(), contentData.getEncoding(), contentData.getSize(), contentData.getLocale());
        }
        CacheDirective cacheDirective = new CacheDirective.Builder().setNeverCache(false).setMustRevalidate(false).setLastModified(modified).setETag(modified != null ? Long.toString(modified.getTime()) : null).setMaxAge(31536000L).build();
        return new NodeBinaryResource(renditionNodeRef, ContentModel.PROP_CONTENT, contentInfo, attachFileName, cacheDirective);
    }

    protected NodeRef getRenditionByName(NodeRef nodeRef, String renditionId, Parameters parameters) {
        if (nodeRef != null) {
            ContentData contentData;
            if (StringUtils.isEmpty((CharSequence)renditionId)) {
                throw new InvalidArgumentException("renditionId can't be null or empty.");
            }
            ChildAssociationRef nodeRefRendition = this.renditionService2.getRenditionByName(nodeRef, renditionId);
            if (nodeRefRendition != null && (contentData = this.getContentData(nodeRefRendition.getChildRef(), false)) != null) {
                return this.tenantService.getName(nodeRef, nodeRefRendition.getChildRef());
            }
        }
        return null;
    }

    protected Rendition toApiRendition(NodeRef renditionNodeRef) {
        Rendition apiRendition = new Rendition();
        String renditionName = (String)((Object)this.nodeService.getProperty(renditionNodeRef, ContentModel.PROP_NAME));
        apiRendition.setId(renditionName);
        ContentData contentData = this.getContentData(renditionNodeRef, false);
        ContentInfo contentInfo = null;
        if (contentData != null) {
            contentInfo = new ContentInfo(contentData.getMimetype(), this.getMimeTypeDisplayName(contentData.getMimetype()), contentData.getSize(), contentData.getEncoding());
        }
        apiRendition.setContent(contentInfo);
        apiRendition.setStatus(Rendition.RenditionStatus.CREATED);
        return apiRendition;
    }

    protected Rendition toApiRendition(String renditionName) {
        RenditionDefinitionRegistry2 renditionDefinitionRegistry2 = this.renditionService2.getRenditionDefinitionRegistry2();
        RenditionDefinition2 renditionDefinition = renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
        ContentInfo contentInfo = new ContentInfo(renditionDefinition.getTargetMimetype(), this.getMimeTypeDisplayName(renditionDefinition.getTargetMimetype()), null, null);
        Rendition apiRendition = new Rendition();
        apiRendition.setId(renditionName);
        apiRendition.setContent(contentInfo);
        apiRendition.setStatus(Rendition.RenditionStatus.NOT_CREATED);
        return apiRendition;
    }

    private NodeRef validateNode(StoreRef storeRef, String nodeId, String versionLabelId, Parameters parameters) {
        if (nodeId == null) {
            throw new InvalidArgumentException("Missing nodeId");
        }
        NodeRef nodeRef = this.nodes.validateNode(storeRef, nodeId);
        this.isContentFile(nodeRef);
        nodeRef = this.findVersionIfApplicable(nodeRef, versionLabelId);
        return nodeRef;
    }

    private NodeRef findVersionIfApplicable(NodeRef nodeRef, String versionLabelId) {
        VersionHistory vh;
        if (versionLabelId != null && (vh = this.versionService.getVersionHistory(nodeRef = this.nodes.validateOrLookupNode(nodeRef.getId(), null))) != null) {
            try {
                Version version = vh.getVersion(versionLabelId);
                nodeRef = VersionUtil.convertNodeRef((NodeRef)version.getFrozenStateNodeRef());
            }
            catch (VersionDoesNotExistException vdne) {
                throw new NotFoundException("Couldn't find version: [" + nodeRef.getId() + ", " + versionLabelId + "]");
            }
        }
        return nodeRef;
    }

    private void isContentFile(NodeRef nodeRef) {
        if (!this.nodes.isSubClass(nodeRef, ContentModel.PROP_CONTENT, false)) {
            throw new InvalidArgumentException("Node id '" + nodeRef.getId() + "' does not represent a file.");
        }
    }

    private String getMimeTypeDisplayName(String mimeType) {
        return (String)this.mimetypeService.getDisplaysByMimetype().get(mimeType);
    }

    private ContentData getContentData(NodeRef nodeRef, boolean validate) {
        ContentData contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
        if (validate && !ContentData.hasContent((ContentData)contentData)) {
            throw new InvalidArgumentException("Node id '" + nodeRef.getId() + "' has no content.");
        }
        return contentData;
    }

    private String getMimeType(NodeRef nodeRef) {
        ContentData contentData = this.getContentData(nodeRef, true);
        return contentData.getMimetype();
    }

    private String getStatus(Parameters parameters) {
        Query query = parameters.getQuery();
        String status = null;
        if (query != null) {
            MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(RENDITION_STATUS_COLLECTION_EQUALS_QUERY_PROPERTIES, null);
            QueryHelper.walk(query, propertyWalker);
            status = propertyWalker.getProperty("status", 8);
        }
        return status;
    }
}

