/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.webscripts;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.framework.core.OperationResourceMetaData;
import org.alfresco.rest.framework.core.ResourceInspectorUtil;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.DeletedResourceException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartRelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.framework.tools.RequestReader;
import org.alfresco.rest.framework.webscripts.AbstractResourceWebScript;
import org.alfresco.rest.framework.webscripts.ParamsExtractor;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.servlet.FormData;
import org.springframework.http.HttpMethod;

public class ResourceWebScriptPost
extends AbstractResourceWebScript
implements ParamsExtractor,
RecognizedParamsExtractor,
RequestReader {
    public ResourceWebScriptPost() {
        this.setHttpMethod(HttpMethod.POST);
        this.setParamsExtractor(this);
    }

    @Override
    public Params extractParams(ResourceMetadata resourceMeta, WebScriptRequest req) {
        Map<String, String> resourceVars = this.locator.parseTemplateVars(req.getServiceMatch().getTemplateVars());
        String entityId = resourceVars.get("entityId");
        String relationshipId = resourceVars.get("relationshipId");
        String operationName = resourceVars.get("relationResource");
        String propertyName = resourceVars.get("property");
        String relationship2Id = resourceVars.get("relationship2Id");
        Params.RecognizedParams params = this.getRecognizedParams(req);
        ResourceOperation operation = resourceMeta.getOperation(HttpMethod.POST);
        switch (resourceMeta.getType()) {
            case ENTITY: {
                if (StringUtils.isNotBlank((CharSequence)entityId)) {
                    throw new UnsupportedResourceOperationException("POST is executed against a collection URL");
                }
                Object postedObj = this.processRequest(resourceMeta, operation, req);
                return Params.valueOf(null, params, postedObj, req);
            }
            case RELATIONSHIP: {
                if (StringUtils.isNotBlank((CharSequence)propertyName) && StringUtils.isNotBlank((CharSequence)relationshipId)) {
                    Object postedRel = this.processRequest(resourceMeta, operation, req);
                    return Params.valueOf(true, entityId, relationshipId, null, postedRel, null, null, params, null, req);
                }
                if (StringUtils.isNotBlank((CharSequence)relationshipId)) {
                    throw new UnsupportedResourceOperationException("POST is executed against a collection URL");
                }
                Object postedRel = this.processRequest(resourceMeta, operation, req);
                return Params.valueOf(entityId, params, postedRel, req);
            }
            case OPERATION: {
                if (!StringUtils.isNotBlank((CharSequence)entityId) || !StringUtils.isNotBlank((CharSequence)operationName)) break;
                Object postedObj = this.processRequest(resourceMeta, operation, req);
                if (StringUtils.isNotBlank((CharSequence)propertyName)) {
                    return Params.valueOf(false, entityId, relationshipId, relationship2Id, postedObj, null, propertyName, params, null, req);
                }
                return Params.valueOf(entityId, params, postedObj, req);
            }
        }
        throw new UnsupportedResourceOperationException("POST not supported for Actions");
    }

    private Object processRequest(ResourceMetadata resourceMeta, ResourceOperation operation, WebScriptRequest req) {
        if ("multipart/form-data".equals(req.getContentType())) {
            return (FormData)req.parseContent();
        }
        return this.extractObjFromJson(resourceMeta, operation, req);
    }

    private Object extractObjFromJson(ResourceMetadata resourceMeta, ResourceOperation operation, WebScriptRequest req) {
        if (operation == null) {
            return null;
        }
        Class objType = resourceMeta.getObjectType(operation);
        boolean isTypeOperation = resourceMeta.getType().equals((Object)ResourceMetadata.RESOURCE_TYPE.OPERATION);
        List<ResourceParameter> params = operation.getParameters();
        if (!params.isEmpty()) {
            for (ResourceParameter resourceParameter : params) {
                boolean notMultiple;
                boolean bl = notMultiple = !resourceParameter.isAllowMultiple() || isTypeOperation;
                if (!ResourceParameter.KIND.HTTP_BODY_OBJECT.equals((Object)resourceParameter.getParamType()) || !notMultiple) continue;
                try {
                    Object jsonContent = null;
                    if (objType != null) {
                        if (!resourceParameter.isRequired() && Integer.valueOf(req.getHeader("content-length")) <= 0) {
                            return null;
                        }
                        jsonContent = this.extractJsonContent(req, this.assistant.getJsonHelper(), objType);
                    }
                    if (isTypeOperation) {
                        return jsonContent;
                    }
                    return Arrays.asList(jsonContent);
                }
                catch (InvalidArgumentException iae) {
                    if (iae.getMessage().contains("START_ARRAY") && iae.getMessage().contains("line: 1, column: 1")) {
                        throw new UnsupportedResourceOperationException("Only 1 entity is supported in the HTTP request body");
                    }
                    throw iae;
                }
            }
        }
        if (objType == null) {
            return null;
        }
        if (isTypeOperation) {
            return this.extractJsonContent(req, this.assistant.getJsonHelper(), objType);
        }
        return this.extractJsonContentAsList(req, this.assistant.getJsonHelper(), objType);
    }

    private Object executeOperation(ResourceWithMetadata resource, Params params, WithResponse withResponse) throws Throwable {
        OperationResourceMetaData operationResourceMetaData = (OperationResourceMetaData)resource.getMetaData();
        switch (operationResourceMetaData.getOperationMethod().getParameterTypes().length) {
            case 4: {
                return ResourceInspectorUtil.invokeMethod(operationResourceMetaData.getOperationMethod(), resource.getResource(), params.getEntityId(), params.getPassedIn(), params, withResponse);
            }
            case 5: {
                return ResourceInspectorUtil.invokeMethod(operationResourceMetaData.getOperationMethod(), resource.getResource(), params.getEntityId(), params.getRelationshipId(), params.getPassedIn(), params, withResponse);
            }
        }
        throw new UnsupportedResourceOperationException("The operation method has an invalid signature");
    }

    @Override
    public Object executeAction(ResourceWithMetadata resource, Params params, WithResponse withResponse) throws Throwable {
        Object resObj = resource.getResource();
        switch (resource.getMetaData().getType()) {
            case ENTITY: {
                if (resObj instanceof MultiPartResourceAction.Create && params.getPassedIn() instanceof FormData) {
                    MultiPartResourceAction.Create creator = (MultiPartResourceAction.Create)resObj;
                    return creator.create((FormData)params.getPassedIn(), params, withResponse);
                }
                if (EntityResourceAction.Create.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(EntityResourceAction.Create.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    EntityResourceAction.Create creator = (EntityResourceAction.Create)resObj;
                    List<Object> created = creator.create((List)params.getPassedIn(), params);
                    if (created != null && created.size() == 1) {
                        return created.get(0);
                    }
                    return this.wrapWithCollectionWithPaging(created);
                }
                if (EntityResourceAction.CreateWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(EntityResourceAction.CreateWithResponse.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    EntityResourceAction.CreateWithResponse creator = (EntityResourceAction.CreateWithResponse)resObj;
                    List<Object> created = creator.create((List)params.getPassedIn(), params, withResponse);
                    if (created != null && created.size() == 1) {
                        return created.get(0);
                    }
                    return this.wrapWithCollectionWithPaging(created);
                }
            }
            case RELATIONSHIP: {
                if (resObj instanceof MultiPartRelationshipResourceAction.Create && params.getPassedIn() instanceof FormData) {
                    MultiPartRelationshipResourceAction.Create creator = (MultiPartRelationshipResourceAction.Create)resObj;
                    return creator.create(params.getEntityId(), (FormData)params.getPassedIn(), params, withResponse);
                }
                if (RelationshipResourceAction.Create.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.Create.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    RelationshipResourceAction.Create createRelation = (RelationshipResourceAction.Create)resource.getResource();
                    List<Object> createdRel = createRelation.create(params.getEntityId(), (List)params.getPassedIn(), params);
                    if (createdRel != null && createdRel.size() == 1) {
                        return createdRel.get(0);
                    }
                    return this.wrapWithCollectionWithPaging(createdRel);
                }
                if (RelationshipResourceAction.CreateWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.CreateWithResponse.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    RelationshipResourceAction.CreateWithResponse createRelation = (RelationshipResourceAction.CreateWithResponse)resource.getResource();
                    List<Object> createdRel = createRelation.create(params.getEntityId(), (List)params.getPassedIn(), params, withResponse);
                    if (createdRel != null && createdRel.size() == 1) {
                        return createdRel.get(0);
                    }
                    return this.wrapWithCollectionWithPaging(createdRel);
                }
            }
            case OPERATION: {
                return this.executeOperation(resource, params, withResponse);
            }
        }
        throw new UnsupportedResourceOperationException("POST not supported for Actions");
    }

    private Object wrapWithCollectionWithPaging(List<Object> created) {
        if (created != null && created.size() > 1) {
            return CollectionWithPagingInfo.asPagedCollection(created.toArray());
        }
        return created;
    }
}

