/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.lookups;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.rest.api.lookups.PropertyLookup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyLookupRegistry {
    private static Log logger = LogFactory.getLog(PropertyLookupRegistry.class);
    Map<String, PropertyLookup> propertyLookups = new HashMap<String, PropertyLookup>();

    public void setLookups(List<PropertyLookup> lookups) {
        lookups.forEach(entry -> entry.supports().forEach(propKey -> this.propertyLookups.put((String)propKey, (PropertyLookup)entry)));
    }

    public Set<String> supports() {
        return this.propertyLookups.keySet();
    }

    public Object lookup(String propertyName, String propertyValue) {
        PropertyLookup lookup = this.propertyLookups.get(propertyName);
        if (lookup != null) {
            return lookup.lookup(propertyValue);
        }
        return null;
    }
}

