/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.DefaultExceptionResolver;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.ErrorResponse;
import org.alfresco.rest.framework.core.exceptions.SimpleMappingExceptionResolver;
import org.alfresco.rest.framework.jacksonextensions.ExecutionResult;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tests.api.mocks.CowEntityResource;
import org.alfresco.rest.framework.tests.api.mocks.Goat;
import org.alfresco.rest.framework.tests.api.mocks.Grass;
import org.alfresco.rest.framework.tests.api.mocks.Sheep;
import org.alfresco.rest.framework.tests.core.AbstractContextTest;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.rest.framework.webscripts.AbstractResourceWebScript;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.http.HttpMethod;

public class ExecutionTests
extends AbstractContextTest
implements ResponseWriter {
    static final Api api3 = Api.valueOf((String)"alfrescomock", (String)"private", (String)"3");
    @Autowired
    SimpleMappingExceptionResolver simpleMappingExceptionResolver;

    @Test
    public void testInvokeGet() throws IOException {
        ResourceWithMetadata entityResource = this.locator.locateEntityResource(api, "sheep", HttpMethod.GET);
        AbstractResourceWebScript executor = this.getExecutor();
        Object result = executor.execute(entityResource, Params.valueOf((String)null, null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), true);
        Assert.assertNotNull((Object)result);
        WebScriptResponse response = (WebScriptResponse)Mockito.mock(WebScriptResponse.class);
        entityResource = this.locator.locateEntityResource(api, "cow", HttpMethod.GET);
        result = executor.execute(entityResource, Params.valueOf((String)null, null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), response, true);
        Assert.assertNotNull((Object)result);
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setCache(ResponseWriter.CACHE_NEVER);
        response = (WebScriptResponse)Mockito.mock(WebScriptResponse.class);
        result = executor.execute(entityResource, Params.valueOf((String)"543", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), response, true);
        Assert.assertNotNull((Object)result);
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setCache(CowEntityResource.CACHE_COW);
        ResourceWithMetadata baa = this.locator.locateRelationResource(api, "sheep", "baaahh", HttpMethod.GET);
        result = executor.execute(baa, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), true);
        Assert.assertNotNull((Object)result);
        executor.execute(baa, Params.valueOf((String)"4", (String)"45", (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), true);
        Assert.assertNotNull((Object)result);
        ResourceWithMetadata cowResource = this.locator.locateRelationResource(api, "cow", "photo", HttpMethod.GET);
        result = executor.execute(cowResource, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), true);
        Assert.assertNull((Object)result);
        ResourceWithMetadata calf = this.locator.locateRelationResource(api, "cow", "calf", HttpMethod.GET);
        result = executor.execute(calf, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), true);
        Assert.assertNotNull((Object)result);
        executor.execute(calf, Params.valueOf((String)"4", (String)"45", (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), true);
        Assert.assertNotNull((Object)result);
        calf = this.locator.locateRelationResource(api, "cow/{entityId}/calf", "photo", HttpMethod.GET);
        executor.execute(calf, Params.valueOf((String)"4", (String)"45", (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), true);
        Assert.assertNotNull((Object)result);
        ResourceWithMetadata baaPhoto = this.locator.locateRelationResource(api, "sheep/{entityId}/baaahh", "photo", HttpMethod.GET);
        executor.execute(baaPhoto, Params.valueOf((String)"4", (String)"45", (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), true);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testInvokePost() throws IOException {
        AbstractResourceWebScript executor = this.getExecutor("executorOfPost");
        ResourceWithMetadata resource = this.locator.locateRelationResource(api, "sheep", "blacksheep", HttpMethod.POST);
        Sheep aSheep = new Sheep("xyz");
        Object result = executor.execute(resource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, Arrays.asList(aSheep), (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)aSheep, (Object)((ExecutionResult)result).getRoot());
        ResourceWithMetadata grassResource = this.locator.locateEntityResource(api, "grass", HttpMethod.POST);
        Grass grr = new Grass("grr");
        result = executor.execute(grassResource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, Arrays.asList(grr), (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertEquals((Object)grr, (Object)((ExecutionResult)result).getRoot());
        Goat goat = new Goat("xyz");
        ResourceWithMetadata cowresource = this.locator.locateEntityResource(api, "cow", HttpMethod.POST);
        WebScriptResponse response = (WebScriptResponse)Mockito.mock(WebScriptResponse.class);
        result = executor.execute(cowresource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, Arrays.asList(goat), (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), response, false);
        Assert.assertEquals((Object)goat, (Object)((ExecutionResult)result).getRoot());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setStatus(202);
        ResourceWithMetadata entityResource = this.locator.locateRelationResource(api, "grass", "grow", HttpMethod.POST);
        result = executor.execute(entityResource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, (Object)grr, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertEquals((Object)"Growing well", (Object)result);
        ResourceWithMetadata calfResource = this.locator.locateRelationResource(api, "cow", "calf", HttpMethod.POST);
        result = executor.execute(calfResource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, Arrays.asList(goat), (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertEquals((Object)goat, (Object)((ExecutionResult)result).getRoot());
        HashMap<String, String> templateVars = new HashMap<String, String>();
        templateVars.put("collectionResource", "sheep");
        templateVars.put("entityId", "sheepId");
        templateVars.put("relationResource", "baaahh");
        templateVars.put("property", "chew");
        ResourceWithMetadata collResource = this.locator.locateResource(api, templateVars, HttpMethod.POST);
        result = executor.execute(collResource, Params.valueOf((String)"654", (String)"345", (Params.RecognizedParams)NULL_PARAMS, null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertEquals((Object)"All done", (Object)result);
    }

    @Test
    public void testInvokeDelete() throws IOException {
        ResourceWithMetadata grassResource = this.locator.locateEntityResource(api, "grass", HttpMethod.DELETE);
        AbstractResourceWebScript executor = this.getExecutor("executorOfDelete");
        Object result = executor.execute(grassResource, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        ResourceWithMetadata cowResource = this.locator.locateEntityResource(api, "cow", HttpMethod.DELETE);
        result = executor.execute(cowResource, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        cowResource = this.locator.locateRelationResource(api, "cow", "photo", HttpMethod.DELETE);
        result = executor.execute(cowResource, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        ResourceWithMetadata resource = this.locator.locateRelationResource(api, "sheep", "blacksheep", HttpMethod.DELETE);
        result = executor.execute(resource, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        ResourceWithMetadata calf = this.locator.locateRelationResource(api, "cow", "calf", HttpMethod.DELETE);
        result = executor.execute(calf, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        ResourceWithMetadata flockEntityResource = this.locator.locateRelationResource(api3, "flock", "photo", HttpMethod.DELETE);
        result = executor.execute(flockEntityResource, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        calf = this.locator.locateRelationResource(api, "cow/{entityId}/calf", "photo", HttpMethod.DELETE);
        result = executor.execute(calf, Params.valueOf((String)"4", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        ResourceWithMetadata goatDelete = this.locator.locateRelationResource(api3, "goat/{entityId}/herd", "content", HttpMethod.DELETE);
        result = executor.execute(goatDelete, Params.valueOf((String)"4", (String)"56", (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testInvokePut() throws IOException {
        ResourceWithMetadata entityResource = this.locator.locateEntityResource(api, "sheep", HttpMethod.PUT);
        AbstractResourceWebScript executor = this.getExecutor("executorOfPut");
        Sheep aSheep = new Sheep("xyz");
        Object result = executor.execute(entityResource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, (Object)aSheep, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)aSheep, (Object)((ExecutionResult)result).getRoot());
        Goat goat = new Goat("xyz");
        ResourceWithMetadata cowResource = this.locator.locateEntityResource(api, "cow", HttpMethod.PUT);
        result = executor.execute(cowResource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, (Object)goat, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)goat, (Object)((ExecutionResult)result).getRoot());
        ResourceWithMetadata resource = this.locator.locateRelationResource(api, "sheep", "blacksheep", HttpMethod.PUT);
        result = executor.execute(resource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, (Object)aSheep, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)aSheep, (Object)((ExecutionResult)result).getRoot());
        ResourceWithMetadata baaPhoto = this.locator.locateRelationResource(api, "sheep/{entityId}/baaahh", "photo", HttpMethod.PUT);
        result = executor.execute(baaPhoto, Params.valueOf((String)"4", (String)"56", (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        ResourceWithMetadata flockEntityResource = this.locator.locateRelationResource(api3, "flock", "photo", HttpMethod.PUT);
        result = executor.execute(flockEntityResource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, (Object)goat, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        ResourceWithMetadata calf = this.locator.locateRelationResource(api, "cow", "calf", HttpMethod.PUT);
        result = executor.execute(calf, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, (Object)goat, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)goat, (Object)((ExecutionResult)result).getRoot());
        cowResource = this.locator.locateRelationResource(api, "cow", "photo", HttpMethod.PUT);
        result = executor.execute(cowResource, Params.valueOf((String)"654", null, (Params.RecognizedParams)NULL_PARAMS, (Object)goat, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
        calf = this.locator.locateRelationResource(api, "cow/{entityId}/calf", "photo", HttpMethod.PUT);
        result = executor.execute(calf, Params.valueOf((String)"4", (String)"56", (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), (WebScriptResponse)Mockito.mock(WebScriptResponse.class), false);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testInvokeAbstract() throws IOException {
        AbstractResourceWebScript executor = this.getExecutor();
        HashMap<String, String> templateVars = new HashMap<String, String>();
        templateVars.put("apiScope", "private");
        templateVars.put("apiVersion", "1");
        templateVars.put("apiName", "alfrescomock");
        templateVars.put("collectionResource", "sheep");
        executor.execute(ApiAssistant.determineApi(templateVars), this.mockRequest(templateVars, new HashMap<String, List<String>>(1)), (WebScriptResponse)Mockito.mock(WebScriptResponse.class));
        WebScriptResponse response = this.mockResponse();
        templateVars.put("collectionResource", "bad");
        executor.execute(api, this.mockRequest(templateVars, new HashMap<String, List<String>>(1)), response);
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setStatus(500);
        response = this.mockResponse();
        templateVars.put("entityId", "badId");
        executor.execute(api, this.mockRequest(templateVars, new HashMap<String, List<String>>(1)), response);
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setStatus(422);
    }

    @Test
    public void testInvalidUrls() throws IOException {
        AbstractResourceWebScript executor = this.getExecutor();
        HashMap<String, String> templateVars = new HashMap<String, String>();
        templateVars.put("apiScope", "private");
        templateVars.put("apiVersion", "1");
        templateVars.put("apiName", "alfrescomock");
        WebScriptResponse response = this.mockResponse();
        templateVars.put("collectionResource", "blah:");
        executor.execute(api, this.mockRequest(templateVars, new HashMap<String, List<String>>(1)), response);
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setStatus(404);
    }

    @Test
    public void testRenderError() throws IOException {
        AbstractResourceWebScript executor = this.getExecutor();
        ErrorResponse defaultError = new DefaultExceptionResolver().resolveException((Exception)new NullPointerException());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.renderErrorResponse(defaultError, this.mockResponse(out), this.apiAssistant.getJsonHelper());
        String errorMessage = out.toString();
        Assert.assertTrue((boolean)errorMessage.contains("\"errorKey\":\"framework.exception.ApiDefault\""));
        Assert.assertTrue((boolean)errorMessage.contains("\"statusCode\":500"));
        Assert.assertTrue((boolean)errorMessage.contains("\"logId\":\""));
        Assert.assertTrue((boolean)errorMessage.contains("\"stackTrace\":\"For security reasons the stack trace is no longer displayed"));
        Assert.assertTrue((boolean)errorMessage.contains("\"descriptionURL\":\"https://api-explorer.alfresco.com\""));
        ErrorResponse anError = this.simpleMappingExceptionResolver.resolveException((Exception)((Object)new ApiException("nothing")));
        out = new ByteArrayOutputStream();
        this.renderErrorResponse(anError, this.mockResponse(out), this.apiAssistant.getJsonHelper());
        errorMessage = out.toString();
        Assert.assertTrue((boolean)errorMessage.contains("\"errorKey\":\"nothing\""));
        Assert.assertTrue((boolean)errorMessage.contains("\"statusCode\":500"));
        Assert.assertTrue((boolean)errorMessage.contains("\"stackTrace\":\"For security reasons the stack trace is no longer displayed"));
        Assert.assertTrue((boolean)errorMessage.contains("\"logId\":\""));
        anError = this.simpleMappingExceptionResolver.resolveException((Exception)new EntityNotFoundException("2"));
        out = new ByteArrayOutputStream();
        this.renderErrorResponse(anError, this.mockResponse(out), this.apiAssistant.getJsonHelper());
        errorMessage = out.toString();
        System.out.println(errorMessage);
        Assert.assertTrue((boolean)errorMessage.contains("\"errorKey\":\"framework.exception.EntityNotFound\""));
        Assert.assertTrue((boolean)errorMessage.contains("\"statusCode\":404"));
        Assert.assertFalse((String)"Only 500 errors should have a logId", (boolean)errorMessage.contains("\"logId\":\" \""));
    }

    private WebScriptResponse mockResponse() throws IOException {
        return this.mockResponse(new ByteArrayOutputStream());
    }

    private WebScriptResponse mockResponse(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        WebScriptResponse res = (WebScriptResponse)Mockito.mock(WebScriptResponse.class);
        Mockito.when((Object)res.getOutputStream()).thenReturn((Object)byteArrayOutputStream);
        return res;
    }

    private WebScriptRequest mockRequest(Map<String, String> templateVars, final Map<String, List<String>> params) {
        String[] paramNames = params.keySet().toArray(new String[0]);
        WebScriptRequest request = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        Mockito.when((Object)request.getServiceMatch()).thenReturn((Object)new Match(null, templateVars, null));
        Mockito.when((Object)request.getParameterNames()).thenReturn((Object)paramNames);
        Mockito.when((Object)request.getParameterValues(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<String[]>(){

            public String[] answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return ((List)params.get((String)args[0])).toArray(new String[0]);
            }
        });
        return request;
    }
}

