/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.favourites.PersonFavourite;
import org.alfresco.repo.site.SiteDoesNotExistException;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.rest.api.Favourites;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Document;
import org.alfresco.rest.api.model.DocumentTarget;
import org.alfresco.rest.api.model.Favourite;
import org.alfresco.rest.api.model.Folder;
import org.alfresco.rest.api.model.FolderTarget;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.PathInfo;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.model.SiteTarget;
import org.alfresco.rest.api.model.Target;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.service.cmr.favourites.FavouritesService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FavouritesImpl
implements Favourites {
    private static final Log logger = LogFactory.getLog(FavouritesImpl.class);
    private People people;
    private Sites sites;
    private Nodes nodes;
    private FavouritesService favouritesService;
    private SiteService siteService;
    private NamespaceService namespaceService;
    private static final List<QName> EXCLUDED_PROPS = Arrays.asList(ContentModel.PROP_TITLE, ContentModel.PROP_DESCRIPTION, SiteModel.PROP_SITE_VISIBILITY, SiteModel.PROP_SITE_PRESET);

    public void setPeople(People people) {
        this.people = people;
    }

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setFavouritesService(FavouritesService favouritesService) {
        this.favouritesService = favouritesService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    private Target getTarget(PersonFavourite personFavourite, Parameters parameters) {
        Target target = null;
        NodeRef nodeRef = personFavourite.getNodeRef();
        FavouritesService.Type type = personFavourite.getType();
        if (type.equals((Object)FavouritesService.Type.FILE)) {
            Document document = this.nodes.getDocument(nodeRef);
            this.setPathInfo(document, parameters.getInclude());
            target = new DocumentTarget(document);
        } else if (type.equals((Object)FavouritesService.Type.FOLDER)) {
            Folder folder = this.nodes.getFolder(nodeRef);
            this.setPathInfo(folder, parameters.getInclude());
            target = new FolderTarget(folder);
        } else if (type.equals((Object)FavouritesService.Type.SITE)) {
            SiteInfo siteInfo = this.siteService.getSite(nodeRef);
            String role = this.sites.getSiteRole(siteInfo.getShortName());
            Site site = new Site(siteInfo, role);
            target = new SiteTarget(site);
        } else {
            throw new AlfrescoRuntimeException("Unexpected favourite target type: " + String.valueOf(type));
        }
        return target;
    }

    private Favourite getFavourite(PersonFavourite personFavourite, Parameters parameters) {
        Favourite fav = new Favourite();
        fav.setTargetGuid(personFavourite.getNodeRef().getId());
        fav.setCreatedAt(personFavourite.getCreatedAt());
        Target target = this.getTarget(personFavourite, parameters);
        fav.setTarget(target);
        if (parameters.getInclude().contains("properties")) {
            LinkedList<String> includeProperties = new LinkedList<String>();
            includeProperties.add("properties");
            Node node = this.nodes.getFolderOrDocument(personFavourite.getNodeRef(), null, null, includeProperties, null);
            Map<String, Object> filteredNodeProperties = this.filterProps(node.getProperties(), EXCLUDED_PROPS);
            if (filteredNodeProperties.size() > 0) {
                fav.setProperties(filteredNodeProperties);
            }
        }
        return fav;
    }

    private Map<String, Object> filterProps(Map<String, Object> properties, List<QName> toRemove) {
        HashMap<String, Object> filteredProps = properties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(properties);
        List propsToRemove = toRemove.stream().map(e -> e.toPrefixString((NamespacePrefixResolver)this.namespaceService)).collect(Collectors.toList());
        filteredProps.keySet().removeAll(propsToRemove);
        return filteredProps;
    }

    private CollectionWithPagingInfo<Favourite> wrap(Paging paging, PagingResults<PersonFavourite> personFavourites, final Parameters parameters) {
        final List page = personFavourites.getPage();
        AbstractList<Favourite> list = new AbstractList<Favourite>(){

            @Override
            public Favourite get(int index) {
                PersonFavourite personFavourite = (PersonFavourite)page.get(index);
                Favourite fav = FavouritesImpl.this.getFavourite(personFavourite, parameters);
                return fav;
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        Pair pair = personFavourites.getTotalResultCount();
        Integer total = null;
        if (((Integer)pair.getFirst()).equals(pair.getSecond())) {
            total = (Integer)pair.getFirst();
        }
        return CollectionWithPagingInfo.asPaged(paging, list, personFavourites.hasMoreItems(), total);
    }

    @Override
    public Favourite addFavourite(String personId, Favourite favourite) {
        Parameters parameters = this.getDefaultParameters(personId, null);
        return this.addFavourite(personId, favourite, parameters);
    }

    @Override
    public Favourite addFavourite(String personId, Favourite favourite, Parameters parameters) {
        Favourite ret = null;
        personId = this.people.validatePerson(personId, true);
        Target target = favourite.getTarget();
        if (target == null) {
            throw new InvalidArgumentException("target is missing");
        }
        if (target instanceof SiteTarget) {
            SiteTarget siteTarget = (SiteTarget)target;
            String guid = siteTarget.getSite().getGuid();
            SiteInfo siteInfo = this.sites.validateSite(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, guid));
            NodeRef siteNodeRef = siteInfo.getNodeRef();
            String siteId = siteInfo.getShortName();
            try {
                PersonFavourite personFavourite = this.favouritesService.addFavourite(personId, siteNodeRef);
                ret = this.getFavourite(personFavourite, parameters);
            }
            catch (SiteDoesNotExistException e) {
                throw new RelationshipResourceNotFoundException(personId, siteId);
            }
        } else if (target instanceof DocumentTarget) {
            DocumentTarget documentTarget = (DocumentTarget)target;
            NodeRef nodeRef = documentTarget.getFile().getGuid();
            if (!this.nodes.nodeMatches(nodeRef, Collections.singleton(ContentModel.TYPE_CONTENT), null)) {
                throw new RelationshipResourceNotFoundException(personId, nodeRef.getId());
            }
            PersonFavourite personFavourite = this.favouritesService.addFavourite(personId, nodeRef);
            ret = this.getFavourite(personFavourite, parameters);
        } else if (target instanceof FolderTarget) {
            FolderTarget folderTarget = (FolderTarget)target;
            NodeRef nodeRef = folderTarget.getFolder().getGuid();
            if (!this.nodes.nodeMatches(nodeRef, Collections.singleton(ContentModel.TYPE_FOLDER), Collections.singleton(SiteModel.TYPE_SITE))) {
                throw new RelationshipResourceNotFoundException(personId, nodeRef.getId());
            }
            PersonFavourite personFavourite = this.favouritesService.addFavourite(personId, nodeRef);
            ret = this.getFavourite(personFavourite, parameters);
        }
        return ret;
    }

    @Override
    public void removeFavourite(String personId, String id) {
        personId = this.people.validatePerson(personId, true);
        NodeRef nodeRef = this.nodes.validateNode(id);
        boolean exists = false;
        FavouritesService.Type type = this.favouritesService.getType(nodeRef);
        if (type.equals((Object)FavouritesService.Type.SITE)) {
            SiteInfo siteInfo = this.siteService.getSite(nodeRef);
            if (siteInfo == null) {
                throw new AlfrescoRuntimeException("Unable to find site with nodeRef " + String.valueOf(nodeRef));
            }
            exists = this.favouritesService.removeFavourite(personId, siteInfo.getNodeRef());
        } else if (type.equals((Object)FavouritesService.Type.FILE)) {
            exists = this.favouritesService.removeFavourite(personId, nodeRef);
        } else if (type.equals((Object)FavouritesService.Type.FOLDER)) {
            exists = this.favouritesService.removeFavourite(personId, nodeRef);
        }
        if (!exists) {
            throw new RelationshipResourceNotFoundException(personId, id);
        }
    }

    @Override
    public Favourite getFavourite(String personId, String favouriteId) {
        Parameters parameters = this.getDefaultParameters(personId, favouriteId);
        return this.getFavourite(personId, favouriteId, parameters);
    }

    @Override
    public Favourite getFavourite(String personId, String favouriteId, Parameters parameters) {
        NodeRef nodeRef = this.nodes.validateNode(favouriteId);
        PersonFavourite personFavourite = this.favouritesService.getFavourite(personId = this.people.validatePerson(personId, true), nodeRef);
        if (personFavourite != null) {
            Favourite favourite = this.getFavourite(personFavourite, parameters);
            return favourite;
        }
        throw new RelationshipResourceNotFoundException(personId, favouriteId);
    }

    @Override
    public CollectionWithPagingInfo<Favourite> getFavourites(String personId, Parameters parameters) {
        personId = this.people.validatePerson(personId, true);
        Paging paging = parameters.getPaging();
        List<Pair<FavouritesService.SortFields, Boolean>> sortProps = this.getSortProps(parameters);
        final HashSet filteredByClientQuery = new HashSet();
        HashSet filterTypes = FavouritesService.Type.ALL_FILTER_TYPES;
        QueryHelper.walk(parameters.getQuery(), new QueryHelper.WalkerCallbackAdapter(){

            @Override
            public void or() {
            }

            @Override
            public void exists(String filteredByClient, boolean negated) {
                if (filteredByClient != null) {
                    int idx = filteredByClient.lastIndexOf("/");
                    if (idx == -1 || idx == filteredByClient.length()) {
                        throw new InvalidArgumentException();
                    }
                    String filtertype = filteredByClient.substring(idx + 1).toUpperCase();
                    filteredByClientQuery.add(FavouritesService.Type.valueOf((String)filtertype));
                }
            }
        });
        if (filteredByClientQuery.size() > 0) {
            filterTypes = filteredByClientQuery;
        }
        PagingResults favourites = this.favouritesService.getPagedFavourites(personId, filterTypes, sortProps, Util.getPagingRequest(paging));
        return this.wrap(paging, (PagingResults<PersonFavourite>)favourites, parameters);
    }

    private void setPathInfo(Node node, List<String> includeParam) {
        if (includeParam.contains("path")) {
            PathInfo pathInfo = this.nodes.lookupPathInfo(node.getNodeRef(), null);
            node.setPath(pathInfo);
        }
    }

    private Parameters getDefaultParameters(String personId, String favouriteId) {
        Params.RecognizedParams recognizedParams = new Params.RecognizedParams(null, null, null, null, Collections.emptyList(), null, null, null, false);
        Params parameters = Params.valueOf(recognizedParams, personId, favouriteId, null);
        return parameters;
    }

    private List<Pair<FavouritesService.SortFields, Boolean>> getSortProps(Parameters parameters) {
        ArrayList<Pair<FavouritesService.SortFields, Boolean>> sortProps = new ArrayList();
        List<SortColumn> sortCols = parameters.getSorting();
        if (sortCols != null && sortCols.size() > 0) {
            for (SortColumn sortCol : sortCols) {
                FavouritesService.SortFields sortField;
                try {
                    sortField = FavouritesService.SortFields.valueOf((String)sortCol.column);
                }
                catch (Exception e) {
                    throw new InvalidArgumentException("Invalid sort field: " + sortCol.column);
                }
                sortProps.add((Pair<FavouritesService.SortFields, Boolean>)new Pair((Object)sortField, (Object)(sortCol.asc ? Boolean.TRUE : Boolean.FALSE)));
            }
        } else {
            sortProps = FavouritesService.DEFAULT_SORT_PROPS;
        }
        return sortProps;
    }
}

