/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.List;
import org.alfresco.repo.content.directurl.DirectAccessUrlDisabledException;
import org.alfresco.rest.api.DirectAccessUrlHelper;
import org.alfresco.rest.api.Renditions;
import org.alfresco.rest.api.model.DirectAccessUrlRequest;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="renditions", entityResource=NodesEntityResource.class, title="Node renditions")
public class NodeRenditionsRelation
implements RelationshipResourceAction.Read<Rendition>,
RelationshipResourceAction.ReadById<Rendition>,
RelationshipResourceAction.Create<Rendition>,
RelationshipResourceBinaryAction.Read,
RelationshipResourceAction.Delete,
InitializingBean {
    private Renditions renditions;
    private DirectAccessUrlHelper directAccessUrlHelper;

    public void setRenditions(Renditions renditions) {
        this.renditions = renditions;
    }

    public void setDirectAccessUrlHelper(DirectAccessUrlHelper directAccessUrlHelper) {
        this.directAccessUrlHelper = directAccessUrlHelper;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"renditions", (Object)this.renditions);
    }

    @Override
    public CollectionWithPagingInfo<Rendition> readAll(String nodeId, Parameters parameters) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return this.renditions.getRenditions(nodeRef, parameters);
    }

    @Override
    public Rendition readById(String nodeId, String renditionId, Parameters parameters) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return this.renditions.getRendition(nodeRef, renditionId, parameters);
    }

    @Override
    @WebApiDescription(title="Create rendition", successStatus=202)
    public List<Rendition> create(String nodeId, List<Rendition> entity, Parameters parameters) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        this.renditions.createRenditions(nodeRef, entity, parameters);
        return null;
    }

    @Override
    @WebApiDescription(title="Delete rendition")
    public void delete(String nodeId, String renditionId, Parameters parameters) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        this.renditions.deleteRendition(nodeRef, renditionId, parameters);
    }

    @Override
    @WebApiDescription(title="Download rendition", description="Download rendition")
    @BinaryProperties(value={"content"})
    public BinaryResource readProperty(String nodeId, String renditionId, Parameters parameters) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return this.renditions.getContent(nodeRef, renditionId, parameters);
    }

    @Operation(value="request-direct-access-url")
    @WebApiParam(name="directAccessUrlRequest", title="Request direct access url", description="Options for direct access url request", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request content url", description="Generates a direct access URL.", successStatus=200)
    public DirectAccessUrl requestContentDirectUrl(String nodeId, String renditionId, DirectAccessUrlRequest directAccessUrlRequest, Parameters parameters, WithResponse withResponse) {
        DirectAccessUrl directAccessUrl;
        boolean attachment = this.directAccessUrlHelper.getAttachment(directAccessUrlRequest);
        Long validFor = this.directAccessUrlHelper.getDefaultExpiryTimeInSec();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        try {
            directAccessUrl = this.renditions.requestContentDirectUrl(nodeRef, null, renditionId, attachment, validFor);
        }
        catch (DirectAccessUrlDisabledException ex) {
            throw new DisabledServiceException(ex.getMessage());
        }
        return directAccessUrl;
    }
}

