/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.util.EnumSet;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CORSContextListener
implements ServletContextListener {
    private static final String BEAN_GLOBAL_PROPERTIES = "global-properties";
    private static final String CORS_ENABLED = "cors.enabled";
    private static final String CORS_ALLOWED_ORIGINS = "cors.allowed.origins";
    private static final String CORS_ALLOWED_METHODS = "cors.allowed.methods";
    private static final String CORS_ALLOWED_HEADERS = "cors.allowed.headers";
    private static final String CORS_EXPOSED_HEADERS = "cors.exposed.headers";
    private static final String CORS_SUPPORT_CREDENTIALS = "cors.support.credentials";
    private static final String CORS_PREFLIGHT_CREDENTIALS = "cors.preflight.maxage";
    private Log logger = LogFactory.getLog(this.getClass());
    private final EnumSet<DispatcherType> DISPATCHER_TYPE = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        this.initCORS(servletContext);
    }

    private void initCORS(ServletContext servletContext) {
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        Properties gP = (Properties)wc.getBean(BEAN_GLOBAL_PROPERTIES);
        Boolean corsEnabled = new Boolean(gP.getProperty(CORS_ENABLED));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("CORS filter is" + (corsEnabled != false ? " " : " not ") + "enabled"));
        }
        if (corsEnabled.booleanValue()) {
            FilterRegistration.Dynamic corsFilter = servletContext.addFilter("CorsFilter", "org.apache.catalina.filters.CorsFilter");
            corsFilter.setInitParameter(CORS_ALLOWED_ORIGINS, gP.getProperty(CORS_ALLOWED_ORIGINS));
            corsFilter.setInitParameter(CORS_ALLOWED_METHODS, gP.getProperty(CORS_ALLOWED_METHODS));
            corsFilter.setInitParameter(CORS_ALLOWED_HEADERS, gP.getProperty(CORS_ALLOWED_HEADERS));
            corsFilter.setInitParameter(CORS_EXPOSED_HEADERS, gP.getProperty(CORS_EXPOSED_HEADERS));
            corsFilter.setInitParameter(CORS_SUPPORT_CREDENTIALS, gP.getProperty(CORS_SUPPORT_CREDENTIALS));
            corsFilter.setInitParameter(CORS_PREFLIGHT_CREDENTIALS, gP.getProperty(CORS_PREFLIGHT_CREDENTIALS));
            corsFilter.addMappingForUrlPatterns(this.DISPATCHER_TYPE, false, new String[]{"/*"});
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

