/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.Collection;
import java.util.List;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.action.access.ActionAccessRestriction;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.rule.Rule;
import org.apache.commons.collections.CollectionUtils;

@Experimental
public class ActionPermissionValidator {
    private final RuntimeActionService runtimeActionService;

    public ActionPermissionValidator(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    Rule validateRulePermissions(Rule rule) {
        List actions = ((CompositeActionImpl)rule.getAction()).getActions();
        this.checkRestrictedAccessActions(actions);
        this.checkRuleOutboundHasNoCheckOutAction(rule, actions);
        return rule;
    }

    private void checkRestrictedAccessActions(List<Action> actions) {
        actions.forEach(action -> {
            ActionAccessRestriction.setActionContext((Action)action, (String)"rule");
            this.runtimeActionService.verifyActionAccessRestrictions(action);
        });
    }

    private void checkRuleOutboundHasNoCheckOutAction(Rule rule, List<Action> actions) {
        if (CollectionUtils.isNotEmpty((Collection)rule.getRuleTypes()) && rule.getRuleTypes().contains("outbound")) {
            for (Action action : actions) {
                if (!action.getActionDefinitionName().equalsIgnoreCase("check-out")) continue;
                throw new InvalidArgumentException("cannot.create.rule.checkout.outbound");
            }
        }
    }
}

