/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.queries;

import org.alfresco.rest.api.Queries;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="queries", title="Queries")
public class QueriesEntityResource
implements EntityResourceAction.ReadById<CollectionWithPagingInfo<? extends Object>>,
InitializingBean {
    private static final String QUERY_NODES = "nodes";
    private static final String QUERY_PEOPLE = "people";
    private static final String QUERY_SITES = "sites";
    private Queries queries;

    public void setQueries(Queries queries) {
        this.queries = queries;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"queries", (Object)this.queries);
    }

    @Override
    @WebApiDescription(title="Find results", description="Find & list search results for given query id")
    public CollectionWithPagingInfo<? extends Object> readById(String queryId, Parameters parameters) {
        switch (queryId) {
            case "nodes": {
                return this.queries.findNodes(parameters);
            }
            case "people": {
                return this.queries.findPeople(parameters);
            }
            case "sites": {
                return this.queries.findSites(parameters);
            }
        }
        throw new NotFoundException(queryId);
    }
}

