/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.opencmis.OpenCMISClientContext;
import org.alfresco.opencmis.tck.tests.query.QueryForObjectCustom;
import org.alfresco.opencmis.tck.tests.query.QueryInFolderTestCustom;
import org.alfresco.opencmis.tck.tests.query.QueryLikeTestCustom;
import org.alfresco.rest.api.tests.AbstractEnterpriseOpenCMIS10TCKTest;
import org.alfresco.rest.api.tests.AlfrescoCMISBasicsTestGroup;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTestGroup;
import org.apache.chemistry.opencmis.tck.impl.JUnitHelper;
import org.apache.chemistry.opencmis.tck.tests.control.ControlTestGroup;
import org.apache.chemistry.opencmis.tck.tests.crud.CRUDTestGroup;
import org.apache.chemistry.opencmis.tck.tests.filing.FilingTestGroup;
import org.apache.chemistry.opencmis.tck.tests.query.ContentChangesSmokeTest;
import org.apache.chemistry.opencmis.tck.tests.query.QuerySmokeTest;
import org.apache.chemistry.opencmis.tck.tests.versioning.VersioningTestGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

public class TestPublicApiAtomPub10TCK
extends AbstractEnterpriseOpenCMIS10TCKTest {
    private static final String CMIS_URL = "http://{0}:{1}/{2}/api/{3}/{4}/cmis/versions/1.0/atom";
    protected static final Log logger = LogFactory.getLog(TestPublicApiAtomPub10TCK.class);

    @Before
    public void before() throws Exception {
        int port = this.getTestFixture().getJettyComponent().getPort();
        RepoService.TestNetwork network = this.getTestFixture().getRandomNetwork();
        HashMap<String, String> cmisParameters = new HashMap<String, String>();
        cmisParameters.put("org.apache.chemistry.opencmis.tck.default.relationshipType", "R:cm:replaces");
        clientContext = new OpenCMISClientContext(BindingType.ATOMPUB, MessageFormat.format(CMIS_URL, "localhost", String.valueOf(port), "alfresco", network.getId(), "public"), "admin@" + network.getId(), "admin", cmisParameters, (ApplicationContext)this.getTestFixture().getJettyComponent().getApplicationContext());
        this.overrideVersionableAspectProperties((ApplicationContext)this.getTestFixture().getJettyComponent().getApplicationContext());
    }

    @AfterClass
    public static void shutdown() throws Exception {
    }

    @Test
    public void testCMISTCKBasics() throws Exception {
        AlfrescoCMISBasicsTestGroup basicsTestGroup = new AlfrescoCMISBasicsTestGroup();
        JUnitHelper.run((CmisTestGroup)basicsTestGroup);
    }

    @Test
    public void testCMISTCKCRUD() throws Exception {
        CRUDTestGroup crudTestGroup = new CRUDTestGroup();
        JUnitHelper.run((CmisTestGroup)crudTestGroup);
    }

    @Test
    public void testCMISTCKVersioning() throws Exception {
        VersioningTestGroup versioningTestGroup = new VersioningTestGroup();
        JUnitHelper.run((CmisTestGroup)versioningTestGroup);
    }

    @Test
    public void testCMISTCKFiling() throws Exception {
        FilingTestGroup filingTestGroup = new FilingTestGroup();
        JUnitHelper.run((CmisTestGroup)filingTestGroup);
    }

    @Test
    public void testCMISTCKControl() throws Exception {
        ControlTestGroup controlTestGroup = new ControlTestGroup();
        JUnitHelper.run((CmisTestGroup)controlTestGroup);
    }

    @Test
    @Category(value={LuceneTests.class, RedundantTests.class})
    public void testCMISTCKQuery() throws Exception {
        OverrideQueryTestGroup queryTestGroup = new OverrideQueryTestGroup();
        JUnitHelper.run((CmisTestGroup)queryTestGroup);
    }

    private class OverrideQueryTestGroup
    extends AbstractSessionTestGroup {
        private OverrideQueryTestGroup() {
        }

        public void init(Map<String, String> parameters) throws Exception {
            super.init(parameters);
            this.setName("Query Test Group");
            this.setDescription("Query and content changes tests.");
            this.addTest((CmisTest)new QuerySmokeTest());
            this.addTest((CmisTest)new QueryForObjectCustom());
            this.addTest((CmisTest)new QueryLikeTestCustom());
            this.addTest((CmisTest)new QueryInFolderTestCustom());
            this.addTest((CmisTest)new ContentChangesSmokeTest());
        }
    }
}

