/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.SiteContainer;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSiteContainers
extends EnterpriseTestApi {
    private RepoService.TestNetwork network1;
    private RepoService.TestNetwork network2;
    private List<RepoService.TestPerson> people1 = new ArrayList<RepoService.TestPerson>(2);
    private List<RepoService.TestPerson> people2 = new ArrayList<RepoService.TestPerson>(2);
    private RepoService.TestPerson person11;
    private RepoService.TestPerson person12;
    private RepoService.TestPerson person13;
    private RepoService.TestPerson person21;
    private RepoService.TestSite site1;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().getNetworksIt();
        Assert.assertTrue((boolean)networksIt.hasNext());
        this.network1 = networksIt.next();
        Assert.assertTrue((boolean)networksIt.hasNext());
        this.network2 = networksIt.next();
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person1 = TestSiteContainers.this.network1.createUser();
                TestSiteContainers.this.people1.add(person1);
                RepoService.TestPerson person2 = TestSiteContainers.this.network1.createUser();
                TestSiteContainers.this.people1.add(person2);
                RepoService.TestPerson person3 = TestSiteContainers.this.network1.createUser();
                TestSiteContainers.this.people1.add(person3);
                return null;
            }
        }, (String)this.network1.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person1 = TestSiteContainers.this.network2.createUser();
                TestSiteContainers.this.people2.add(person1);
                return null;
            }
        }, (String)this.network2.getId());
        this.person11 = this.people1.get(0);
        this.person12 = this.people1.get(1);
        this.person21 = this.people2.get(0);
        this.person13 = this.people1.get(2);
        this.site1 = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite testSite = TestSiteContainers.this.network1.createSite(SiteVisibility.PUBLIC);
                return testSite;
            }
        }, (String)this.person11.getId(), (String)this.network1.getId());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Map<String, NodeRef>>(){

            public Map<String, NodeRef> doWork() throws Exception {
                HashMap<String, NodeRef> containers = new HashMap<String, NodeRef>();
                containers.put("test1", TestSiteContainers.this.site1.createContainer("test1"));
                containers.put("test2", TestSiteContainers.this.site1.createContainer("test2"));
                containers.put("test3", TestSiteContainers.this.site1.createContainer("test3"));
                return containers;
            }
        }, (String)this.person11.getId(), (String)this.network1.getId());
    }

    @Test
    public void testSiteContainers() throws Exception {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        List<SiteContainer> expectedSiteContainers = this.network1.getSiteContainers(this.site1.getSiteId(), this.person11);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        int skipCount = 0;
        int maxItems = 2;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedSiteContainers.size(), expectedSiteContainers.size());
        PublicApiClient.ListResponse<SiteContainer> resp = sitesProxy.getSiteContainers(this.site1.getSiteId(), this.createParams(paging, null));
        this.checkList(expectedSiteContainers.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 2;
        maxItems = expectedSiteContainers.size();
        paging = this.getPaging(skipCount, maxItems, expectedSiteContainers.size(), expectedSiteContainers.size());
        resp = sitesProxy.getSiteContainers(this.site1.getSiteId(), this.createParams(paging, null));
        this.checkList(expectedSiteContainers.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 2;
        maxItems = expectedSiteContainers.size() + 2;
        paging = this.getPaging(skipCount, maxItems, expectedSiteContainers.size(), expectedSiteContainers.size());
        resp = sitesProxy.getSiteContainers(this.site1.getSiteId(), this.createParams(paging, null));
        this.checkList(expectedSiteContainers.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        SiteContainer expectedSiteContainer = new SiteContainer(this.site1.getSiteId(), "test2", null);
        SiteContainer sc = sitesProxy.getSingleSiteContainer(this.site1.getSiteId(), "test2");
        this.check(expectedSiteContainer, sc);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.getSingleSiteContainer("gfyuosfgsf8y7s", "documentLibrary");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.getSingleSiteContainer(this.site1.getSiteId(), "container1");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            skipCount = 0;
            maxItems = 2;
            paging = this.getPaging(skipCount, maxItems, expectedSiteContainers.size(), expectedSiteContainers.size());
            sitesProxy.getSiteContainers(GUID.generate(), this.createParams(paging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person12.getId()));
        skipCount = 0;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems, expectedSiteContainers.size(), expectedSiteContainers.size());
        PublicApiClient.ListResponse<SiteContainer> ret = sitesProxy.getSiteContainers(this.site1.getSiteId(), this.createParams(paging, null));
        this.checkList(expectedSiteContainers.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), ret);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person21.getId()));
            skipCount = 0;
            maxItems = 2;
            paging = this.getPaging(skipCount, maxItems, expectedSiteContainers.size(), expectedSiteContainers.size());
            sitesProxy.getSiteContainers(this.site1.getSiteId(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person12.getId()));
        skipCount = 0;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems, expectedSiteContainers.size(), expectedSiteContainers.size());
        ret = sitesProxy.getSiteContainers(this.site1.getSiteId(), this.createParams(paging, null));
        this.checkList(expectedSiteContainers.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), ret);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person13.getId()));
        skipCount = 0;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems, expectedSiteContainers.size(), expectedSiteContainers.size());
        resp = sitesProxy.getSiteContainers(this.site1.getSiteId(), this.createParams(paging, null));
        this.checkList(expectedSiteContainers.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        try {
            sitesProxy.create("sites", this.site1.getSiteId(), "containers", null, null, "Unable to POST to site containers");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            sitesProxy.create("sites", this.site1.getSiteId(), "containers", "documentLibrary", null, "Unable to POST to a site container");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            sitesProxy.update("sites", this.site1.getSiteId(), "containers", null, null, "Unable to PUT site containers");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            sitesProxy.update("sites", this.site1.getSiteId(), "containers", "documentLibrary", null, "Unable to PUT a site container");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            sitesProxy.remove("sites", this.site1.getSiteId(), "containers", null, "Unable to DELETE site containers");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            sitesProxy.remove("sites", this.site1.getSiteId(), "containers", "documentLibrary", "Unable to DELETE a site container");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
    }
}

