/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class WebDAVHelperIntegrationTest {
    private static ApplicationContext ctx;
    private WebDAVHelper webDAVHelper;
    private FileFolderService fileFolderService;
    private NodeRef rootNodeRef;
    private NodeRef rootFolder;
    private NodeService nodeService;

    @BeforeClass
    public static void setUpSpring() {
        ctx = ApplicationContextHelper.getApplicationContext();
    }

    @Before
    public void setUp() {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.webDAVHelper = (WebDAVHelper)ctx.getBean("webDAVHelper");
        this.fileFolderService = (FileFolderService)ctx.getBean("FileFolderService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        StoreRef storeRef = this.nodeService.createStore("workspace", "WebDAVHelperTest-" + String.valueOf(UUID.randomUUID()));
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.rootFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER).getChildRef();
    }

    @Test
    public void canGetNodeForPathWithCorrectCase() throws FileNotFoundException {
        FileInfo folderInfo = this.fileFolderService.create(this.rootFolder, "my_folder", ContentModel.TYPE_FOLDER);
        FileInfo fileInfo = this.fileFolderService.create(folderInfo.getNodeRef(), "my_file.txt", ContentModel.TYPE_CONTENT);
        FileInfo found = this.webDAVHelper.getNodeForPath(this.rootFolder, "my_folder/my_file.txt");
        Assert.assertEquals((Object)fileInfo, (Object)found);
        found = this.webDAVHelper.getNodeForPath(this.rootFolder, "my_folder");
        Assert.assertEquals((Object)folderInfo, (Object)found);
    }

    @Test
    public void cannotGetNodeForPathWithIncorrectCase() throws FileNotFoundException {
        FileInfo folderInfo = this.fileFolderService.create(this.rootFolder, "my_folder", ContentModel.TYPE_FOLDER);
        this.fileFolderService.create(folderInfo.getNodeRef(), "my_file.txt", ContentModel.TYPE_CONTENT);
        try {
            this.webDAVHelper.getNodeForPath(this.rootFolder, "My_Folder/My_File.txt");
            Assert.fail((String)"FileNotFoundException should have been thrown.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void cannotGetNodeForFolderPathWithIncorrectCase() throws FileNotFoundException {
        FileInfo folderInfo = this.fileFolderService.create(this.rootFolder, "my_folder", ContentModel.TYPE_FOLDER);
        this.fileFolderService.create(folderInfo.getNodeRef(), "my_file.txt", ContentModel.TYPE_CONTENT);
        try {
            this.webDAVHelper.getNodeForPath(this.rootFolder, "My_Folder");
            Assert.fail((String)"FileNotFoundException should have been thrown.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void canGetNodeForRootFolderPath() throws FileNotFoundException {
        FileInfo folderInfo = this.fileFolderService.create(this.rootFolder, "my_folder", ContentModel.TYPE_FOLDER);
        this.fileFolderService.create(folderInfo.getNodeRef(), "my_file.txt", ContentModel.TYPE_CONTENT);
        FileInfo found = this.webDAVHelper.getNodeForPath(this.rootFolder, "/");
        Assert.assertEquals((Object)this.rootFolder, (Object)found.getNodeRef());
    }
}

