/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.activities;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class TemplatesWebScript
extends DeclarativeWebScript {
    private SearchPath searchPath;

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        int idx;
        String path = "/";
        Object templatePattern = "*.ftl";
        String p = req.getExtensionPath();
        if (p != null && p.length() > 0 && (idx = p.lastIndexOf("/")) != -1) {
            path = p.substring(0, idx);
            templatePattern = p.substring(idx + 1) + ".ftl";
        }
        HashSet<String> templatePaths = new HashSet<String>();
        for (Store apiStore : this.searchPath.getStores()) {
            try {
                for (String templatePath : apiStore.getDocumentPaths(path, false, (String)templatePattern)) {
                    templatePaths.add(templatePath);
                }
            }
            catch (IOException e) {
                throw new WebScriptException("Failed to search for templates from store " + String.valueOf(apiStore), (Throwable)e);
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("paths", templatePaths);
        return model;
    }
}

